/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.privileges;

import java.util.Objects;
import java.util.Set;
import org.gridgain.internal.rbac.privileges.Privilege;

public final class PrivilegeCheckResult {
    private final Set<Privilege> missedPrivileges;
    private final boolean allowed;

    private PrivilegeCheckResult(Set<Privilege> missedPrivileges, boolean allowed) {
        this.missedPrivileges = missedPrivileges;
        this.allowed = allowed;
    }

    public static PrivilegeCheckResult allowed() {
        return new PrivilegeCheckResult(Set.of(), true);
    }

    public static PrivilegeCheckResult denied(Set<Privilege> negativePrivileges) {
        return new PrivilegeCheckResult(negativePrivileges, false);
    }

    public Set<Privilege> missedPrivileges() {
        return this.missedPrivileges;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegeCheckResult that = (PrivilegeCheckResult)o;
        return this.allowed == that.allowed && Objects.equals(this.missedPrivileges, that.missedPrivileges);
    }

    public int hashCode() {
        return Objects.hash(this.missedPrivileges, this.allowed);
    }

    public String toString() {
        return "PrivilegeCheckResult{missedPrivileges=" + this.missedPrivileges + ", allowed=" + this.allowed + "}";
    }
}

