/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.privileges;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.gridgain.internal.rbac.privileges.ObjectType;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.Selector;
import org.jetbrains.annotations.Nullable;

public class ObjectTree {
    private static final ObjectNode CLUSTER_NODE = new ObjectNode(null, ObjectType.CLUSTER);
    private static final ObjectNode SCHEMA_NODE = new ObjectNode(CLUSTER_NODE, ObjectType.SCHEMA);
    private static final Set<ObjectNode> leafs = Set.of(CLUSTER_NODE, new ObjectNode(CLUSTER_NODE, ObjectType.DEPLOYMENT_UNIT), new ObjectNode(CLUSTER_NODE, ObjectType.USER), SCHEMA_NODE, new ObjectNode(SCHEMA_NODE, ObjectType.TABLE), new ObjectNode(SCHEMA_NODE, ObjectType.VIEW), new ObjectNode(SCHEMA_NODE, ObjectType.SEQUENCE));

    @Nullable
    static Privilege findParent(Privilege privilege) {
        ObjectType targetObjectType = privilege.selector().objectType();
        if (targetObjectType == ObjectType.CLUSTER) {
            return null;
        }
        if (targetObjectType == ObjectType.SCHEMA) {
            return Privilege.builderFrom(privilege).selector(Selector.cluster()).build();
        }
        if (targetObjectType == ObjectType.TABLE || targetObjectType == ObjectType.VIEW || targetObjectType == ObjectType.SEQUENCE) {
            return Privilege.builderFrom(privilege).selector(Selector.schema(privilege.selector().schemaName())).build();
        }
        if (targetObjectType == ObjectType.USER || targetObjectType == ObjectType.DEPLOYMENT_UNIT) {
            return Privilege.builderFrom(privilege).selector(Selector.cluster()).build();
        }
        return null;
    }

    static Set<ObjectType> findAncestors(ObjectType objectType) {
        if (objectType == ObjectType.CLUSTER) {
            return Set.of();
        }
        ObjectNode objectNode = leafs.stream().filter(leaf -> leaf.objectType == objectType).findFirst().orElseThrow();
        EnumSet<ObjectType> relativeTypes = EnumSet.noneOf(ObjectType.class);
        while (objectNode.parent != null) {
            relativeTypes.add(objectNode.objectType);
            objectNode = objectNode.parent;
        }
        relativeTypes.add(objectNode.objectType);
        return relativeTypes;
    }

    static boolean isRoot(Privilege privilege) {
        return privilege.action().applicableObjectType() == ObjectType.CLUSTER;
    }

    public static Set<Privilege> findParents(Privilege child) {
        HashSet<Privilege> parents = new HashSet<Privilege>();
        Privilege currentParent = ObjectTree.findParent(child);
        while (currentParent != null) {
            parents.add(currentParent);
            currentParent = ObjectTree.findParent(currentParent);
        }
        return parents;
    }

    static class ObjectNode {
        @Nullable
        private final ObjectNode parent;
        private final ObjectType objectType;

        ObjectNode(@Nullable ObjectNode parent, ObjectType objectType) {
            this.parent = parent;
            this.objectType = objectType;
        }
    }
}

