/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr.catalog;

import java.util.List;
import java.util.Set;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.SwitchTableAccessCommand;
import org.apache.ignite.internal.catalog.commands.SwitchTableAccessCommandBuilder;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.gridgain.internal.pitr.TableName;
import org.gridgain.internal.pitr.catalog.CommandState;

public class TablesAccessCommand
implements CatalogCommand {
    private final Set<TableName> tableNames;
    private final boolean lock;

    public static TablesAccessCommand lock(Set<TableName> tableNames) {
        return new TablesAccessCommand(tableNames, true);
    }

    public static TablesAccessCommand unlock(Set<TableName> tableNames) {
        return new TablesAccessCommand(tableNames, false);
    }

    private TablesAccessCommand(Set<TableName> tableNames, boolean lock) {
        this.tableNames = tableNames;
        this.lock = lock;
    }

    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CommandState commandState = new CommandState(catalog, updateContext.catalogService());
        for (TableName tableName : this.tableNames) {
            String schema = tableName.schema();
            String name = tableName.name();
            CatalogSchemaDescriptor schemaDescriptor = CatalogUtils.schemaOrThrow((Catalog)catalog, (String)schema);
            CatalogTableDescriptor tableDescriptor = schemaDescriptor.table(name);
            if (tableDescriptor == null || tableDescriptor.cache()) continue;
            CatalogCommand lockCommand = ((SwitchTableAccessCommandBuilder)((SwitchTableAccessCommandBuilder)SwitchTableAccessCommand.builder().schemaName(schemaDescriptor.name())).tableName(tableDescriptor.name())).lock(this.lock).build();
            commandState.applyCommand(lockCommand);
        }
        return commandState.updateEntries();
    }
}

