/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr.message;

import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.gridgain.internal.pitr.message.PointInTimeRecoveryMessagesFactory;
import org.gridgain.internal.pitr.message.PointInTimeRecoveryMessagesTypeInfos;
import org.gridgain.internal.pitr.message.RecoveryResponseMessage;
import org.gridgain.internal.pitr.message.RecoveryResponseMessageBuilder;

class RecoveryResponseMessageDeserializer
implements MessageDeserializer<RecoveryResponseMessage> {
    private final RecoveryResponseMessageBuilder msg;

    RecoveryResponseMessageDeserializer(PointInTimeRecoveryMessagesFactory messageFactory) {
        this.msg = messageFactory.recoveryResponseMessage();
    }

    public Class<RecoveryResponseMessage> klass() {
        return RecoveryResponseMessage.class;
    }

    public RecoveryResponseMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PointInTimeRecoveryMessagesTypeInfos.recoveryResponseMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                UUID tmp = reader.readUuid("operationId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.operationId(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RecoveryResponseMessage.class);
    }
}

