/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr.message;

import java.util.Set;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.gridgain.internal.pitr.message.PointInTimeRecoveryMessagesFactory;
import org.gridgain.internal.pitr.message.PointInTimeRecoveryMessagesTypeInfos;
import org.gridgain.internal.pitr.message.RecoveryRequestMessage;
import org.gridgain.internal.pitr.message.RecoveryRequestMessageBuilder;

class RecoveryRequestMessageDeserializer
implements MessageDeserializer<RecoveryRequestMessage> {
    private final RecoveryRequestMessageBuilder msg;

    RecoveryRequestMessageDeserializer(PointInTimeRecoveryMessagesFactory messageFactory) {
        this.msg = messageFactory.recoveryRequestMessage();
    }

    public Class<RecoveryRequestMessage> klass() {
        return RecoveryRequestMessage.class;
    }

    public RecoveryRequestMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PointInTimeRecoveryMessagesTypeInfos.recoveryRequestMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Set tmp = reader.readSet("tableNames", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.tableNames(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                long tmp = reader.readLong("timestampLong");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.timestampLong(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RecoveryRequestMessage.class);
    }
}

