/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Flow;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite.internal.components.NodeProperties;
import org.apache.ignite.internal.distributionzones.DistributionZoneManager;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.impl.MetaStorageManagerImpl;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.partition.replicator.PartitionReplicaLifecycleManager;
import org.apache.ignite.internal.replicator.ReplicaManager;
import org.apache.ignite.internal.replicator.configuration.ReplicationConfiguration;
import org.apache.ignite.internal.table.distributed.TableManager;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.gridgain.internal.lock.OperationLock;
import org.gridgain.internal.pitr.PitrManager;
import org.gridgain.internal.pitr.configuration.NodePitrConfiguration;
import org.gridgain.internal.pitr.message.PointInTimeRecoveryMessagesFactory;
import org.gridgain.internal.pitr.metastorage.PitrMetaStorageKeys;

public class PitrManagerContext
implements ManuallyCloseable {
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final PointInTimeRecoveryMessagesFactory messagesFactory = new PointInTimeRecoveryMessagesFactory();
    private final ClusterService clusterService;
    private final MetaStorageManagerImpl metaStorageManager;
    private final CatalogManager catalogManager;
    private final TableManager tableManager;
    private final TxManager txManager;
    private final DistributionZoneManager distributionZoneManager;
    private final LogicalTopologyService logicalTopologyService;
    private final HybridClock clock;
    private final ReplicationConfiguration replicationConfiguration;
    private final ReplicaManager replicaManager;
    private final PartitionReplicaLifecycleManager partitionReplicaLifecycleManager;
    private final NodeProperties nodeProperties;
    private final ThreadPoolExecutor threadPool;

    PitrManagerContext(NodePitrConfiguration pitrConfiguration, ClusterService clusterService, MetaStorageManagerImpl metaStorageManager, CatalogManager catalogManager, TableManager tableManager, TxManager txManager, DistributionZoneManager distributionZoneManager, LogicalTopologyService logicalTopologyService, HybridClock clock, ReplicationConfiguration replicationConfiguration, ReplicaManager replicaManager, PartitionReplicaLifecycleManager partitionReplicaLifecycleManager, NodeProperties nodeProperties) {
        this.clusterService = clusterService;
        this.metaStorageManager = metaStorageManager;
        this.catalogManager = catalogManager;
        this.tableManager = tableManager;
        this.txManager = txManager;
        this.distributionZoneManager = distributionZoneManager;
        this.logicalTopologyService = logicalTopologyService;
        this.clock = clock;
        this.replicationConfiguration = replicationConfiguration;
        this.replicaManager = replicaManager;
        this.partitionReplicaLifecycleManager = partitionReplicaLifecycleManager;
        this.nodeProperties = nodeProperties;
        int threadPoolSize = (Integer)pitrConfiguration.threadPoolSize().value();
        this.threadPool = new ThreadPoolExecutor(threadPoolSize, threadPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)IgniteThreadFactory.create((String)clusterService.nodeName(), (String)"gg-pitr", (IgniteLogger)Loggers.forClass(PitrManager.class), (ThreadOperation[])new ThreadOperation[]{ThreadOperation.STORAGE_READ, ThreadOperation.STORAGE_WRITE}));
        this.threadPool.allowCoreThreadTimeOut(true);
    }

    public ClusterService clusterService() {
        return this.clusterService;
    }

    public MessagingService messagingService() {
        return this.clusterService.messagingService();
    }

    public PointInTimeRecoveryMessagesFactory messagesFactory() {
        return this.messagesFactory;
    }

    public TopologyService topology() {
        return this.clusterService.topologyService();
    }

    public MetaStorageManagerImpl metaStorageManager() {
        return this.metaStorageManager;
    }

    public ThreadPoolExecutor threadPool() {
        return this.threadPool;
    }

    public TableManager tableManager() {
        return this.tableManager;
    }

    public TxManager txManager() {
        return this.txManager;
    }

    public DistributionZoneManager distributionZoneManager() {
        return this.distributionZoneManager;
    }

    public LogicalTopologyService logicalTopologyService() {
        return this.logicalTopologyService;
    }

    public CatalogManager catalogManager() {
        return this.catalogManager;
    }

    public HybridClock clock() {
        return this.clock;
    }

    public ReplicationConfiguration replicationConfiguration() {
        return this.replicationConfiguration;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public PartitionReplicaLifecycleManager partitionReplicaLifecycleManager() {
        return this.partitionReplicaLifecycleManager;
    }

    public NodeProperties nodeProperties() {
        return this.nodeProperties;
    }

    public IgniteSpinBusyLock busyLock() {
        return this.busyLock;
    }

    public void close() {
        this.busyLock.block();
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.threadPool, (long)30L, (TimeUnit)TimeUnit.SECONDS);
    }

    public String nodeName() {
        return this.clusterService.nodeName();
    }

    public CompletableFuture<Void> startOperation() {
        return OperationLock.PITR.start((MetaStorageManager)this.metaStorageManager()).thenApplyAsync(Function.identity(), (Executor)this.threadPool());
    }

    public CompletableFuture<Void> stopOperation() {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(this::anyPitrLockPrefixes, this.threadPool()).thenCompose(Function.identity())).thenApplyAsync(anyLocks -> {
            if (!anyLocks.booleanValue()) {
                return OperationLock.PITR.stop((MetaStorageManager)this.metaStorageManager());
            }
            return CompletableFutures.nullCompletedFuture();
        }, (Executor)this.threadPool())).thenComposeAsync(Function.identity(), (Executor)this.threadPool());
    }

    private CompletableFuture<Boolean> anyPitrLockPrefixes() {
        final CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        this.metaStorageManager().prefix(PitrMetaStorageKeys.pitrLockPrefix()).subscribe(new Flow.Subscriber<Entry>(){
            private Flow.Subscription subscription;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                subscription.request(1L);
            }

            @Override
            public void onNext(Entry item) {
                result.complete(true);
                this.subscription.cancel();
            }

            @Override
            public void onError(Throwable throwable) {
                result.completeExceptionally(throwable);
            }

            @Override
            public void onComplete() {
                result.complete(false);
            }
        });
        return result;
    }
}

