/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr.metastorage;

import java.io.Serializable;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.gridgain.internal.pitr.TableName;
import org.gridgain.internal.pitr.metastorage.PitrProgress;
import org.gridgain.internal.pitr.metastorage.PitrStatus;
import org.jetbrains.annotations.Nullable;

public class PitrGlobalState
implements Serializable {
    public static final int UNKNOWN_CATALOG_VERSION = -1;
    private static final long serialVersionUID = -5744591784488250270L;
    private final PitrStatus status;
    private final UUID operationId;
    @IgniteToStringInclude
    private final Set<String> nodeNames;
    private final Set<TableName> tables;
    private final HybridTimestamp timestamp;
    private final String description;
    private final int catalogVersion;
    @Nullable
    private final PitrProgress progress;

    public PitrGlobalState(PitrStatus status, UUID operationId, Set<String> nodeNames, Set<TableName> tableNames, HybridTimestamp timestamp, String description, int catalogVersion, @Nullable PitrProgress progress) {
        this.status = status;
        this.operationId = operationId;
        this.nodeNames = Set.copyOf(nodeNames);
        this.tables = tableNames;
        this.timestamp = timestamp;
        this.description = description;
        this.catalogVersion = catalogVersion;
        this.progress = progress;
    }

    public UUID operationId() {
        return this.operationId;
    }

    public PitrStatus status() {
        return this.status;
    }

    public Set<String> nodeNames() {
        return this.nodeNames;
    }

    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    public long timestampLong() {
        return this.timestamp.longValue();
    }

    public Set<TableName> tables() {
        return this.tables;
    }

    public String description() {
        return this.description;
    }

    public int catalogVersion() {
        return this.catalogVersion;
    }

    @Nullable
    public PitrProgress progress() {
        return this.progress;
    }

    public String toString() {
        return S.toString(PitrGlobalState.class, (Object)this);
    }
}

