/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr.message;

import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.gridgain.internal.pitr.message.PointInTimeRecoveryMessagesTypeInfos;
import org.gridgain.internal.pitr.message.StateResponseMessage;
import org.gridgain.internal.pitr.message.StateResponseMessageImpl;

class StateResponseMessageSerializer
implements MessageSerializer<StateResponseMessage> {
    public static final StateResponseMessageSerializer INSTANCE = new StateResponseMessageSerializer();

    private StateResponseMessageSerializer() {
    }

    public boolean writeMessage(StateResponseMessage msg, MessageWriter writer) throws MessageMappingException {
        StateResponseMessageImpl message = (StateResponseMessageImpl)msg;
        writer.setMessageTypeInfo(PointInTimeRecoveryMessagesTypeInfos.stateResponseMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)3)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeString("description", message.description());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeMap("progress", message.progress(), MessageCollectionItemType.STRING, MessageCollectionItemType.LONG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                int idShifted = message.status() == null ? 0 : message.status().id() + 1;
                boolean written = writer.writeInt("status", idShifted);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

