/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr.catalog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.ColumnParams;
import org.apache.ignite.internal.catalog.commands.CreateHashIndexCommand;
import org.apache.ignite.internal.catalog.commands.CreateHashIndexCommandBuilder;
import org.apache.ignite.internal.catalog.commands.CreateSortedIndexCommand;
import org.apache.ignite.internal.catalog.commands.CreateSortedIndexCommandBuilder;
import org.apache.ignite.internal.catalog.commands.CreateTableCommand;
import org.apache.ignite.internal.catalog.commands.CreateTableCommandBuilder;
import org.apache.ignite.internal.catalog.commands.TableHashPrimaryKey;
import org.apache.ignite.internal.catalog.commands.TablePrimaryKey;
import org.apache.ignite.internal.catalog.commands.TableSortedPrimaryKey;
import org.apache.ignite.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.sql.ColumnType;
import org.gridgain.internal.pitr.TableName;
import org.gridgain.internal.pitr.catalog.CommandState;

public class CreateTempTablesCommand
implements CatalogCommand {
    private final String prefix;
    private final Collection<TableName> tableNames;
    private final Catalog catalogToRestore;

    public CreateTempTablesCommand(String prefix, Collection<TableName> tableNames, Catalog catalogToRestore) {
        this.prefix = prefix;
        this.tableNames = tableNames;
        this.catalogToRestore = catalogToRestore;
    }

    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CommandState commandState = new CommandState(catalog, updateContext.catalogService());
        this.createTablesAndIndices(commandState);
        return commandState.updateEntries();
    }

    private void createTablesAndIndices(CommandState commandState) {
        for (TableName tableName : this.tableNames) {
            String schema = tableName.schema();
            String name = tableName.name();
            CatalogSchemaDescriptor schemaDescriptor = CatalogUtils.schemaOrThrow((Catalog)this.catalogToRestore, (String)schema);
            CatalogTableDescriptor tableDescriptor = schemaDescriptor.table(name);
            if (tableDescriptor == null || tableDescriptor.cache()) continue;
            String newTableName = this.prefix + tableDescriptor.name();
            CatalogCommand createTableCommand = this.createTableCommand(schemaDescriptor, tableDescriptor, newTableName);
            commandState.applyCommand(createTableCommand);
            for (CatalogIndexDescriptor indexDescriptor : this.catalogToRestore.indexes(tableDescriptor.id())) {
                if (tableDescriptor.primaryKeyIndexId() == indexDescriptor.id()) continue;
                String newIndexName = this.prefix + indexDescriptor.name();
                CatalogCommand createIndexCommand = this.createIndexCommand(schemaDescriptor, indexDescriptor, newTableName, newIndexName);
                commandState.applyCommand(createIndexCommand);
            }
        }
    }

    private CatalogCommand createTableCommand(CatalogSchemaDescriptor schema, CatalogTableDescriptor table, String newTableName) {
        String zoneName = this.catalogToRestore.zone(table.zoneId()).name();
        return ((CreateTableCommandBuilder)((CreateTableCommandBuilder)CreateTableCommand.builder().tableName(newTableName)).schemaName(schema.name())).zone(zoneName).columns(table.columns().stream().map(CreateTempTablesCommand::toColumnParams).collect(Collectors.toList())).primaryKey(CreateTempTablesCommand.primaryKey(this.catalogToRestore, table)).colocationColumns(table.colocationColumns()).storageProfile(table.storageProfile()).secondaryStorageProfile(table.secondaryStorageProfile()).expireColumn(table.expireColumn()).archiveColumn(table.archiveColumn()).build();
    }

    private CatalogCommand createIndexCommand(CatalogSchemaDescriptor schema, CatalogIndexDescriptor index, String newTableName, String newIndexName) {
        if (index instanceof CatalogHashIndexDescriptor) {
            return ((CreateHashIndexCommandBuilder)((CreateHashIndexCommandBuilder)((CreateHashIndexCommandBuilder)((CreateHashIndexCommandBuilder)((CreateHashIndexCommandBuilder)CreateHashIndexCommand.builder().indexName(newIndexName)).tableName(newTableName)).schemaName(schema.name())).unique(index.unique())).columns(((CatalogHashIndexDescriptor)index).columns())).build();
        }
        if (index instanceof CatalogSortedIndexDescriptor) {
            ArrayList columnNames = new ArrayList();
            ArrayList collations = new ArrayList();
            ((CatalogSortedIndexDescriptor)index).columns().forEach(c -> {
                columnNames.add(c.name());
                collations.add(c.collation());
            });
            return ((CreateSortedIndexCommandBuilder)((CreateSortedIndexCommandBuilder)((CreateSortedIndexCommandBuilder)((CreateSortedIndexCommandBuilder)((CreateSortedIndexCommandBuilder)CreateSortedIndexCommand.builder().indexName(newIndexName)).tableName(newTableName)).schemaName(schema.name())).unique(index.unique())).columns(columnNames)).collations(collations).build();
        }
        throw new IllegalArgumentException("Unknown index descriptor type: " + String.valueOf(index.getClass()));
    }

    private static ColumnParams toColumnParams(CatalogTableColumnDescriptor c) {
        ColumnType type = c.type();
        ColumnParams.Builder builder = ColumnParams.builder().name(c.name()).precision(type.precisionAllowed() ? Integer.valueOf(c.precision()) : null).type(type).length(type.lengthAllowed() ? Integer.valueOf(c.length()) : null).nullable(c.nullable()).scale(type.scaleAllowed() ? Integer.valueOf(c.scale()) : null);
        if (c.defaultValue() != null) {
            builder.defaultValue(c.defaultValue());
        }
        return builder.build();
    }

    private static TablePrimaryKey primaryKey(Catalog catalogToRestore, CatalogTableDescriptor table) {
        CatalogIndexDescriptor index = catalogToRestore.index(table.primaryKeyIndexId());
        assert (index != null);
        if (index instanceof CatalogHashIndexDescriptor) {
            return TableHashPrimaryKey.builder().columns(((CatalogHashIndexDescriptor)index).columns()).build();
        }
        if (index instanceof CatalogSortedIndexDescriptor) {
            ArrayList columnNames = new ArrayList();
            ArrayList collations = new ArrayList();
            ((CatalogSortedIndexDescriptor)index).columns().forEach(c -> {
                columnNames.add(c.name());
                collations.add(c.collation());
            });
            return TableSortedPrimaryKey.builder().columns(columnNames).collations(collations).build();
        }
        throw new IllegalArgumentException("Unknown primary index descriptor type: " + String.valueOf(index.getClass()));
    }
}

