/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.table.TableImpl;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.table.distributed.PartitionSet;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.gridgain.internal.pitr.MvPartitionDataProvider;
import org.gridgain.internal.pitr.PitrManagerContext;
import org.gridgain.internal.pitr.PitrUtils;
import org.gridgain.internal.pitr.exception.PitrException;
import org.gridgain.internal.pitr.metastorage.PitrStateContext;
import org.gridgain.internal.recovery.PartitionsCalculator;
import org.gridgain.internal.recovery.RaftLogTruncater;
import org.gridgain.internal.recovery.RecoveryManager;
import org.gridgain.internal.recovery.RecoveryRequest;
import org.gridgain.internal.recovery.RecoveryTransactions;
import org.gridgain.internal.recovery.TableDataProvider;
import org.gridgain.internal.recovery.TableInfo;
import org.gridgain.internal.recovery.TooOldTransactionException;
import org.gridgain.internal.recovery.progress.RecoveryProgressHandler;

public class PitrReader {
    private final PitrManagerContext context;
    private final PartitionsCalculator partitionsCalculator;
    private final RecoveryManager recoveryManager;
    private final RecoveryTransactions transactions;

    public PitrReader(PitrManagerContext context) {
        this.context = context;
        this.partitionsCalculator = new PartitionsCalculator(context.nodeName(), (MetaStorageManager)context.metaStorageManager(), context.nodeProperties());
        RaftLogTruncater raftLogTruncater = new RaftLogTruncater(context.nodeName(), context.tableManager(), context.partitionReplicaLifecycleManager(), context.replicaManager(), context.nodeProperties(), context.busyLock());
        this.recoveryManager = new RecoveryManager(tableId -> (TableImpl)context.tableManager().cachedTable(tableId), arg_0 -> ((RaftLogTruncater)raftLogTruncater).truncateRaftLog(arg_0));
        this.transactions = new RecoveryTransactions(context.txManager());
    }

    public CompletableFuture<Long> recover(PitrStateContext pitrContext, RecoveryProgressHandler handler) {
        return pitrContext.inBusyLockAsync(() -> {
            try {
                return this.transactions.runInReadOnlyTransaction(pitrContext.state().timestamp(), transaction -> this.createRecoveryRequest(pitrContext, handler, (InternalTransaction)transaction).thenComposeAsync(arg_0 -> ((RecoveryManager)this.recoveryManager).process(arg_0), (Executor)this.context.threadPool()));
            }
            catch (TooOldTransactionException e) {
                throw new PitrException("Recovery requested at timestamp which is below the current low watermark: " + e.getMessage(), e);
            }
        });
    }

    private CompletableFuture<RecoveryRequest> createRecoveryRequest(PitrStateContext pitrContext, RecoveryProgressHandler handler, InternalTransaction transaction) {
        List<CatalogTableDescriptor> tableDescriptors = this.tableDescriptors(pitrContext);
        return this.partitionsCalculator.calculatePartitions(tableDescriptors, pitrContext.causalityToken()).thenApplyAsync(partitions -> RecoveryRequest.builder().id(pitrContext.state().operationId()).tables(this.tableInfos(tableDescriptors, pitrContext, transaction, (Map<Integer, PartitionSet>)partitions)).timestampToRecovery(this.context.clock().now()).threadPool((ExecutorService)this.context.threadPool()).recoveryBatchSize(((Integer)this.context.replicationConfiguration().batchSizeBytes().value()).intValue()).lastInChain(true).handler(handler).build(), (Executor)this.context.threadPool());
    }

    private List<TableInfo> tableInfos(List<CatalogTableDescriptor> tableDescriptors, PitrStateContext pitrContext, InternalTransaction transaction, Map<Integer, PartitionSet> partitions) {
        Catalog catalog = this.context.catalogManager().catalog(pitrContext.state().catalogVersion());
        HybridTimestamp requestedTs = pitrContext.state().timestamp();
        ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>(tableDescriptors.size());
        InternalClusterNode thisNode = this.context.topology().localMember();
        for (CatalogTableDescriptor tableDescriptor : tableDescriptors) {
            String tempTableName = PitrUtils.tmpTableName(tableDescriptor.name());
            CatalogSchemaDescriptor schemaDescriptor = catalog.schema(tableDescriptor.schemaId());
            assert (schemaDescriptor != null) : IgniteStringFormatter.format((String)"Schema not found: {}", (Object[])new Object[]{tableDescriptor.schemaId()});
            CatalogTableDescriptor tempTableDescriptor = schemaDescriptor.table(tempTableName);
            assert (tempTableDescriptor != null) : IgniteStringFormatter.format((String)"Temp table not found: {}", (Object[])new Object[]{tempTableName});
            TableViewInternal table = this.context.tableManager().cachedTable(tableDescriptor.id());
            assert (table != null) : IgniteStringFormatter.format((String)"Source table not found: {}", (Object[])new Object[]{tableDescriptor.name()});
            MvPartitionDataProvider dataProvider = new MvPartitionDataProvider(table, requestedTs, thisNode, transaction);
            tableInfos.add(new TableInfo((TableDataProvider)dataProvider, null, partitions.get(this.context.nodeProperties().colocationEnabled() ? tableDescriptor.zoneId() : tableDescriptor.id()), tempTableDescriptor.id(), tempTableDescriptor.zoneId()));
        }
        return tableInfos;
    }

    private List<CatalogTableDescriptor> tableDescriptors(PitrStateContext pitrContext) {
        Catalog requestedCatalog = this.context.catalogManager().activeCatalog(pitrContext.state().timestampLong());
        return pitrContext.tables().stream().map(tableName -> {
            CatalogSchemaDescriptor schemaDescriptor = requestedCatalog.schema(tableName.schema());
            assert (schemaDescriptor != null) : IgniteStringFormatter.format((String)"Schema not found: {}", (Object[])new Object[]{tableName.schema()});
            CatalogTableDescriptor tableDescriptor = schemaDescriptor.table(tableName.name());
            assert (tableDescriptor != null) : IgniteStringFormatter.format((String)"Table not found: {}", (Object[])new Object[]{tableName});
            return tableDescriptor;
        }).collect(Collectors.toList());
    }
}

