/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.apache.ignite.IgniteSystemProperties;
import org.gridgain.database.utility.Utils;
import org.gridgain.database.utility.commands.CommandRemote;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.visor.database.snapshot.VisorCreateSnapshotTask;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotCreateParams;

public class CommandSnapshot
extends CommandRemote {
    public CommandSnapshot() {
        this.supportedArgs.add("-CACHES");
        this.supportedArgs.add("-EXCLUDED_CACHES");
        this.supportedArgs.add("-DEST");
        this.supportedArgs.add("-TYPE");
        this.supportedArgs.add("-NOPROGRESS");
        this.supportedArgs.add("-PROGRESS");
        this.supportedArgs.add("-VERBOSE");
        this.supportedArgs.add("-COMMENT");
        this.supportedArgs.add("-ARCHIVE");
        this.supportedArgs.add("-COMPRESSION_LEVEL");
        this.supportedArgs.add("-PARALLELISM");
        this.supportedArgs.add("-WRITE_THROTTLING");
        this.supportedArgs.add("-NEEDEXCHANGE");
        this.supportedArgs.add("-ENCRYPTION_KEY");
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command will create full or incremental snapshot for all or specified caches.");
        this.addHelpUsage("[-type=full|inc]", "[-caches=cache1,cache2,...,cacheN]", this.optional("-dest=EXTERNAL_FOLDER"), "[-verbose]", this.optional("-needexchange"), this.optional("-parallelism=4"), this.optional("-archive=NONE|ZIP"), this.optional("-compression_level=5"));
        this.addHelpExample();
        this.addHelpExample("-type=full");
        this.addHelpExample("-type=inc");
        this.addHelpExample("-type=full", "-ssl_enabled -ssl_protocol=SSLv23 -ssl_algorithm=SunX509 -ssl_truststore_type=jks -ssl_truststore_path=/path/to/truststore.jks -ssl_truststore_password=<PASSWORD> -ssl_key_store_type=pkcs12 -ssl_key_store_path=/path/to/keystore.pkcs12 -ssl_key_store_password=<PASSWORD>");
        this.addHelpExample("-type=full", "-caches=cache1,cache2", "-host=192.168.1.10");
        this.addHelpExample("-type=full", "-dest=/snapshots/2017/01");
        this.addHelpExample("-type=full", "-host=192.168.1.10");
        this.addHelpExample("-type=full", "-verbose");
        this.addHelpExample("-type=full", "-needexchange");
        this.addHelpExample("-type=full", "-output=my_file.txt");
        this.addHelpArguments();
        this.addHelpIndent("-type=full|inc - create snapshot of specified type: full or incremental").NL();
        this.addHelpIndent("-caches=cache1,...,cacheN,group1,...,groupK - list of cache or group names to process.").NL();
        this.addHelpIndent("-excluded_caches=cache1,...,cacheN,group1,...groupK  - list of cache or group names excluded from processing.").NL();
        this.addHelpIndent("-dest=EXTERNAL_FOLDER - folder name where snapshot files should be moved.").NL();
        this.addHelpIndent("-noprogress - do not print progress bar.").NL();
        this.addHelpIndent("-progress=DELAY - delay (sec) for progress bar update, default is 5 sec.").NL();
        this.addHelpIndent("-verbose - this argument enable verbose mode, for example, cache names.").NL();
        this.addHelpIndent("-parallelism=N - determines parallel execution (threads) of snapshot operation, 1 to N").NL();
        this.addHelpIndent(HELP_ARG_ARCHIVE).NL();
        this.addHelpIndent(HELP_ARG_COMPRESSION_LEVEL).NL();
        this.addHelpIndent("-write_throttling=N - this argument enables write throttling. Snapshot write speed will be throttled when reached N bytes per second on each node. Only non-negative values are supported, default value is 0 - no throttling.").NL();
        this.addHelpIndent("-needexchange - this argument allows to trigger snapshot creation in legacy mode with exchange.").NL();
        this.addHelpIndent("-encryption_key=MASTER_KEY_NAME - this argument specifies a master key that will be used for snapshot encryption.").NL();
        this.addHelpCommonArgs();
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorCommon();
        this.addHelpError(520, "concurrent snapshot operations are not allowed cluster-wide.");
        this.addHelpError(530, "can't create incremental snapshot, no full snapshots found. Please use -type=full option to create a full snapshot");
        this.addHelpError(531, "can not create incremental snapshot, previous snapshots are different on cluster nodes, possible solution - try to create full snapshot.");
        this.addHelpError(600, "snapshot utility failed to find cache with specified name.");
        this.addHelpError(710, "snapshot utility failed to move snapshot to destination folder.");
        this.addHelpError(770, "invalid compression level, should be between 1 and 9.");
        this.addHelpError(780, "compression level couldn't be applied, cause compression is off.");
        this.addHelpErrorOutput();
    }

    @Override
    public String name() {
        return "SNAPSHOT";
    }

    @Override
    public int errorBase() {
        return 4000;
    }

    private Collection<String> prepareTextOutput(VisorSnapshotInfo snap, boolean verbose) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(String.valueOf(snap.getSnapshotId()));
        lines.add("Snapshot created:");
        lines.add("  Cluster: " + snap.getClusterName());
        lines.add("  ID: " + snap.getSnapshotId());
        lines.add("  Created: " + Utils.snapshotCreationDate(snap.getSnapshotId()));
        lines.add("  Type: " + Utils.snapshotType(snap.isFullSnapshot()));
        lines.add("  Parallelism: " + this.snapshotParallelism(snap));
        lines.add("  CompressionOption: " + this.snapshotCompressionOption(snap));
        lines.add("  CompressionLevel: " + this.snapshotCompressionLevel(snap));
        lines.add("  Need exchange: " + (Optional.ofNullable(snap.getSnapshotCreateParams()).map(SnapshotCreateParams::exchangelessSnapshot).orElse(IgniteSystemProperties.getBoolean((String)"GG_EXCHANGELESS_SNAPSHOT_CREATION", (boolean)true)) == false));
        lines.add("  Initiator: " + snap.getInitiatorNodeId());
        lines.add("  Session: " + this.ses);
        lines.add("  Caches:");
        lines.add("    Count: " + snap.getCacheNames().size());
        if (verbose) {
            lines.add("    Names: " + snap.getCacheNames().toString());
        }
        return lines;
    }

    private void printToOutputJson(VisorSnapshotInfo snap) throws IOException {
        ObjectNode json = MAPPER.createObjectNode();
        json.put("cluster", snap.getClusterName());
        json.put("id", snap.getSnapshotId());
        json.put("created", Utils.snapshotCreationDate(snap.getSnapshotId()));
        json.put("type", Utils.snapshotType(snap.isFullSnapshot()));
        json.put("parallelism", String.valueOf(this.snapshotParallelism(snap)));
        json.put("compressionOption", this.snapshotCompressionOption(snap));
        json.put("compressionLevel", this.snapshotCompressionLevel(snap));
        json.put("needExchange", Optional.ofNullable(snap.getSnapshotCreateParams()).map(SnapshotCreateParams::exchangelessSnapshot).orElse(IgniteSystemProperties.getBoolean((String)"GG_EXCHANGELESS_SNAPSHOT_CREATION", (boolean)true)) == false);
        json.put("initiator", snap.getInitiatorNodeId().toString());
        json.put("session", this.ses);
        this.addJsonCaches(json, snap.getCacheNames());
        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
    }

    private void printToOutput(VisorSnapshotInfo snap, boolean verbose) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareTextOutput(snap, verbose));
                break;
            }
            case "JSON": {
                this.printToOutputJson(snap);
                break;
            }
        }
    }

    @Override
    protected int executeCmd() throws Throwable {
        String snapType = this.stringArg("-TYPE", "inc");
        int parallelism = this.intArg("-PARALLELISM", 2);
        CompressionOption compressionOption = CompressionOption.valueOf((String)this.stringArg("-ARCHIVE", CompressionOption.NONE.name()));
        int compressionLevel = this.intArg("-COMPRESSION_LEVEL", -1);
        int writeThrottlingThreshold = this.intArg("-WRITE_THROTTLING", 0);
        boolean full = "full".equalsIgnoreCase(snapType);
        if (!full && !"inc".equalsIgnoreCase(snapType)) {
            throw new IllegalArgumentException("Invalid value for argument '-type': " + snapType);
        }
        VisorSnapshotInfo snap = (VisorSnapshotInfo)this.execute(VisorCreateSnapshotTask.class, new VisorSnapshotInfo.Builder().withSnapshotId(-1L).withFullSnapshot(full).withPaths(this.singletonListArg("-DEST")).withCacheNames(this.listArg("-CACHES")).withExcludedCacheNames(this.listArg("-EXCLUDED_CACHES")).withMessage(this.message()).withSnapshotCommonParameters(new SnapshotCommonParameters(parallelism)).withSnapshotCreateParams(new SnapshotCreateParams(compressionOption, compressionLevel, writeThrottlingThreshold, !this.booleanArg("-NEEDEXCHANGE", !IgniteSystemProperties.getBoolean((String)"GG_EXCHANGELESS_SNAPSHOT_CREATION", (boolean)true)), null, this.stringArg("-ENCRYPTION_KEY", null))).build());
        this.printToConsole(this.prepareTextOutput(snap, this.hasArg("-VERBOSE")));
        this.printToOutput(snap, true);
        return 0;
    }
}

