/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility.commands;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.database.utility.Utils;
import org.gridgain.database.utility.commands.CommandRemote;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfo;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfoTask;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotNode;
import org.jetbrains.annotations.Nullable;

public class CommandInfo
extends CommandRemote {
    public CommandInfo() {
        this.supportedArgs.add("-ID");
        this.supportedArgs.add("-SRC");
        this.supportedArgs.add("-KEY_ALIAS");
        this.supportedArgs.add("-VERBOSE");
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command will print detailed information about specified snapshot.");
        this.addHelpUsage("-id=SNAPSHOT_ID", "[-src=path1[,path2,...,pathN]]", "[-verbose]");
        this.addHelpExample();
        this.addHelpExample("-id=1234567");
        this.addHelpExample("-id=1234567", "-ssl_enabled -ssl_protocol=SSLv23 -ssl_algorithm=SunX509 -ssl_truststore_type=jks -ssl_truststore_path=/path/to/truststore.jks -ssl_truststore_password=<PASSWORD> -ssl_key_store_type=pkcs12 -ssl_key_store_path=/path/to/keystore.pkcs12 -ssl_key_store_password=<PASSWORD>");
        this.addHelpExample("-id=1234567", "-src=/snapshots/2016/12,/snapshots/2017/01");
        this.addHelpExample("-id=1234567", "-src=/snapshots/2016/12,/snapshots/2017/01", "-key_alias=my_sftp");
        this.addHelpExample("-id=1234567", "-host=192.168.1.10");
        this.addHelpExample("-id=1234567", "-output=my_file.txt");
        this.addHelpExample("-id=1234567", "-output=my_file.txt", "-format=json");
        this.addHelpExample("-id=1234567", "-verbose");
        this.addHelpArguments();
        this.addHelpIndent("-id=SNAPSHOT_ID - snapshot identifier to use.").NL();
        this.addHelpIndent("-src=path1[,path2,...,pathN] - list of optional folders to search for snapshot files.").NL();
        this.addHelpIndent("-key_alias=alias - alias for JKS key for working with SFTP server.").NL();
        this.addHelpIndent("-verbose - this argument enable verbose mode, for example, cache names.").NL();
        this.addHelpCommonArgs();
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorCommon();
        this.addHelpError(500, "snapshot utility failed to find snapshot with specified ID.");
        this.addHelpErrorOutput();
    }

    @Override
    public String name() {
        return "INFO";
    }

    @Override
    public int errorBase() {
        return 3000;
    }

    @Override
    protected int executeCmd() throws Throwable {
        long id = this.longArg("-ID", -1L);
        if (id < 0L) {
            throw new IllegalArgumentException("Snapshot ID was not specified");
        }
        boolean verbose = this.hasArg("-VERBOSE");
        VisorSnapshotInfo snapshot = (VisorSnapshotInfo)this.execute(VisorSnapshotInfoTask.class, new VisorSnapshotInfo.Builder().withSnapshotId(id).withPaths(this.listArg("-SRC")).withKeyAlias(this.stringArg("-KEY_ALIAS", null)).withMessage(this.message()).build());
        this.printToOutput(snapshot, verbose);
        this.printToConsole(this.prepareTextOutput(snapshot, verbose));
        return 0;
    }

    private void printToOutput(VisorSnapshotInfo snapshot, boolean verbose) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareTextOutput(snapshot, verbose));
                break;
            }
            case "JSON": {
                this.printToOutputJson(snapshot, verbose);
                break;
            }
        }
    }

    private Collection<String> prepareTextOutput(VisorSnapshotInfo snapshot, boolean verbose) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Snapshot info:");
        lines.add("  ID: " + snapshot.getSnapshotId());
        lines.add("  Created: " + Utils.snapshotCreationDate(snapshot.getSnapshotId()));
        lines.add("  Type: " + Utils.snapshotType(snapshot.isFullSnapshot()));
        lines.add("  Size: " + U.humanReadableByteCount((long)snapshot.getSize()));
        lines.add("  Product versions: " + snapshot.getClusterNodesVersions());
        if (snapshot.getWalSize() > 0L) {
            lines.add("  WAL Size: " + U.humanReadableByteCount((long)snapshot.getWalSize()));
        }
        lines.add("  Compression: " + this.snapshotCompressionOption(snapshot));
        lines.add("  Compression Level: " + this.snapshotCompressionLevel(snapshot));
        if (!F.isEmpty((String)snapshot.getMasterKeyName())) {
            lines.add("  Master key name: " + snapshot.getMasterKeyName());
        }
        lines.add("  Initiator: " + this.initiator(snapshot));
        lines.add("Message: " + snapshot.getMessage());
        Set snapshotFolders = SnapshotUtils.getSnapshotFolders((Map)snapshot.attributes());
        if (!snapshotFolders.isEmpty()) {
            String s = "Cluster wide snapshot folder: ";
            if (snapshotFolders.size() == 1) {
                lines.add(s + (String)snapshotFolders.iterator().next());
            } else {
                lines.add(s);
                for (String snapshotFolder : snapshotFolders) {
                    lines.add("  " + snapshotFolder);
                }
            }
        }
        Collection<VisorSnapshotNode> snapshotNodes = this.snapshotNodes(snapshot);
        lines.add("Nodes:");
        lines.add("  Size: " + snapshotNodes.size());
        for (VisorSnapshotNode node : snapshotNodes) {
            Map attrs;
            Object object = node.getConsistentId();
            lines.add("  Node:");
            lines.add("    ConsistenceID: " + object);
            lines.add("    Addresses: " + node.getAddresses());
            lines.add("    Host names: " + node.getHostNames());
            if (!snapshotFolders.isEmpty() || !Objects.nonNull(attrs = snapshot.getSnapshotAttributes(object))) continue;
            lines.add("    Snapshots folder: " + (String)attrs.get("SNAPSHOT_DIR"));
        }
        if (verbose) {
            lines.add("Topology:");
            lines.add("  Size: " + snapshot.getClusterSize());
            lines.add("  Baseline: " + this.baselineTopology(snapshot));
            Collection baselineConsistentIds = snapshot.getBaselineConsistentIds();
            for (VisorSnapshotNode visorSnapshotNode : snapshot.getClusterNodes()) {
                Map attrs;
                Object nodeConsistentId = visorSnapshotNode.getConsistentId();
                lines.add("  Node:");
                lines.add("    ID: " + visorSnapshotNode.getId());
                lines.add("    ConsistenceID: " + nodeConsistentId);
                lines.add("    Client: " + visorSnapshotNode.isClient());
                lines.add("    Addresses: " + visorSnapshotNode.getAddresses());
                lines.add("    Host names: " + visorSnapshotNode.getHostNames());
                lines.add("    Baseline: " + baselineConsistentIds.contains(nodeConsistentId));
                if (visorSnapshotNode.getVersion() != null) {
                    lines.add("    Version: " + visorSnapshotNode.getVersion());
                }
                if (!snapshotFolders.isEmpty() || !Objects.nonNull(attrs = snapshot.getSnapshotAttributes(nodeConsistentId))) continue;
                lines.add("    Snapshots folder: " + (String)attrs.get("SNAPSHOT_DIR"));
            }
        }
        lines.add("Caches:");
        lines.add("  Count: " + snapshot.getCacheNames().size());
        lines.add("  Names: " + this.sorted(snapshot.getCacheNames()));
        Map prevSnapshots = snapshot.getPreviousSnapshots();
        if (!F.isEmpty((Map)prevSnapshots)) {
            lines.add("Previous snapshots:");
            for (Map.Entry entry : prevSnapshots.entrySet()) {
                lines.add("  ID: " + entry.getKey());
                Set<String> caches = this.sorted((Collection)entry.getValue());
                lines.add("  Caches:");
                lines.add("    Count: " + caches.size());
                lines.add("    Names: " + caches);
            }
        }
        return lines;
    }

    private void printToOutputJson(VisorSnapshotInfo snapshot, boolean verbose) throws IOException {
        ObjectNode rootNode = MAPPER.createObjectNode();
        ObjectNode json = rootNode.putObject("snapshot");
        json.put("id", snapshot.getSnapshotId());
        json.put("created", Utils.snapshotCreationDate(snapshot.getSnapshotId()));
        json.put("type", Utils.snapshotType(snapshot.isFullSnapshot()));
        json.put("size", U.humanReadableByteCount((long)snapshot.getSize()));
        List versions = snapshot.getClusterNodesVersions().stream().map(Object::toString).collect(Collectors.toList());
        ArrayNode jsonVersions = (ArrayNode)MAPPER.valueToTree(versions);
        json.putArray("productVersions").addAll(jsonVersions);
        if (snapshot.getWalSize() > 0L) {
            json.put("walSize", U.humanReadableByteCount((long)snapshot.getWalSize()));
        }
        json.put("compressionOption", this.snapshotCompressionOption(snapshot));
        json.put("compressionLevel", this.snapshotCompressionLevel(snapshot));
        if (!F.isEmpty((String)snapshot.getMasterKeyName())) {
            json.put("masterKeyName", snapshot.getMasterKeyName());
        }
        json.put("initiator", String.valueOf(this.initiator(snapshot)));
        json.put("message", snapshot.getMessage());
        Set snapshotFolder = SnapshotUtils.getSnapshotFolders((Map)snapshot.attributes());
        if (!snapshotFolder.isEmpty()) {
            json.putArray("snapshotFolder").addAll((ArrayNode)MAPPER.valueToTree((Object)snapshotFolder));
        }
        Collection<VisorSnapshotNode> snapshotNodes = this.snapshotNodes(snapshot);
        json.put("nodeSize", snapshotNodes.size());
        ArrayNode jsonNodeArr = json.putArray("nodes");
        for (VisorSnapshotNode snapshotNode : snapshotNodes) {
            Map map;
            ObjectNode jsonNode = jsonNodeArr.addObject();
            Object consistentId = snapshotNode.getConsistentId();
            jsonNode.put("consistenceId", String.valueOf(consistentId));
            this.addCollectionToJson(jsonNode, "addresses", snapshotNode.getAddresses());
            this.addCollectionToJson(jsonNode, "hosts", snapshotNode.getHostNames());
            if (!snapshotFolder.isEmpty() || !Objects.nonNull(map = snapshot.getSnapshotAttributes(consistentId))) continue;
            jsonNode.put("snapshotFolder", (String)map.get("SNAPSHOT_DIR"));
        }
        if (verbose) {
            ObjectNode jsonTop = json.putObject("topology");
            jsonTop.put("size", snapshot.getClusterSize());
            jsonTop.put("baseline", this.baselineTopologyInt(snapshot));
            ArrayNode jsonTopNodeArr = jsonTop.putArray("nodes");
            Collection baselineConsistentIds = snapshot.getBaselineConsistentIds();
            for (VisorSnapshotNode visorSnapshotNode : snapshot.getClusterNodes()) {
                Map attrs;
                ObjectNode jsonNode = jsonTopNodeArr.addObject();
                Object consistentId = visorSnapshotNode.getConsistentId();
                jsonNode.put("id", String.valueOf(visorSnapshotNode.getId()));
                jsonNode.put("consistenceId", String.valueOf(consistentId));
                jsonNode.put("client", visorSnapshotNode.isClient());
                this.addCollectionToJson(jsonNode, "addresses", visorSnapshotNode.getAddresses());
                this.addCollectionToJson(jsonNode, "hosts", visorSnapshotNode.getHostNames());
                jsonNode.put("baseline", baselineConsistentIds.contains(consistentId));
                if (visorSnapshotNode.getVersion() != null) {
                    jsonNode.put("version", visorSnapshotNode.getVersion().toString());
                }
                if (!snapshotFolder.isEmpty() || !Objects.nonNull(attrs = snapshot.getSnapshotAttributes(consistentId))) continue;
                jsonNode.put("snapshotFolder", (String)attrs.get("SNAPSHOT_DIR"));
            }
        }
        this.addJsonCaches(json, snapshot.getCacheNames());
        Map prevSnapshots = snapshot.getPreviousSnapshots();
        if (!F.isEmpty((Map)prevSnapshots)) {
            ObjectNode jsonPrev = json.putObject("previous");
            jsonPrev.put("count", prevSnapshots.size());
            ArrayNode jsonPrevSnapshots = jsonPrev.putArray("snapshots");
            for (Map.Entry entry : prevSnapshots.entrySet()) {
                ObjectNode jsonPrevSnapshot = jsonPrevSnapshots.addObject();
                jsonPrevSnapshot.put("id", (Long)entry.getKey());
                this.addJsonCaches(jsonPrevSnapshot, (Collection)entry.getValue());
            }
        }
        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode));
    }

    @Nullable
    private Object initiator(VisorSnapshotInfo visorSnapshotInfo) {
        UUID initiatorNodeId = visorSnapshotInfo.getInitiatorNodeId();
        if (Objects.nonNull(initiatorNodeId)) {
            for (VisorSnapshotNode node : visorSnapshotInfo.getClusterNodes()) {
                if (!initiatorNodeId.equals(node.getId())) continue;
                return node.getConsistentId();
            }
        }
        return null;
    }

    private Collection<VisorSnapshotNode> snapshotNodes(VisorSnapshotInfo visorSnapshotInfo) {
        Collection baselineConsistentIds = visorSnapshotInfo.getBaselineConsistentIds();
        return visorSnapshotInfo.getClusterNodes().stream().filter(node -> baselineConsistentIds.contains(node.getConsistentId())).collect(Collectors.toList());
    }
}

