/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility.commands;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionCountersIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.gridgain.database.utility.commands.CommandDirect;
import org.gridgain.database.utility.commands.CommandMetadata;
import org.gridgain.database.utility.commands.LocalSnapshotPartitionData;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CacheSnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInputStream;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.snapshot.file.FileSnapshotInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandAnalyze
extends CommandDirect {
    private static final JdkMarshaller jdkMarshaller = new JdkMarshaller();
    private static final String CSV_HEADER = "Consistent ID, Group ID, Partition ID, Encryption, Partition state, Update counter, Total partition size, Cache ID, Cache partition size";
    private static final String ARG_PAGE_SIZE = "-PAGE_SIZE";
    private static final String HELP_USAGE_PAGE_SIZE = "[-page_size=4096]";
    private static final String HELP_EXAMPLE_PAGE_SIZE = "-page_size=4096";
    private static final String HELP_ARG_PAGE_SIZE = "-page_size=4096 - snapshot page size.";

    public CommandAnalyze() {
        this.supportedArgs.add("-OUTPUT");
        this.supportedArgs.add("-FORMAT");
        this.supportedArgs.add("-SRC");
        this.supportedArgs.add("-ID");
        this.supportedArgs.add(ARG_PAGE_SIZE);
        this.supportedArgs.add("-VERBOSE");
    }

    @Override
    public String name() {
        return "ANALYZE";
    }

    @Override
    public int errorBase() {
        return 15000;
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command will analyze snapshot with specified ID and write result into specified output file.");
        this.addHelpUsage("-src=SNAPSHOT_FOLDER", "-id=SNAPSHOT_ID", HELP_USAGE_PAGE_SIZE, "[-verbose]");
        this.addHelpExample("-src=SNAPSHOT_FOLDER1", "-id=1234567", HELP_EXAMPLE_PAGE_SIZE, "-verbose", "-ssl_enabled -ssl_protocol=SSLv23 -ssl_algorithm=SunX509 -ssl_truststore_type=jks -ssl_truststore_path=/path/to/truststore.jks -ssl_truststore_password=<PASSWORD> -ssl_key_store_type=pkcs12 -ssl_key_store_path=/path/to/keystore.pkcs12 -ssl_key_store_password=<PASSWORD>");
        this.addHelpArguments();
        this.addHelpIndent("-src=SNAPSHOT_FOLDER - path to folder with snapshot.").NL();
        this.addHelpIndent("-id=SNAPSHOT_ID - snapshot identifier to use.").NL();
        this.addHelpIndent(HELP_ARG_PAGE_SIZE).NL();
        this.addHelpIndent("-verbose - enable operation progress showing.").NL();
        this.addHelpCommonArgs(true);
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorOutput();
    }

    private Collection<String> prepareTextOutput(File[] consIdFolders, SnapshotMetadataV2 metadata, int pageSize) {
        ArrayList<String> lines = new ArrayList<String>();
        boolean verbose = this.hasArg("-VERBOSE");
        lines.add(CSV_HEADER);
        for (File consIdFolder : consIdFolders) {
            File[] grpFolders = consIdFolder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && !"wal".equals(pathname.getName());
                }
            });
            assert (grpFolders != null);
            int grpIdx = 1;
            String consId = consIdFolder.getName();
            for (File grpFolder : grpFolders) {
                if (verbose) {
                    log.info("Processing group: [{}/{}]", (Object)grpIdx, (Object)grpFolders.length);
                }
                File[] partFiles = grpFolder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return !pathname.isDirectory() && pathname.getName().contains("part-");
                    }
                });
                assert (partFiles != null);
                int partIdx = 1;
                int grpId = Integer.parseInt(grpFolder.getName());
                boolean isGrpEncrypted = metadata != null && ((CacheSnapshotMetadata)metadata.cacheGroupsMetadata().get(grpId)).isEncryptionEnabled();
                for (File partFile : partFiles) {
                    block23: {
                        if (verbose) {
                            log.info("Processing partition: [{}/{}]", (Object)partIdx, (Object)partFiles.length);
                        }
                        if (partFile.length() == 0L) {
                            if (verbose) {
                                log.info("Empty partition file {}", (Object)partFile.getAbsolutePath());
                            }
                            ++partIdx;
                            continue;
                        }
                        String partIdStr = partFile.getName().replaceAll("\\D", "");
                        int partId = Integer.parseInt(partIdStr);
                        boolean optimizedCompressedEncryption = isGrpEncrypted && metadata.encryptionOptions().optimizedCompressedEncryption();
                        try (SnapshotInputStream input = FileSnapshotInputStream.of((File)partFile, (int)partId, (int)pageSize, (String)consId, (boolean)optimizedCompressedEncryption);){
                            LocalSnapshotPartitionData partData = isGrpEncrypted ? this.readEncryptedPartitionData(consId, grpId, partId) : this.readPartitionData(input, grpId, partId, consId, pageSize);
                            lines.addAll(this.toTextLine(partData));
                        }
                        catch (Exception e) {
                            if (!log.isInfoEnabled()) break block23;
                            log.info("Unable to read partition file " + partFile.getAbsolutePath(), (Throwable)e);
                        }
                    }
                    ++partIdx;
                }
                ++grpIdx;
            }
        }
        return lines;
    }

    @NotNull
    private LocalSnapshotPartitionData readEncryptedPartitionData(String consId, int grpId, int partId) {
        return new LocalSnapshotPartitionData(consId, grpId, partId, 0L, 0L, GridDhtPartitionState.MOVING, null, true);
    }

    private void printToOutputJson(File[] consIdFolders, @Nullable SnapshotMetadataV2 metadata, int pageSize) throws IOException {
        ArrayNode json = MAPPER.createArrayNode();
        boolean verbose = this.hasArg("-VERBOSE");
        for (File consIdFolder : consIdFolders) {
            File[] grpFolders = consIdFolder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && !"wal".equals(pathname.getName());
                }
            });
            assert (grpFolders != null);
            int grpIdx = 1;
            String consId = consIdFolder.getName();
            for (File grpFolder : grpFolders) {
                if (verbose) {
                    log.info("Processing group: [{}/{}]", (Object)grpIdx, (Object)grpFolders.length);
                }
                File[] partFiles = grpFolder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return !pathname.isDirectory() && pathname.getName().contains("part-");
                    }
                });
                assert (partFiles != null);
                int partIdx = 1;
                int grpId = Integer.parseInt(grpFolder.getName());
                boolean isGrpEncrypted = metadata != null && ((CacheSnapshotMetadata)metadata.cacheGroupsMetadata().get(grpId)).isEncryptionEnabled();
                boolean optimizedCompressedEncryption = isGrpEncrypted && metadata.encryptionOptions().optimizedCompressedEncryption();
                for (File partFile : partFiles) {
                    if (verbose) {
                        log.info("Processing partition: [{}/{}]", (Object)partIdx, (Object)partFiles.length);
                    }
                    String partIdStr = partFile.getName().replaceAll("\\D", "");
                    int partId = Integer.parseInt(partIdStr);
                    try (SnapshotInputStream input = FileSnapshotInputStream.of((File)partFile, (int)partId, (int)pageSize, (String)consId, (boolean)optimizedCompressedEncryption);){
                        LocalSnapshotPartitionData partData = isGrpEncrypted ? this.readEncryptedPartitionData(consId, grpId, partId) : this.readPartitionData(input, grpId, partId, consId, pageSize);
                        json.add((JsonNode)this.toJsonObject(partData));
                    }
                    catch (Exception e) {
                        log.info("Unable to read partition file " + partFile.getAbsolutePath(), (Throwable)e);
                    }
                    ++partIdx;
                }
                ++grpIdx;
            }
        }
        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
    }

    private void printToOutput(File[] consIdFolders, @Nullable SnapshotMetadataV2 metadata, int pageSize) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareTextOutput(consIdFolders, metadata, pageSize));
                break;
            }
            case "JSON": {
                this.printToOutputJson(consIdFolders, metadata, pageSize);
                break;
            }
        }
    }

    private LocalSnapshotPartitionData readPartitionData(SnapshotInputStream input, int grpId, int partId, String consId, int pageSize) throws IOException, IgniteCheckedException {
        long PAGE_BUF_PTR = GridUnsafe.allocateMemory((long)pageSize);
        ByteBuffer PAGE_BUF = GridUnsafe.wrapPointer((long)PAGE_BUF_PTR, (int)pageSize);
        LocalSnapshotPartitionData res = null;
        long nextCntrPageId = 0L;
        HashMap<Long, byte[]> savedCntrPages = new HashMap<Long, byte[]>();
        while (input.readNextPage(PAGE_BUF)) {
            PAGE_BUF.flip();
            int type = PageIO.getType((long)PAGE_BUF_PTR);
            switch (type) {
                case 14: {
                    PagePartitionMetaIO io = (PagePartitionMetaIO)PageIO.getPageIO((long)PAGE_BUF_PTR);
                    byte partStateOrdinal = io.getPartitionState(PAGE_BUF_PTR);
                    res = new LocalSnapshotPartitionData(consId, grpId, partId, io.getUpdateCounter(PAGE_BUF_PTR), io.getSize(PAGE_BUF_PTR), GridDhtPartitionState.fromOrdinal((int)partStateOrdinal), null, false);
                    nextCntrPageId = io.getCacheSizesPageId(PAGE_BUF_PTR);
                    break;
                }
                case 20: {
                    byte[] heapCntrPage = new byte[pageSize];
                    GridUnsafe.copyOffheapHeap((long)PAGE_BUF_PTR, (Object)heapCntrPage, (long)GridUnsafe.BYTE_ARR_OFF, (long)pageSize);
                    savedCntrPages.put(PageIO.getPageId((long)PAGE_BUF_PTR), heapCntrPage);
                    break;
                }
            }
            while (res != null && savedCntrPages.containsKey(nextCntrPageId)) {
                byte[] heapCntrPage = (byte[])savedCntrPages.remove(nextCntrPageId);
                GridUnsafe.copyHeapOffheap((Object)heapCntrPage, (long)GridUnsafe.BYTE_ARR_OFF, (long)PAGE_BUF_PTR, (long)pageSize);
                PagePartitionCountersIO io = (PagePartitionCountersIO)PageIO.getPageIO((long)PAGE_BUF_PTR);
                HashMap<Integer, Long> cacheIdToCacheSize = new HashMap<Integer, Long>();
                io.readCacheSizes(PAGE_BUF_PTR, cacheIdToCacheSize);
                if (res.cacheIdToCacheSize() == null) {
                    res.cacheIdToCacheSize(cacheIdToCacheSize);
                } else {
                    res.cacheIdToCacheSize().putAll(cacheIdToCacheSize);
                }
                nextCntrPageId = io.getNextCountersPageId(PAGE_BUF_PTR);
            }
            if (res == null || nextCntrPageId != 0L) continue;
            break;
        }
        return res;
    }

    @Override
    protected int executeCmd() throws Throwable {
        SnapshotMetadataV2 metadata;
        String src = this.stringArg("-SRC", "");
        if (F.isEmpty((String)src)) {
            log.error("Snapshot folder is not specified.");
            return 3;
        }
        final long id = this.longArg("-ID", Long.MAX_VALUE);
        if (id == Long.MAX_VALUE) {
            log.error("Snapshot ID is not specified.");
            return 3;
        }
        File snapshotDir = new File(src);
        List<File> metadataFiles = CommandMetadata.findMetadataFiles(Collections.singletonList(snapshotDir.toString()), id, "snapshot-meta.bin");
        SnapshotMetadataV2 snapshotMetadataV2 = metadata = F.isEmpty(metadataFiles) ? null : this.unmarshal(metadataFiles.get(0));
        if (metadata != null) {
            metadata.finishUnmarshal(this.getClass().getClassLoader(), null, true);
        } else {
            log.warn("Snapshot metadata was not found, that could lead to issues when an encrypted cache is read.");
        }
        Object[] snapshot = snapshotDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() && f.getName().contains(Long.toString(id));
            }
        });
        if (F.isEmpty((Object[])snapshot)) {
            log.error("Snapshot with ID {} not found.", (Object)id);
            return 1;
        }
        Object[] consIdFolders = ((File)snapshot[0]).listFiles(File::isDirectory);
        if (F.isEmpty((Object[])consIdFolders)) {
            log.error("Snapshot folder with ID {} doesn't contain any consistent ID folders.", (Object)id);
            return 1;
        }
        int pageSize = this.intArg(ARG_PAGE_SIZE, 4096);
        this.printToOutput((File[])consIdFolders, metadata, pageSize);
        if (!this.hasArg("-OUTPUT")) {
            log.info("Operation result stored by default in {} file.", (Object)this.defaultOutputFileName());
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SnapshotMetadataV2 unmarshal(File metaData) throws IgniteCheckedException {
        try (InputStream stream = SnapshotUtils.stream((SnapshotPath)new FsSnapshotPath(metaData));){
            Object metadata = jdkMarshaller.unmarshal(stream, U.gridClassLoader());
            if (metadata instanceof SnapshotMetadataV2) {
                SnapshotMetadataV2 snapshotMetadataV2 = (SnapshotMetadataV2)metadata;
                return snapshotMetadataV2;
            }
            if (metadata instanceof SnapshotMetadata) {
                SnapshotMetadataV2 snapshotMetadataV2 = new SnapshotMetadataV2((SnapshotMetadata)metadata);
                return snapshotMetadataV2;
            }
            throw new IllegalArgumentException("Unsupported class - " + metadata.getClass().getName());
        }
        catch (IOException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    private List<String> toTextLine(LocalSnapshotPartitionData data) {
        ArrayList<String> res = new ArrayList<String>();
        String prefix = data.consistentId() + "," + data.groupId() + "," + data.partitionId() + "," + data.isEncryptionEnabled() + "," + data.partitionState() + "," + data.updateCounter() + "," + data.groupSize() + ",";
        if (data.sharedGroup()) {
            for (Map.Entry<Integer, Long> e : data.cacheIdToCacheSize().entrySet()) {
                res.add(prefix + e.getKey() + "," + e.getValue());
            }
        } else {
            res.add(prefix + data.groupId() + "," + data.groupSize());
        }
        return res;
    }

    private ObjectNode toJsonObject(LocalSnapshotPartitionData data) {
        ObjectNode json = MAPPER.createObjectNode();
        json.put("consistentId", data.consistentId());
        json.put("groupId", data.groupId());
        json.put("partitionId", data.partitionId());
        json.put("encryption", data.isEncryptionEnabled());
        json.put("PartitionState", data.partitionState().toString());
        json.put("updateCounter", data.updateCounter());
        json.put("groupSize", data.groupSize());
        if (data.sharedGroup()) {
            ObjectNode entries = json.putObject("entries");
            for (Map.Entry<Integer, Long> e : data.cacheIdToCacheSize().entrySet()) {
                entries.put(e.getKey().toString(), e.getValue());
            }
        }
        return json;
    }
}

