/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.txdr.utility.commands;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gridgain.database.utility.commands.CommandRemote;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationSessionDescriptor;
import org.gridgain.grid.internal.txdr.TransactionalDrGlobalStatus;
import org.gridgain.grid.internal.visor.txdr.VisorReplicationStatusTask;

public class CommandReplicationStatus
extends CommandRemote {
    public static final String CMD_NAME = "STATUS";

    public CommandReplicationStatus() {
        this.supportedArgs.add("-VERBOSE");
    }

    @Override
    public String name() {
        return CMD_NAME;
    }

    @Override
    public int errorBase() {
        return 3000;
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command returns a global status of replication process.");
        this.addHelpUsage("[-verbose]");
        this.addHelpExample();
        this.addHelpExample(null);
        this.addHelpExample("-verbose");
        this.addHelpArguments();
        this.NL();
        this.addHelpCommonArgs();
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorCommon();
        this.addHelpErrorOutput();
    }

    @Override
    protected int executeCmd() throws Throwable {
        boolean verbose = this.hasArg("-VERBOSE");
        TransactionalDrGlobalStatus res = (TransactionalDrGlobalStatus)this.execute(VisorReplicationStatusTask.class, null);
        this.printToConsole(this.prepareTextOutput(res, verbose));
        this.printToOutput(res, verbose);
        return 0;
    }

    private Collection<String> prepareTextOutput(TransactionalDrGlobalStatus info, boolean verbose) {
        ArrayList<String> lines = new ArrayList<String>();
        if (info != null) {
            Map essentialMessages;
            lines.add("sessionId: " + info.sessionId());
            lines.add("role: " + info.role().name());
            lines.add("state: " + info.state());
            lines.add("lastSuccessfullyAppliedCutId: " + info.lastSuccessfullyAppliedCutId());
            Duration duration = Duration.of(info.timeLag(), ChronoUnit.MILLIS);
            lines.add("timeLag: " + String.format("%d:%02d:%02d.%03d", duration.toHours(), duration.toMinutes() % 60L, duration.get(ChronoUnit.SECONDS) % 60L, duration.toMillis() % 1000L));
            lines.add("readOnly: " + info.readOnly());
            String laggingBehindNodes = info.laggingBehindNodes().stream().map(Object::toString).collect(Collectors.joining(", "));
            if (!laggingBehindNodes.isEmpty()) {
                lines.add("laggingBehindNodes: " + laggingBehindNodes);
            }
            if (!(essentialMessages = info.essentialMessages()).isEmpty()) {
                lines.add("essentialMessages:");
                essentialMessages.entrySet().forEach(e -> {
                    lines.add("\t" + e.getKey().toString() + ":");
                    ((List)e.getValue()).forEach(msg -> lines.add("\t\t" + msg));
                });
            }
            if (verbose) {
                lines.addAll(this.prepareTextOutputForEachNode(info));
            }
        } else {
            lines.add("Transactional data center replication is not configured.");
        }
        return lines;
    }

    private Collection<String> prepareTextOutputForEachNode(TransactionalDrGlobalStatus info) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("nodes:");
        for (Map.Entry e : info.localStates().entrySet()) {
            ReplicationSessionDescriptor desc = (ReplicationSessionDescriptor)e.getValue();
            lines.add("\t" + e.getKey().toString() + ":");
            lines.add("\t\tsessionId: " + desc.sessionId());
            lines.add("\t\trole: " + desc.role().name());
            lines.add("\t\tstate: " + desc.state().name());
            lines.add("\t\treadOnly: " + desc.readOnly());
            if (ClusterRole.MASTER == desc.role()) {
                lines.add("\t\tlastCreatedCutId: " + desc.lastCreatedCutId());
                lines.add("\t\tlastSuccessfullySentWalIdx: " + desc.lastSuccessfullySentWalIndex());
            } else if (ClusterRole.REPLICA == desc.role()) {
                lines.add("\t\tlastSuccessfullyAppliedCutId: " + desc.lastSuccessfullyAppliedCutId());
                lines.add("\t\tlaggingBehind: " + desc.laggingBehind());
            }
            if (desc.essentialMessages().isEmpty()) continue;
            lines.add("\t\tessentialMessages:");
            desc.essentialMessages().forEach(s -> lines.add("\t\t\t" + s));
        }
        return lines;
    }

    private void printToOutputJson(TransactionalDrGlobalStatus info, boolean verbose) throws IOException {
        ObjectNode json = MAPPER.createObjectNode();
        if (info != null) {
            json.put("sessionId", info.sessionId());
            json.put("role", info.role().name());
            json.put("state", info.state().name());
            json.put("lastSuccessfullyAppliedCutId", info.lastSuccessfullyAppliedCutId());
            Duration duration = Duration.of(info.timeLag(), ChronoUnit.MILLIS);
            json.put("timeLag", String.format("%d:%02d:%02d.%03d", duration.toHours(), duration.toMinutes() % 60L, duration.get(ChronoUnit.SECONDS) % 60L, duration.toMillis() % 1000L));
            json.put("readOnly", info.readOnly());
            Set laggingBehindNodes = info.laggingBehindNodes();
            if (!laggingBehindNodes.isEmpty()) {
                ArrayNode arrNode = MAPPER.createArrayNode();
                laggingBehindNodes.forEach(o -> arrNode.add(o.toString()));
                json.set("laggingBehindNodes", (JsonNode)arrNode);
            }
            json.set("essentialMessages", MAPPER.valueToTree((Object)info.essentialMessages()));
            if (verbose) {
                json.set("nodes", (JsonNode)this.prepareJsonOutputForEachNode(info));
            }
        } else {
            json.put("message", "Transactional data center replication is not configured.");
        }
        this.writeToOutput(MAPPER.writer((PrettyPrinter)new DefaultPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE)).writeValueAsString((Object)json));
    }

    private ArrayNode prepareJsonOutputForEachNode(TransactionalDrGlobalStatus info) {
        ArrayNode json = MAPPER.createArrayNode();
        for (Map.Entry e : info.localStates().entrySet()) {
            ObjectNode node = MAPPER.createObjectNode();
            ReplicationSessionDescriptor desc = (ReplicationSessionDescriptor)e.getValue();
            node.put("consistentId", e.getKey().toString());
            node.put("sessionId", desc.sessionId());
            node.put("role", desc.role().name());
            node.put("state", desc.state().name());
            node.put("readOnly", desc.readOnly());
            if (ClusterRole.MASTER == desc.role()) {
                node.put("lastCreatedCutId", desc.lastCreatedCutId());
                node.put("lastSuccessfullySentWalIdx", desc.lastSuccessfullySentWalIndex());
            } else if (ClusterRole.REPLICA == desc.role()) {
                node.put("lastSuccessfullyAppliedCutId", desc.lastSuccessfullyAppliedCutId());
                node.put("laggingBehind", desc.laggingBehind());
            }
            node.set("essentialMessages", MAPPER.valueToTree((Object)desc.essentialMessages()));
            json.add((JsonNode)node);
        }
        return json;
    }

    private void printToOutput(TransactionalDrGlobalStatus info, boolean verbose) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareTextOutput(info, verbose));
                break;
            }
            case "JSON": {
                this.printToOutputJson(info, verbose);
                break;
            }
        }
    }
}

