/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility.commands;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.gridgain.database.utility.commands.CommandRemote;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfo;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotStatus;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotsStatusTask;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotProgress;

public class CommandStatus
extends CommandRemote {
    private static final NumberFormat NUM_FMT = new DecimalFormat("#0.###", new DecimalFormatSymbols(Locale.US));
    private static final long MAX_ESTIMATE = 2678400000L;
    public static final String WRITE_FILES_STAGE_NAME = "Write files";
    public static final String WRITE_FILES_FINISH_STAGE_NAME = "Finish writing files";
    public static final String NO_SNAPSHOT_ACTIVITY = "No snapshots activity in cluster";

    public CommandStatus() {
        this.supportedArgs.add("-VERBOSE");
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command will print list of current running snapshot, restore, delete and move process if any.");
        this.addHelpUsage("[-verbose]");
        this.addHelpExample();
        this.addHelpExample("-host=192.168.1.10");
        this.addHelpExample("-verbose");
        this.addHelpExample("-host=192.168.1.10", "-ssl_enabled -ssl_protocol=SSLv23 -ssl_algorithm=SunX509 -ssl_truststore_type=jks -ssl_truststore_path=/path/to/truststore.jks -ssl_truststore_password=<PASSWORD> -ssl_key_store_type=pkcs12 -ssl_key_store_path=/path/to/keystore.pkcs12 -ssl_key_store_password=<PASSWORD>");
        this.addHelpExample("-host=192.168.1.10", "-output=my_file.txt");
        this.addHelpExample("-output=my_file.txt", "-format=json");
        this.addHelpArguments();
        this.addHelpCommonArgs();
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorCommon();
        this.addHelpErrorOutput();
    }

    @Override
    public String name() {
        return "STATUS";
    }

    @Override
    public int errorBase() {
        return 9000;
    }

    @Override
    protected int executeCmd() throws Throwable {
        VisorSnapshotStatus status = (VisorSnapshotStatus)this.execute(VisorSnapshotsStatusTask.class, null);
        this.printToOutput(status);
        this.printToConsole(this.prepareTextOutput(status));
        return 0;
    }

    private void printToOutput(VisorSnapshotStatus status) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareTextOutput(status));
                break;
            }
            case "JSON": {
                this.printToOutputJson(status);
                break;
            }
        }
    }

    Collection<String> prepareTextOutput(VisorSnapshotStatus status) {
        ArrayList<String> lines = new ArrayList<String>();
        if (status != null) {
            lines.add("Current snapshot operation:");
            lines.add("  Operation ID: " + status.getOperationId());
            VisorSnapshotInfo op = status.getOperation();
            long id = op.getSnapshotId();
            SnapshotOperationType opType = op.getOperationType();
            lines.add("  Operation: " + opType + " " + this.printStage(opType, status.getStage()));
            lines.add("  Snapshot ID: " + id);
            lines.add("  Cancellable: " + !status.isNotCancellable());
            long startTime = status.getStartTime();
            double overallProgress = this.overallProgress(status.getProgress().values());
            long duration = System.currentTimeMillis() - startTime;
            if (startTime > 0L) {
                lines.add("  Started: " + DATE_FMT.format(Instant.ofEpochMilli(startTime)));
                lines.add("  Duration: " + CommandStatus.formatInterval(duration));
                lines.add("  Overall progress: " + CommandStatus.formatProgress(overallProgress));
                lines.add("  Estimate: " + this.estimate(duration, overallProgress));
            }
            if (status.getStartStageTime() > 0L) {
                lines.add("  Stage " + status.getStage() + " started: " + DATE_FMT.format(Instant.ofEpochMilli(status.getStartStageTime())));
                lines.add("  Overall stage speed: " + this.stageSpeed(status));
            }
            lines.add("  Progress by nodes:");
            for (Map.Entry progress : status.getProgress().entrySet()) {
                SnapshotProgress nodeProgress = (SnapshotProgress)progress.getValue();
                long finishTime = nodeProgress.getFinishTime();
                String time = "";
                String speed = "";
                if (finishTime > 0L) {
                    time = ", spend: " + CommandStatus.formatInterval(finishTime - startTime);
                    speed = ", speed: " + this.stageSpeed(((SnapshotProgress)progress.getValue()).getProcessed(), status, finishTime);
                } else if (startTime > 0L) {
                    time = ", estimate: " + this.estimate(duration, nodeProgress.getOperationProgress());
                    speed = ", speed: " + this.stageSpeed(((SnapshotProgress)progress.getValue()).getProcessed(), status, System.currentTimeMillis());
                }
                lines.add("    Node ID: " + progress.getKey() + " - stageProgress: " + CommandStatus.formatProgress(nodeProgress.getProgress()) + " " + nodeProgress.getProcessed() + "/" + nodeProgress.getTotal() + ", opProgress: " + CommandStatus.formatProgress(nodeProgress.getOperationProgress()) + speed + time);
            }
        } else {
            lines.add(NO_SNAPSHOT_ACTIVITY);
        }
        return lines;
    }

    private String printStage(SnapshotOperationType opType, SnapshotOperationStage stage) {
        int opLen = 1;
        int stageNum = 0;
        String stageName = null;
        switch (stage) {
            case NONE: {
                stageName = "Initialize";
                break;
            }
            case CANCELLED: {
                stageName = "Cancelled";
                break;
            }
            case FINISH: {
                stageName = "Finished";
                break;
            }
            case FIRST: {
                stageNum = 1;
                break;
            }
            case SECOND: {
                stageNum = 2;
                break;
            }
            case THIRD: {
                stageNum = 3;
                break;
            }
            case FOURTH: {
                stageNum = 4;
                break;
            }
            case FIFTH: {
                stageNum = 5;
                break;
            }
            case SIXTH: {
                stageNum = 6;
                break;
            }
            case SEVENTH: {
                stageNum = 7;
                break;
            }
            case EIGHTH: {
                stageNum = 8;
                break;
            }
            case NINTH: {
                stageNum = 9;
            }
        }
        block14 : switch (opType) {
            case CREATE: {
                opLen = 2;
                switch (stage) {
                    case FIRST: {
                        stageName = WRITE_FILES_STAGE_NAME;
                        break;
                    }
                    case FINISH: {
                        stageName = WRITE_FILES_FINISH_STAGE_NAME;
                    }
                }
                break;
            }
            case RESTORE: {
                opLen = 2;
                switch (stage) {
                    case FIRST: {
                        stageName = "Preparing";
                        break;
                    }
                    case SECOND: {
                        stageName = "Copy files";
                    }
                }
                break;
            }
            case MOVE: {
                opLen = 2;
                switch (stage) {
                    case FIRST: {
                        stageName = "Copy files";
                        break;
                    }
                    case SECOND: {
                        stageName = "Delete files";
                    }
                }
                break;
            }
            case DELETE: {
                switch (stage) {
                    case FIRST: {
                        stageName = "Delete files";
                    }
                }
                break;
            }
            case CHECK: {
                switch (stage) {
                    case FIRST: {
                        stageName = "Check pages";
                    }
                }
                break;
            }
            case RECOVERY: {
                opLen = 5;
                switch (stage) {
                    case FIRST: {
                        stageName = "Retrieve metadata";
                        break;
                    }
                    case SECOND: {
                        stageName = "Start asynchronous WAL scan";
                        break;
                    }
                    case THIRD: {
                        stageName = "Await WAL scan completion";
                        break;
                    }
                    case FOURTH: {
                        stageName = "Partition restore";
                        break;
                    }
                    case FINISH: {
                        stageName = "Apply updates on recovery";
                    }
                }
                break;
            }
            case COPY: {
                opLen = 2;
                switch (stage) {
                    case FIRST: {
                        stageName = "Copy files";
                        break block14;
                    }
                    case SECOND: {
                        stageName = "Removing sources";
                    }
                }
            }
        }
        if (stage == SnapshotOperationStage.FINISH) {
            stageNum = opLen;
        }
        return stageName == null ? "Unknown stage " + stage : "(" + stageNum + "/" + opLen + ") " + stageName;
    }

    private String estimate(long duration, double progress) {
        long est = new Double((double)duration / progress - (double)duration).longValue();
        return est > 2678400000L ? "estimating..." : CommandStatus.formatInterval(est);
    }

    private String stageSpeed(long processed, VisorSnapshotStatus status, long finishTime) {
        String res = "unknown";
        long stageDuration = (finishTime - status.getStartStageTime()) / 1000L;
        if (status.getStage() == SnapshotOperationStage.FINISH) {
            return "0";
        }
        if (stageDuration == 0L) {
            return res;
        }
        switch (status.getOperation().getOperationType()) {
            case CREATE: {
                res = CommandStatus.formatSpeed(processed * (long)status.getPageSize() / stageDuration);
                break;
            }
            case DELETE: {
                res = processed / stageDuration + " files/s";
                break;
            }
            case RECOVERY: {
                switch (status.getStage()) {
                    case FIRST: {
                        res = processed / stageDuration + " op/s";
                        break;
                    }
                    case SECOND: {
                        res = CommandStatus.formatSpeed(processed * (long)status.getPageSize() / stageDuration);
                        break;
                    }
                    case THIRD: {
                        res = processed / stageDuration + " op/s";
                        break;
                    }
                    case FOURTH: {
                        res = processed / stageDuration + " nodes/s";
                    }
                }
                break;
            }
            case RESTORE: {
                switch (status.getStage()) {
                    case FIRST: {
                        res = processed / stageDuration + " op/s";
                        break;
                    }
                    case SECOND: {
                        res = CommandStatus.formatSpeed(processed * (long)status.getPageSize() / stageDuration);
                    }
                }
                break;
            }
            case MOVE: 
            case COPY: {
                switch (status.getStage()) {
                    case FIRST: {
                        res = CommandStatus.formatSpeed(processed / stageDuration);
                        break;
                    }
                    case SECOND: {
                        res = processed / stageDuration + " files/s";
                    }
                }
                break;
            }
            case CHECK: {
                switch (status.getStage()) {
                    case FIRST: {
                        res = CommandStatus.formatSpeed(processed * (long)status.getPageSize() / stageDuration);
                    }
                }
            }
        }
        return res;
    }

    private String stageSpeed(VisorSnapshotStatus status) {
        long overallProcessed = 0L;
        for (SnapshotProgress nodeProgress : status.getProgress().values()) {
            overallProcessed += nodeProgress.getProcessed();
        }
        return this.stageSpeed(overallProcessed, status, System.currentTimeMillis());
    }

    private void printToOutputJson(VisorSnapshotStatus status) throws IOException {
        ObjectNode rootNode = MAPPER.createObjectNode();
        if (status != null) {
            ObjectNode jsonOperation = rootNode.putObject("operation");
            VisorSnapshotInfo op = status.getOperation();
            SnapshotOperationType opType = op.getOperationType();
            jsonOperation.put("id", String.valueOf(status.getOperationId()));
            jsonOperation.put("type", String.valueOf(opType));
            if (opType == SnapshotOperationType.CREATE) {
                jsonOperation.put("pageSize", status.getPageSize());
            }
            long id = op.getSnapshotId();
            long startTime = status.getStartTime();
            long duration = System.currentTimeMillis() - startTime;
            if (startTime > 0L) {
                jsonOperation.put("startTime", startTime);
                jsonOperation.put("duration", duration);
                jsonOperation.put("startStageTime", status.getStartStageTime());
                jsonOperation.put("stage", status.getStage().name());
                jsonOperation.put("overallStageSpeed", this.stageSpeed(status));
            }
            jsonOperation.put("cancellable", !status.isNotCancellable());
            ObjectNode jsonSnapshot = rootNode.putObject("snapshot");
            jsonSnapshot.put("id", id);
            ArrayNode jsonProgress = rootNode.putArray("progress");
            for (Map.Entry progress : status.getProgress().entrySet()) {
                SnapshotProgress nodeProgress = (SnapshotProgress)progress.getValue();
                ObjectNode progressItem = jsonProgress.addObject();
                progressItem.put("node", String.valueOf(progress.getKey()));
                progressItem.put("progress", nodeProgress.getOperationProgress());
                progressItem.put("stageProcessed", nodeProgress.getProcessed());
                progressItem.put("stageTotal", nodeProgress.getTotal());
                long finishTime = nodeProgress.getFinishTime();
                if (finishTime > 0L) {
                    progressItem.put("speed", this.stageSpeed(nodeProgress.getProcessed(), status, finishTime));
                    progressItem.put("spend", finishTime - startTime);
                    continue;
                }
                if (startTime <= 0L) continue;
                progressItem.put("speed", this.stageSpeed(nodeProgress.getProcessed(), status, System.currentTimeMillis()));
                progressItem.put("estimate", this.estimate(duration, nodeProgress.getOperationProgress()));
            }
        } else {
            rootNode.put("message", NO_SNAPSHOT_ACTIVITY);
        }
        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode));
    }

    private static String formatInterval(long l) {
        long hr = TimeUnit.MILLISECONDS.toHours(l);
        long min = TimeUnit.MILLISECONDS.toMinutes(l -= TimeUnit.HOURS.toMillis(hr));
        long sec = TimeUnit.MILLISECONDS.toSeconds(l -= TimeUnit.MINUTES.toMillis(min));
        return String.format("%03d:%02d:%02d", hr, min, sec);
    }

    private static String formatSpeed(long s) {
        long l = s = s < 0L ? 0L : s;
        if (s > 0x80000000L) {
            return s / 1024L / 1024L / 1024L + " GB/s";
        }
        if (s > 0x200000L) {
            return s / 1024L / 1024L + " MB/s";
        }
        if (s > 2048L) {
            return s / 1024L + " KB/s";
        }
        return s + " B/s";
    }

    private static String formatProgress(double p) {
        return p < 0.0 || Double.isNaN(p) ? "unknown" : NUM_FMT.format(p * 100.0) + "%";
    }
}

