/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.ignite.internal.util.typedef.F;
import org.gridgain.database.utility.commands.CommandRemote;
import org.gridgain.grid.internal.visor.database.snapshot.VisorCopySnapshotTask;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotChainMode;

public class CommandCopy
extends CommandRemote {
    public CommandCopy() {
        this.supportedArgs.add("-ID");
        this.supportedArgs.add("-DEST");
        this.supportedArgs.add("-KEY_ALIAS");
        this.supportedArgs.add("-COMMENT");
        this.supportedArgs.add("-SKIP_WAL");
        this.supportedArgs.add("-CHAIN");
        this.supportedArgs.add("-DELETE_SOURCE");
        this.supportedArgs.add("-SINGLE_COPY");
        this.supportedArgs.add("-NOPROGRESS");
        this.supportedArgs.add("-VERBOSE");
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command will copy files of specified snapshot to specified folder in external disk storage.");
        this.addHelpUsage("-id=SNAPSHOT_ID", "-dest=EXTERNAL_FOLDER", "-key_alias=ALIAS", "[-noprogress]", "[-skip_wal]", "[-chain=SINGLE|FROM]", "[-delete_source]", "[-verbose]", this.optional("-single_copy"));
        this.addHelpExample();
        this.addHelpExample("-id=1234567", "-dest=/snapshots/2017/01");
        this.addHelpExample("-id=1234567", "-dest=/snapshots/2017/01", "-verbose");
        this.addHelpExample("-id=1234567", "-dest=/snapshots/2017/01", "-ssl_enabled -ssl_protocol=SSLv23 -ssl_algorithm=SunX509 -ssl_truststore_type=jks -ssl_truststore_path=/path/to/truststore.jks -ssl_truststore_password=<PASSWORD> -ssl_key_store_type=pkcs12 -ssl_key_store_path=/path/to/keystore.pkcs12 -ssl_key_store_password=<PASSWORD>");
        this.addHelpExample("-id=1234567", "-dest=/snapshots/2017/01", "-host=192.168.1.10");
        this.addHelpExample("-id=1234567", "-dest=/snapshots/2017/01", "-output=my_file.txt");
        this.addHelpExample("-id=1234567", "-dest=/snapshots/2017/01", "-skip_wal");
        this.addHelpExample("-id=1234567", "-dest=/snapshots/2017/01", "-single_copy");
        this.addHelpExample("-id=1234567", "-dest=/snapshots/2017/01", "-single_copy", "-skip_wal");
        this.addHelpExample("-id=1234567", "-dest=/snapshots/2017/01", "-chain=SINGLE");
        this.addHelpExample("-id=1234567", "-dest=/snapshots/2017/01", "-key_alias=my_sftp");
        this.addHelpArguments();
        this.addHelpIndent("-id=SNAPSHOT_ID - snapshot identifier to use.").NL();
        this.addHelpIndent("-dest=EXTERNAL_FOLDER - folder name where snapshot files should be moved.").NL();
        this.addHelpIndent("-key_alias=alias - alias for JKS key for working with SFTP server.").NL();
        this.addHelpIndent("-skip_wal - move snapshot without dependent WAL.").NL();
        this.addHelpIndent("-chain=SINGLE|FROM, param which define how to work with snapshot chains  (FULL-INC-INC-INC...):\n\tSINGLE - manipulate only with the defined snapshot (default);\tFROM - manipulate with snapshot chain (FULL-INC-INC-INC...) from the defined snasphot to the last one;").NL();
        this.addHelpIndent("-delete_source - COPY will remove original snapshot if copy phase finished successfully cluster-wide.").NL();
        this.addHelpIndent("-single_copy - will synchronize node to copy partition files exactly once.").NL();
        this.addHelpIndent("-noprogress - do not print progress bar.").NL();
        this.addHelpCommonArgs();
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorCommon();
        this.addHelpError(500, "snapshot utility failed to find snapshot with specified ID.");
        this.addHelpError(710, "snapshot utility failed to move snapshot to destination folder.");
        this.addHelpError(720, "snapshot utility failed to delete snapshots with specified IDs.");
        this.addHelpError(740, String.format("(When PITR is enabled) WAL files have been deleted manually after snapshot was created. Use '%s' flag to copy this snapshot.", "-SKIP_WAL"));
        this.addHelpErrorOutput();
    }

    @Override
    public String name() {
        return "COPY";
    }

    @Override
    public int errorBase() {
        return 16000;
    }

    private Collection<String> prepareTextOutput(long id, String dest, SnapshotChainMode mode) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("COPY status:");
        lines.add("  ID: " + id);
        lines.add("  Destination: " + dest);
        lines.add("  ChainMode: " + mode);
        return lines;
    }

    private void printToOutputJson(long id, String dest, SnapshotChainMode mode) throws IOException {
        ObjectNode json = MAPPER.createObjectNode();
        json.put("id", id);
        json.put("destination", dest);
        json.put("chainMode", mode == null ? "DEFAULT" : mode.toString());
        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
    }

    private void printToOutput(long id, String dest, SnapshotChainMode mode) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareTextOutput(id, dest, mode));
                break;
            }
            case "JSON": {
                this.printToOutputJson(id, dest, mode);
                break;
            }
        }
    }

    @Override
    protected int executeCmd() throws Throwable {
        long id = this.longArg("-ID", -1L);
        if (id < 0L) {
            throw new IllegalArgumentException("Snapshot ID was not specified");
        }
        String dest = this.stringArg("-DEST", "");
        if (F.isEmpty((String)dest)) {
            throw new IllegalArgumentException("Destination folder was not specified");
        }
        this.execute(VisorCopySnapshotTask.class, new VisorSnapshotInfo.Builder().withSnapshotId(id).withPaths(Collections.singleton(dest)).withMessage(this.message()).withSkipWalCopy(this.hasArg("-SKIP_WAL")).withKeyAlias(this.stringArg("-KEY_ALIAS", null)).withSnapshotChainMode(this.chainMode()).withDeleteSources(this.hasArg("-DELETE_SOURCE")).withSingleFileCopy(this.hasArg("-SINGLE_COPY")).build());
        this.printToConsole(this.prepareTextOutput(id, dest, this.chainMode()));
        this.printToOutput(id, dest, this.chainMode());
        return 0;
    }
}

