/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility.commands;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Set;
import org.gridgain.database.utility.commands.CommandRemote;
import org.gridgain.grid.internal.visor.database.snapshot.VisorCleanupRestartingCachesTask;

public class CommandCleanRestartingCaches
extends CommandRemote {
    public static final String COMMAND_NAME = "CLEANUP_RESTARTING_CACHES";

    public CommandCleanRestartingCaches() {
        this.supportedArgs.add("-VERBOSE");
    }

    @Override
    protected int executeCmd() throws Throwable {
        Set caches = (Set)this.execute(VisorCleanupRestartingCachesTask.class, null);
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(caches);
                break;
            }
            case "JSON": {
                ObjectNode json = MAPPER.createObjectNode();
                json.putArray("caches").addAll((ArrayNode)MAPPER.valueToTree((Object)caches));
                this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
                break;
            }
        }
        this.printToConsole("Status: OK");
        this.printToConsole("Caches: " + String.join((CharSequence)", ", caches));
        return 0;
    }

    @Override
    public String name() {
        return COMMAND_NAME;
    }

    @Override
    public int errorBase() {
        return 17000;
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command forcefully cancel restarts for all caches in \"restarting\" state. Such action might be required after cancelled RESTORE command with -force flag. Cancelled restore might leave some caches in restarting state indefinitely (until node was restarted). No new node can be joined and no cache can be started with the name of restarting cache. There are two options available - either restart node with cancelled restore or execute current command.");
        this.addHelpUsage("[-verbose]");
        this.addHelpArguments();
        this.addHelpCommonArgs();
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorCommon();
        this.addHelpErrorOutput();
    }
}

