/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility.commands;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedWriter;
import java.io.Console;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.util.GridGainProperties;
import org.jetbrains.annotations.Nullable;

public abstract class Command {
    protected static final Logger log = LogManager.getLogger(Command.class);
    public static final int ERR_UNKNOWN_ARGS = 110;
    public static final int ERR_INVALID_ARGS = 120;
    public static final int ERR_AUTHENTICATION_FAILED = 200;
    public static final int ERR_AUTHORIZATION_FAILED = 210;
    public static final int ERR_INSECURE_INPUT_IS_NOT_SUPPORTED = 220;
    public static final int ERR_CONNECTION_FAILED = 300;
    public static final int ERR_SNAPSHOT_NOT_CONFIGURED = 400;
    public static final int ERR_CLUSTER_NOT_ACTIVE = 410;
    public static final int ERR_SCHEDULER_NOT_IN_CLASSPATH = 420;
    public static final int ERR_SCHEDULE_NOT_FOUND = 430;
    public static final int ERR_SCHEDULE_ALREADY_EXISTS = 440;
    public static final int ERR_CANT_ADD_TO_THE_MIDDLE_OF_THE_CHAIN = 450;
    public static final int ERR_SNAPSHOT_NOT_FOUND = 500;
    public static final int ERR_SNAPSHOT_BROKEN = 510;
    public static final int ERR_CONCURRENT_SNAPSHOT = 520;
    public static final int ERR_INCREMENTAL_NOT_POSSIBLE = 530;
    public static final int ERR_INCREMENTAL_NOT_POSSIBLE_PREVIOUS_ONES_DIFFER = 531;
    public static final int ERR_CACHE_NOT_FOUND = 600;
    public static final int ERR_FAILED_TO_READ_CACHE_CONFIG = 610;
    public static final int ERR_USE_FORCE = 700;
    public static final int ERR_INVALID_DEST = 710;
    public static final int ERR_DELETE_FAILED = 720;
    public static final int ERR_DISK_FULL = 730;
    public static final int ERR_USE_SKIP_WAL = 740;
    public static final int ERR_USE_CHAIN = 750;
    public static final int ERR_INVALID_PARALLELISM = 760;
    public static final int ERR_INVALID_COMPRESSION_LEVEL = 770;
    public static final int ERR_INAPPLICABLE_COMPRESSION_LEVEL = 780;
    public static final int ERR_OUTPUT_FAILED = 800;
    public static final int ERR_CMD_FAILED_OUTPUT_FAILED = 810;
    public static final int ERR_CATALOG_FAILED = 900;
    public static final int ERR_DIRECTORY_DOES_NOT_EXIST = 910;
    public static final int ERR_CLUSTER_NOT_FOUND = 920;
    public static final int ERR_CANCEL_NOT_POSSIBLE = 950;
    public static final int ERR_CANCEL_FAILED_OPERATION_ID_NOT_FOUND = 960;
    public static final int ERR_REPLICATION_IS_ALREADY_BOOTSTRAPPED = 970;
    public static final int RESULT_OK = 0;
    public static final String ERROR_STACK_TRACE = "Error stack trace:";
    protected static final String NA = "n/a";
    protected static final String DELIM = "--------------------------------------------------------------------------------";
    protected static final String ARG_PASSWORD = "-PASSWORD";
    protected static final String ARG_OUTPUT = "-OUTPUT";
    protected static final String ARG_FORMAT = "-FORMAT";
    protected static final String ARG_SRC = "-SRC";
    protected static final String ARG_CACHES = "-CACHES";
    protected static final String ARG_EXCLUDED_CACHES = "-EXCLUDED_CACHES";
    protected static final String ARG_ID = "-ID";
    protected static final String FORMAT_TEXT = "TEXT";
    protected static final String FORMAT_JSON = "JSON";
    protected static final String ARG_VERBOSE = "-VERBOSE";
    protected static final String ARG_USER = "-USER";
    protected static final String HELP_USAGE_VERBOSE = "[-verbose]";
    protected static final String HELP_USAGE_NEED_EXCHANGE = "-needexchange";
    protected static final String HELP_USAGE_PARALLELISM = "-parallelism=4";
    protected static final String HELP_USAGE_COMPRESSION_LEVEL = "-compression_level=5";
    protected static final String HELP_USAGE_ARCHIVE = "-archive=NONE|ZIP";
    protected static final String HELP_USAGE_ID = "-id=SNAPSHOT_ID";
    protected static final String HELP_EXAMPLE_VERBOSE = "-verbose";
    protected static final String HELP_EXAMPLE_ID = "-id=1234567";
    protected static final String HELP_EXAMPLE_CACHES = "-caches=cache1,cache2";
    protected static final String HELP_ARG_NEED_EXCHANGE = "-needexchange - this argument allows to trigger snapshot creation in legacy mode with exchange.";
    protected static final String HELP_ARG_ENCRYPTION_KEY = "-encryption_key=MASTER_KEY_NAME - this argument specifies a master key that will be used for snapshot encryption.";
    protected static final String HELP_ARG_VERBOSE = "-verbose - this argument enable verbose mode, for example, cache names.";
    protected static final String HELP_ARG_ARCHIVE = "-archive=" + Command.getArchiveOptions() + " - this argument enable compression for snapshot files";
    protected static final String HELP_ARG_COMPRESSION_LEVEL = "-compression_level=N - this argument sets compression level for snapshot files, value dependent on codec type[min, max, default]: " + Command.getCompressionLevelParams();
    protected static final String HELP_ARG_WRITE_THROTTLING = "-write_throttling=N - this argument enables write throttling. Snapshot write speed will be throttled when reached N bytes per second on each node. Only non-negative values are supported, default value is 0 - no throttling.";
    protected static final String HELP_ARG_PARALLELISM = "-parallelism=N - determines parallel execution (threads) of snapshot operation, 1 to N";
    protected static final String HELP_ARG_FORMAT = "-format=text|json - write command output in specified format: text or JSON.";
    protected static final String HELP_ARG_ID = "-id=SNAPSHOT_ID - snapshot identifier to use.";
    protected static final String HELP_ARG_CACHES = "-caches=cache1,...,cacheN,group1,...,groupK - list of cache or group names to process.";
    protected static final String HELP_ARG_EXCLUDED_CACHES = "-excluded_caches=cache1,...,cacheN,group1,...groupK  - list of cache or group names excluded from processing.";
    private String helpUtilityName;
    protected final Set<String> supportedArgs = new HashSet<String>();
    protected final Map<String, String> parsedArgs = new LinkedHashMap<String, String>();
    private final Map<Integer, String> errMsgs = new HashMap<Integer, String>();
    protected final Collection<String> help = new ArrayList<String>();
    private String utilityName;
    private String defaultOutputFileName;
    protected String outputFileName;
    protected final String ses = U.id8((UUID)UUID.randomUUID());
    protected static final DateTimeFormatter DATE_FMT2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS", Locale.US).withZone(ZoneId.systemDefault());
    protected static final DateTimeFormatter DATE_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.US).withZone(ZoneId.systemDefault());
    protected static final String TAB = "    ";
    protected static final String TAB_2 = "        ";
    protected static final String TAB_3 = "            ";
    protected static final String TAB_4 = "                ";
    protected static final String TAB_5 = "                    ";
    protected static final String TAB_6 = "                        ";
    protected static final ObjectMapper MAPPER = new ObjectMapper();

    public void helpUtilityName(String helpUtilityName) {
        this.helpUtilityName = helpUtilityName;
    }

    public void utilityName(String name) {
        this.utilityName = name;
        this.defaultOutputFileName = this.constructDefaultOutputFileName(this.utilityName);
        this.helpUtilityName = this.utilityName + "-utility.sh";
    }

    public String defaultOutputFileName() {
        return this.defaultOutputFileName;
    }

    private String constructDefaultOutputFileName(String utilityName) {
        String outputRelPath = "log/" + utilityName + "-utility.out";
        try {
            return U.defaultWorkDirectory() + "/" + outputRelPath;
        }
        catch (IgniteCheckedException e) {
            return "work/" + outputRelPath;
        }
    }

    public String utilityName() {
        return this.utilityName;
    }

    public abstract String name();

    public abstract int errorBase();

    public int errorCode(int errCode) {
        return this.errorBase() + errCode;
    }

    public int generalErrorCode(int errCode) {
        return errCode < 1000 ? errCode : errCode - this.errorBase();
    }

    protected abstract void initHelp();

    protected Command addHelp(String line) {
        this.help.add(line);
        return this;
    }

    protected Command addHelpIndent(String line) {
        return this.addHelp(TAB + line);
    }

    protected void addHelpIndentLn(String line) {
        this.addHelpIndent(line);
        this.NL();
    }

    protected void NL() {
        this.addHelp("");
    }

    protected void addHelpError() {
        this.addHelp("Error codes:");
        this.addHelpError(0, "command failed.");
    }

    protected void addHelpErrorArgs() {
        this.addHelpError(110, "unknown or unsupported arguments specified for command.");
        this.addHelpError(120, "invalid arguments specified for command.");
    }

    protected void addHelpErrorOutput() {
        this.addHelpError(800, "command executed successfully, but " + this.utilityName() + " utility failed to write result to output file.");
        this.addHelpError(810, "command failed and " + this.utilityName() + " utility failed to write error code to output file.");
    }

    protected void addHelpError(int errCode, String line) {
        int cmdErrCode = this.errorCode(errCode);
        String errMsg = cmdErrCode + " - " + line;
        this.errMsgs.put(cmdErrCode, errMsg);
        this.addHelpIndent(errMsg);
    }

    protected void addHelpExample() {
        this.NL();
        this.addHelp("Examples:");
    }

    protected void addHelpArguments() {
        this.NL();
        this.addHelp("Arguments:");
    }

    protected void addHelpExample(String ... examples) {
        StringBuilder line = new StringBuilder(100);
        line.append(this.helpUtilityName).append(' ').append(this.name().toLowerCase());
        if (!F.isEmpty((Object[])examples)) {
            for (String example : examples) {
                line.append(' ').append(example);
            }
        }
        this.addHelpIndent(line.toString());
    }

    public void printHelp() {
        if (F.isEmpty(this.help)) {
            this.initHelp();
            this.NL();
            this.addHelp("Exit codes:");
            this.addHelpIndent("0 - successful execution.");
            this.addHelpIndent("1 - unexpected error.");
            this.addHelpIndent("2 - unknown command.");
            this.addHelpIndent("3 - invalid arguments.");
            this.addHelpIndent("4 - connection failed.");
            this.addHelpIndent("5 - command failed with known error code.");
            this.addHelpIndent("6 - command executed successfully, but " + this.utilityName() + " utility failed to write result to output file.");
            this.addHelpIndent("7 - command failed and " + this.utilityName() + " utility failed to write error code to output file.");
        }
        for (String line : this.help) {
            log.info(line);
        }
    }

    private String adjustMessage(String msg) {
        if (!F.isEmpty((String)msg)) {
            int traceIdx = msg.indexOf(", trace=");
            if (traceIdx > 0) {
                msg = msg.substring(0, traceIdx);
            }
            int lastIdx = msg.lastIndexOf(" err=");
            int msgEndIdx = msg.indexOf(93, lastIdx);
            if (lastIdx > 0 && msgEndIdx > 0) {
                int startIdx = msg.indexOf(91, lastIdx);
                while (startIdx > 0) {
                    int tmpIdx = msg.indexOf(93, msgEndIdx + 1);
                    if (tmpIdx > 0) {
                        msgEndIdx = tmpIdx;
                    }
                    startIdx = msg.indexOf(91, startIdx + 1);
                }
            }
            return lastIdx >= 0 ? msg.substring(lastIdx + 5, msgEndIdx > 0 ? msgEndIdx : traceIdx) : msg;
        }
        return msg;
    }

    protected int error(int errCode, String errMsg, Throwable e) {
        int cmdErrCode = this.errorCode(errCode);
        log.error("Error code: {}. {}.", (Object)cmdErrCode, (Object)this.adjustMessage(errMsg));
        if (this.parsedArgs.containsKey(ARG_VERBOSE) && e != null) {
            log.info(ERROR_STACK_TRACE + System.lineSeparator() + X.getFullStackTrace((Throwable)e));
        }
        return cmdErrCode;
    }

    protected int error(Throwable e) {
        String msg = e.getMessage();
        return this.error(0, F.isEmpty((String)msg) ? e.getClass().getName() : msg, e);
    }

    protected T2<Integer, String> errorTuple(int errCode, String errMsg) {
        return new T2((Object)this.error(errCode, errMsg, null), (Object)errMsg);
    }

    protected abstract int execute0();

    protected Collection<String> prepareTextErrorOutput(T2<Integer, String> error) {
        return Collections.singleton(String.valueOf(error.get1()));
    }

    protected ObjectNode prepareJsonErrorOutput(T2<Integer, String> error) {
        ObjectNode json = MAPPER.createObjectNode();
        ObjectNode err = json.putObject("error");
        err.put("code", (Integer)error.get1());
        err.put("message", (String)error.get2());
        return json;
    }

    protected boolean customErrorOutput(int status) {
        return false;
    }

    public int execute(String ... args) {
        Thread.currentThread().setName("session=" + this.ses);
        log.info("GridGain Snapshots utility [ver. {}]", (Object)IgniteVersionUtils.ACK_VER_STR);
        log.info(GridGainProperties.COPYRIGHT);
        log.info("OS login: {}", (Object)System.getProperty("user.name"));
        T2<Integer, String> res = this.internalExecute(args);
        int status = (Integer)res.get1();
        if (status > 0 && this.generalErrorCode(status) != 800 && !this.customErrorOutput(status)) {
            try {
                switch (this.outputFormat()) {
                    case "TEXT": {
                        this.writeToOutput(this.prepareTextErrorOutput(res));
                        break;
                    }
                    case "JSON": {
                        ObjectNode json = this.prepareJsonErrorOutput(res);
                        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
                        break;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                status = this.error(120, "Failed to write error code to output: " + e.getMessage(), e);
            }
            catch (IOException e) {
                status = this.error(810, "Failed to write error code to output: " + e.getMessage(), e);
            }
        }
        return status;
    }

    private T2<Integer, String> internalExecute(String ... args) {
        String params;
        try {
            params = this.parse(args);
        }
        catch (IllegalArgumentException e) {
            if (log.isInfoEnabled()) {
                log.info("Command [{}{}] started at [{}]", (Object)this.name(), (Object)this.prepareArgsForPrint(args), (Object)DATE_FMT.format(Instant.now()));
                log.info(DELIM);
            }
            log.error(e.getMessage());
            if (log.isInfoEnabled()) {
                log.info("Please read documentation for {} command:", (Object)this.name());
            }
            this.printHelp();
            return this.errorTuple(110, e.getMessage());
        }
        if (this.hasArg(ARG_USER)) {
            log.info("Cluster user: {}", (Object)this.stringArg(ARG_USER, NA));
        }
        log.info(DELIM);
        Instant start = Instant.now();
        log.info("Command [{}{}] started at [{}]...", (Object)this.name(), (Object)params, (Object)DATE_FMT.format(start));
        boolean tryConnectAgain = true;
        boolean suppliedAuth = !F.isEmpty((String)this.parsedArgs.get(ARG_USER)) && !F.isEmpty((String)this.parsedArgs.get(ARG_PASSWORD));
        int tryConnectMaxCnt = 3;
        int status = 0;
        while (tryConnectAgain) {
            tryConnectAgain = false;
            status = this.execute0();
            if (status - this.errorBase() != 200) continue;
            if (suppliedAuth) {
                this.error(200, "Authentication error", null);
            }
            if (tryConnectMaxCnt <= 0) continue;
            System.out.println(suppliedAuth ? "Authentication error, please try again." : "This cluster requires authentication.");
            Console console = System.console();
            if (console != null) {
                if (!this.parsedArgs.containsKey(ARG_USER)) {
                    this.parsedArgs.put(ARG_USER, console.readLine("user: ", new Object[0]));
                }
                this.parsedArgs.put(ARG_PASSWORD, new String(console.readPassword("password: ", new Object[0])));
                suppliedAuth = true;
            } else {
                status = this.errorCode(220);
            }
            tryConnectAgain = status != this.errorCode(220);
            --tryConnectMaxCnt;
        }
        if (status > 0) {
            String errMsg = this.errorMessage(status);
            log.error("Command [{}] failed with error: {}", (Object)this.name(), (Object)errMsg);
            return new T2((Object)status, (Object)errMsg);
        }
        log.info("Command [{}] successfully finished in {} seconds.", (Object)this.name(), (Object)Duration.between(start, Instant.now()).getSeconds());
        return new T2((Object)status, (Object)"Success");
    }

    private String prepareArgsForPrint(String[] args) {
        StringBuilder params = new StringBuilder();
        if (!F.isEmpty((Object[])args)) {
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                String[] ss = arg.split("=");
                String parsedArg = ss[0].toUpperCase();
                params.append(' ');
                if (this.isMaskedArgument(parsedArg)) {
                    params.append(ss[0]).append("=**********");
                    continue;
                }
                params.append(arg);
            }
        }
        return params.toString();
    }

    protected String errorMessage(int errCode) {
        String errMsg;
        if (F.isEmpty(this.help)) {
            this.initHelp();
        }
        return F.isEmpty((String)(errMsg = this.errMsgs.get(errCode))) ? String.valueOf(errCode) : errMsg;
    }

    protected String parse(String ... args) {
        this.parsedArgs.clear();
        StringBuilder params = new StringBuilder();
        if (!F.isEmpty((Object[])args)) {
            IllegalArgumentException err = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                String[] ss = arg.split("=");
                String parsedArg = ss[0].toUpperCase();
                params.append(' ');
                if (this.isMaskedArgument(parsedArg)) {
                    params.append(ss[0]).append("=**********");
                } else {
                    params.append(arg);
                }
                if (this.supportedArgs.contains(parsedArg)) {
                    this.parsedArgs.put(parsedArg, ss.length > 1 ? ss[1] : null);
                    continue;
                }
                if (ARG_VERBOSE.equals(parsedArg)) {
                    log.warn("\"-verbose\" argument is not supported by current command and will be ignored");
                    continue;
                }
                if (err != null) continue;
                err = new IllegalArgumentException("Unknown or unsupported argument = " + parsedArg);
            }
            this.outputFileName = this.stringArg(ARG_OUTPUT, this.defaultOutputFileName());
            if (err != null) {
                throw err;
            }
        }
        return params.toString();
    }

    protected boolean isMaskedArgument(String name) {
        return ARG_PASSWORD.equalsIgnoreCase(name);
    }

    protected boolean hasArg(String name) {
        assert (!F.isEmpty((String)name));
        return this.parsedArgs.containsKey(name);
    }

    protected boolean booleanArg(String name, boolean dflt) {
        return this.hasArg(name) ? true : dflt;
    }

    protected int intArg(String name, int dflt) {
        if (!this.hasArg(name)) {
            return dflt;
        }
        String arg = this.parsedArgs.get(name);
        if (F.isEmpty((String)arg)) {
            throw new IllegalArgumentException("No value for argument: '" + name + "'");
        }
        try {
            return Integer.parseInt(arg);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid value for argument '" + name + "': " + arg, nfe);
        }
    }

    protected long longArg(String name, long dflt) {
        if (!this.hasArg(name)) {
            return dflt;
        }
        String arg = this.parsedArgs.get(name);
        if (F.isEmpty((String)arg)) {
            throw new IllegalArgumentException("No value for argument: '" + name + "'");
        }
        try {
            return Long.parseLong(arg);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid value for argument '" + name + "': " + arg, nfe);
        }
    }

    protected String stringArg(String name, String dflt) {
        if (!this.hasArg(name)) {
            return dflt;
        }
        String arg = this.parsedArgs.get(name);
        if (F.isEmpty((String)arg)) {
            throw new IllegalArgumentException("No value for argument: '" + name + "'");
        }
        return arg;
    }

    protected ZonedDateTime dateArg(String name, DateTimeFormatter format) {
        if (!this.hasArg(name)) {
            return null;
        }
        String arg = this.parsedArgs.get(name);
        if (F.isEmpty((String)arg)) {
            return null;
        }
        try {
            return LocalDateTime.parse(arg, format).atZone(ZoneId.systemDefault());
        }
        catch (DateTimeParseException pe) {
            throw new IllegalArgumentException("Invalid value for argument '" + name + "': " + arg, pe);
        }
    }

    protected long timestampArg(String name, DateTimeFormatter format) {
        ZonedDateTime date = this.dateArg(name, format);
        return date != null ? date.toInstant().toEpochMilli() : -1L;
    }

    protected List<String> split(String s, String delim) {
        if (F.isEmpty((String)s)) {
            return Collections.emptyList();
        }
        return Arrays.stream(s.split(delim)).map(String::trim).filter(item -> !item.isEmpty()).collect(Collectors.toList());
    }

    protected <E extends Enum<E>> E enumArg(String name, Class<E> enumCls) {
        if (!this.hasArg(name)) {
            return null;
        }
        String arg = this.parsedArgs.get(name);
        if (F.isEmpty((String)arg)) {
            return null;
        }
        for (Enum value : (Enum[])enumCls.getEnumConstants()) {
            if (!value.name().equalsIgnoreCase(arg)) continue;
            return (E)value;
        }
        throw new IllegalArgumentException("Invalid value for argument '" + name + "': " + arg + ", allowed are: " + Arrays.toString(enumCls.getEnumConstants()));
    }

    @Nullable
    protected List<String> listArg(String name) {
        if (!this.hasArg(name)) {
            return null;
        }
        String arg = this.stringArg(name, null);
        if (F.isEmpty((String)arg)) {
            throw new IllegalArgumentException("No value for argument: '" + name + "'");
        }
        List<String> res = this.split(arg, ",");
        int cnt = 1;
        for (int i = 0; i < arg.length(); ++i) {
            if (arg.charAt(i) != ',') continue;
            ++cnt;
        }
        if (cnt != res.size()) {
            throw new IllegalArgumentException("Wrong list format for argument: '" + name + "'");
        }
        return res;
    }

    protected List<String> singletonListArg(String name) {
        String arg = this.stringArg(name, null);
        return F.isEmpty((String)arg) ? null : Collections.singletonList(arg);
    }

    @Nullable
    protected Set<String> setArg(String name) {
        List<String> lst = this.listArg(name);
        if (F.isEmpty(lst)) {
            return null;
        }
        HashSet<String> res = new HashSet<String>(lst.size());
        res.addAll(lst);
        return res;
    }

    protected String outputFormat() {
        String fmt = this.stringArg(ARG_FORMAT, FORMAT_TEXT);
        if (FORMAT_TEXT.equalsIgnoreCase(fmt)) {
            return FORMAT_TEXT;
        }
        if (FORMAT_JSON.equalsIgnoreCase(fmt)) {
            return FORMAT_JSON;
        }
        throw new IllegalArgumentException("Unknown output format: " + fmt);
    }

    protected Set<String> sorted(Collection<String> items) {
        TreeSet<String> res = new TreeSet<String>();
        if (!F.isEmpty(items)) {
            res.addAll(items);
        }
        return res;
    }

    protected void writeToOutput(String s) throws IOException {
        this.writeToOutput(Collections.singleton(s));
    }

    protected void writeToOutput(Collection<String> lines) throws IOException {
        this.writeToOutput(lines, false);
    }

    protected void writeToOutput(Collection<String> lines, boolean append) throws IOException {
        String outputFile;
        Path outputFilePath = Paths.get(this.outputFileName, new String[0]).toAbsolutePath();
        Path outputDirPath = outputFilePath.getParent();
        try {
            Path igniteHomePath = Paths.get(U.getIgniteHome(), new String[0]);
            if (outputFilePath.startsWith(igniteHomePath) && outputDirPath != null) {
                U.ensureDirectory((Path)outputDirPath, (String)outputDirPath.toString(), null);
            }
            outputFile = this.outputFileName;
        }
        catch (IgniteCheckedException e) {
            outputFile = outputFilePath.getFileName().toString();
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile, append));){
            for (String line : lines) {
                bw.write(line);
                bw.newLine();
            }
        }
    }

    protected void printToConsole(String line) {
        this.printToConsole(Collections.singletonList(line));
    }

    protected void printToConsole(Collection<String> lines) {
        for (String line : lines) {
            log.info(line);
        }
    }

    protected String exceptionMessage(Throwable e, String dflt) {
        if (e == null || e.getMessage() == null) {
            return dflt;
        }
        return e.getMessage();
    }

    protected void addCollectionToJson(ObjectNode json, String name, Collection<String> items) {
        ArrayNode jsonArr = json.putArray(name);
        for (String item : items) {
            jsonArr.add(item);
        }
    }

    protected void addJsonCaches(ObjectNode json, Collection<String> caches) {
        ObjectNode jsonCaches = json.putObject("caches");
        if (F.isEmpty(caches)) {
            jsonCaches.put("count", 0);
        } else {
            jsonCaches.put("count", caches.size());
            this.addCollectionToJson(jsonCaches, "names", this.sorted(caches));
        }
    }

    protected boolean containsIgnoreCase(String src, String what) {
        if (F.isEmpty((String)src)) {
            return false;
        }
        int len = what.length();
        char firstLo = Character.toLowerCase(what.charAt(0));
        char firstUp = Character.toUpperCase(what.charAt(0));
        for (int i = src.length() - len; i >= 0; --i) {
            char ch = src.charAt(i);
            if (ch != firstLo && ch != firstUp || !src.regionMatches(true, i, what, 0, len)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getSupportedArgs() {
        return this.supportedArgs;
    }

    private static String getArchiveOptions() {
        return Arrays.stream(CompressionOption.values()).map(Enum::toString).collect(Collectors.joining("|"));
    }

    private static String getCompressionLevelParams() {
        return Arrays.stream(CompressionOption.values()).filter(CompressionOption::isCompressed).map(c -> String.format("%s[%s, %s, %s]", c, c.minCompressionLevel(), c.maxCompressionLevel(), c.defaultCompressionLevel())).collect(Collectors.joining(", "));
    }
}

