/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cli.utility;

import org.apache.ignite.internal.util.typedef.F;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.gridgain.database.utility.commands.Command;

public abstract class CommandLineUtility {
    private static final Logger log = LogManager.getLogger(CommandLineUtility.class);
    public static final int EXIT_CODE_UNEXPECTED_ERROR = 1;
    public static final int EXIT_CODE_UNKNOWN_CMD = 2;
    public static final int EXIT_CODE_INVALID_ARGUMENTS = 3;
    public static final int EXIT_CODE_CONNECTION_FAILED = 4;
    public static final int EXIT_CODE_CMD_FAILED = 5;
    public static final int EXIT_CODE_OUTPUT_FAILED = 6;
    public static final int EXIT_CODE_CMD_FAILED_OUTPUT_FAILED = 7;

    public abstract Command helpCommand();

    public abstract Command createCommand(String var1);

    public int execute(String[] args) {
        try {
            Command help = this.helpCommand();
            if (F.isEmpty((Object[])args)) {
                return help.execute(new String[0]);
            }
            String arg = args[0].trim().toUpperCase();
            try {
                Command cmd = this.createCommand(arg);
                int errCode = cmd.execute(args);
                if (errCode > 0) {
                    switch (errCode - cmd.errorBase()) {
                        case 110: 
                        case 120: {
                            return 3;
                        }
                        case 200: 
                        case 300: {
                            return 4;
                        }
                        case 800: {
                            return 6;
                        }
                        case 810: {
                            return 7;
                        }
                    }
                    return 5;
                }
                return errCode;
            }
            catch (IllegalArgumentException ignored) {
                log.error("Error code: {}. Unknown command: {}", (Object)2, (Object)arg);
                help.printHelp();
                return 2;
            }
        }
        catch (Throwable e) {
            log.error((Message)new ParameterizedMessage("Error code: {}. Unexpected exception", (Object)1), e);
            return 1;
        }
    }
}

