/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.txdr.utility.commands;

import java.util.Map;
import org.apache.ignite.internal.util.typedef.F;
import org.gridgain.database.utility.commands.Command;
import org.gridgain.internal.txdr.utility.commands.ReplicationCommands;

public class CommandReplicationHelp
extends Command {
    public static final String CMD_NAME = "HELP";

    public CommandReplicationHelp() {
        this.supportedArgs.add(CMD_NAME);
        this.supportedArgs.add("BOOTSTRAP");
        this.supportedArgs.add("STATUS");
        this.supportedArgs.add("PAUSE");
        this.supportedArgs.add("RESUME");
        this.supportedArgs.add("STOP");
        this.supportedArgs.add("SWITCH");
        this.supportedArgs.add("TEST_SNAPSHOT_CREATE");
        this.supportedArgs.add("CUT");
        this.supportedArgs.add("APPLY");
        this.supportedArgs.add("DEBUG");
    }

    @Override
    public String name() {
        return CMD_NAME;
    }

    @Override
    public int errorBase() {
        return 1000;
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command will print information about specified command.");
        this.NL();
        this.addHelp("Usage: HELP command");
        this.NL();
        this.addHelp("Replication utility supports following commands:");
        this.addHelpIndent(CMD_NAME);
        this.addHelpIndent("BOOTSTRAP");
        this.addHelpIndent("STATUS");
        this.addHelpIndent("PAUSE");
        this.addHelpIndent("RESUME");
        this.addHelpIndent("STOP");
        this.addHelpIndent("SWITCH");
        this.addHelpIndent("TEST_SNAPSHOT_CREATE");
        this.addHelpIndent("CUT");
        this.addHelpIndent("APPLY");
        this.addHelpIndent("DEBUG");
        this.addHelpExample();
        this.addHelpExample("");
        this.addHelpExample("BOOTSTRAP");
        this.addHelpExample("STATUS");
        this.addHelpExample("PAUSE");
        this.addHelpExample("RESUME");
        this.addHelpExample("STOP");
        this.addHelpExample("SWITCH");
        this.addHelpExample("TEST_SNAPSHOT_CREATE");
        this.addHelpExample("CUT");
        this.addHelpExample("APPLY");
        this.addHelpExample("DEBUG");
    }

    @Override
    protected int execute0() {
        Command cmd = this;
        if (!F.isEmpty((Map)this.parsedArgs)) {
            String arg = ((String)F.first(this.parsedArgs.keySet())).toUpperCase();
            try {
                cmd = ReplicationCommands.valueOf(arg).command();
            }
            catch (IllegalArgumentException ignored) {
                log.info("Unknown command: {}", (Object)arg);
            }
            catch (Throwable e) {
                log.error("Unexpected exception", e);
            }
        }
        cmd.printHelp();
        return 0;
    }
}

