/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.txdr.utility.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.gridgain.database.utility.Utils;
import org.gridgain.database.utility.commands.CommandRemote;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfo;
import org.gridgain.grid.internal.visor.txdr.VisorCutTestingSnapshotCreateTask;

public class CommandCutTestingSnapshotCreate
extends CommandRemote {
    public static final String CMD_NAME = "TEST_SNAPSHOT_CREATE";

    @Override
    public String name() {
        return CMD_NAME;
    }

    @Override
    public int errorBase() {
        return 10000;
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command creates special snapshot for manual testing of consistent cut creation and applying.");
        this.addHelpExample();
        this.addHelpArguments();
        this.NL();
        this.addHelpCommonArgs();
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorCommon();
        this.addHelpErrorOutput();
    }

    @Override
    protected int executeCmd() throws Throwable {
        VisorSnapshotInfo info = (VisorSnapshotInfo)this.execute(VisorCutTestingSnapshotCreateTask.class, null);
        this.printToConsole(this.prepareTextOutput(info));
        this.printToOutput(info);
        return 0;
    }

    private Collection<String> prepareTextOutput(VisorSnapshotInfo snap) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(String.valueOf(snap.getSnapshotId()));
        lines.add("Snapshot for consistent cut testing created:");
        lines.add("  Cluster: " + snap.getClusterName());
        lines.add("  ID: " + snap.getSnapshotId());
        lines.add("  Created: " + Utils.snapshotCreationDate(snap.getSnapshotId()));
        lines.add("  Type: " + Utils.snapshotType(snap.isFullSnapshot()));
        lines.add("  Initiator: " + snap.getInitiatorNodeId());
        lines.add("  Session: " + this.ses);
        return lines;
    }

    private void printToOutputJson(VisorSnapshotInfo snap) throws IOException {
        ObjectNode json = MAPPER.createObjectNode();
        json.put("cluster", snap.getClusterName());
        json.put("id", snap.getSnapshotId());
        json.put("created", Utils.snapshotCreationDate(snap.getSnapshotId()));
        json.put("type", Utils.snapshotType(snap.isFullSnapshot()));
        json.put("initiator", snap.getInitiatorNodeId().toString());
        json.put("session", this.ses);
        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
    }

    private void printToOutput(VisorSnapshotInfo info) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareTextOutput(info));
                break;
            }
            case "JSON": {
                this.printToOutputJson(info);
                break;
            }
        }
    }
}

