/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.ignite.internal.util.typedef.F;
import org.gridgain.database.utility.Utils;
import org.gridgain.database.utility.commands.CacheConfigurationException;
import org.gridgain.database.utility.commands.CommandCheck;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.visor.database.snapshot.VisorRestoreSnapshotTask;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfo;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotIssue;

public class CommandRestore
extends CommandCheck {
    public CommandRestore() {
        this.supportedArgs.add("-ID");
        this.supportedArgs.add("-NOCHECK");
        this.supportedArgs.add("-CACHES");
        this.supportedArgs.add("-EXCLUDED_CACHES");
        this.supportedArgs.add("-CONFIG");
        this.supportedArgs.add("-SRC");
        this.supportedArgs.add("-KEY_ALIAS");
        this.supportedArgs.add("-FORCE");
        this.supportedArgs.add("-NOPROGRESS");
        this.supportedArgs.add("-PROGRESS");
        this.supportedArgs.add("-TO");
        this.supportedArgs.add("-PARALLELISM");
        this.supportedArgs.add("-VERBOSE");
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command will restore specified or all caches from snapshot.");
        this.addHelpUsage("-id=SNAPSHOT_ID", "[-nocheck]", "[-caches=cache1,cache2,...,cacheN]", "[-config=config.xml]", "[-src=path1[,path2,...,pathN]]", "[-force]", "[-verbose]");
        this.addHelp("Restore caches from snapshot.");
        this.addHelpUsage("-to=yyyy-MM-dd-HH:mm:ss.SSS", "[-nocheck]", "[-caches=cache1,cache2,...,cacheN]");
        this.addHelp("Restore caches to point in time.");
        this.addHelpExample();
        this.addHelpExample("-id=1234567");
        this.addHelpExample("-id=1234567", "-verbose");
        this.addHelpExample("-id=1234567", "-ssl_enabled -ssl_protocol=SSLv23 -ssl_algorithm=SunX509 -ssl_truststore_type=jks -ssl_truststore_path=/path/to/truststore.jks -ssl_truststore_password=<PASSWORD> -ssl_key_store_type=pkcs12 -ssl_key_store_path=/path/to/keystore.pkcs12 -ssl_key_store_password=<PASSWORD>");
        this.addHelpExample("-id=1234567", "-nocheck");
        this.addHelpExample("-id=1234567", "-caches=cache1,cache2");
        this.addHelpExample("-id=1234567", "-caches=cache1,cache2", "-force");
        this.addHelpExample("-id=1234567", "-config=config.xml");
        this.addHelpExample("-id=1234567", "-src=/snapshots/2016/12,/snapshots/2017/01");
        this.addHelpExample("-id=1234567", "-force");
        this.addHelpExample("-id=1234567", "-host=192.168.1.10");
        this.addHelpExample("-id=1234567", "-output=my_file.txt");
        this.addHelpExample("-to=2017-09-08-03:00:00.000");
        this.addHelpExample("-id=1234567", "-parallelism=4");
        this.addHelpArguments();
        this.addHelpIndent("-id=SNAPSHOT_ID - snapshot identifier to use.").NL();
        this.addHelpIndent("-nocheck - if this argument is specified, snapshot utility will not check");
        this.addHelpIndent("  snapshot before restore.").NL();
        this.addHelpIndent("-caches=cache1,...,cacheN,group1,...,groupK - list of cache or group names to process.").NL();
        this.addHelpIndent("-excluded_caches=cache1,...,cacheN,group1,...groupK  - list of cache or group names excluded from processing.").NL();
        this.addHelpIndent("-config=config.xml - read new caches configurations from specified file on restore.").NL();
        this.addHelpIndent("-src=path1[,path2,...,pathN] - list of optional folders to search for snapshot files.").NL();
        this.addHelpIndent("-key_alias=alias - alias for JKS key for working with SFTP server.").NL();
        this.addHelpIndent("-force - allow to destroy caches, not included in arguments of restore operation.").NL();
        this.addHelpIndent("-to=TIMESTAMP - this argument allows to specify point in time.");
        this.addHelpIndent("-noprogress - do not print progress bar.").NL();
        this.addHelpIndent("-progress=DELAY - delay (sec) for progress bar update, default is 5 sec.").NL();
        this.addHelpIndent("  Where TIMESTAMP should be in \"yyyy-MM-dd-HH:mm:ss.SSS\" format.").NL();
        this.addHelpIndent("-parallelism=N - determines parallel execution (threads) of snapshot operation, 1 to N").NL();
        this.addHelpCommonArgs();
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorCommon();
        this.addHelpError(500, "snapshot utility failed to find snapshot with specified ID.");
        this.addHelpError(510, "snapshot is broken.");
        this.addHelpError(600, "snapshot utility failed to find cache with specified name.");
        this.addHelpError(610, "snapshot utility failed to read file with cache configurations.");
        this.addHelpError(700, "groups to restore of specified caches have more caches than specified. Use '-force' flag to restore this caches.");
        this.addHelpErrorOutput();
    }

    @Override
    public String name() {
        return "RESTORE";
    }

    @Override
    public int errorBase() {
        return 5000;
    }

    private Collection<String> prepareTextOutput(long id, long pit, Map<String, Collection<VisorSnapshotIssue>> issues) {
        Collection<Object> lines;
        Collection<Object> collection = lines = id >= 0L ? this.prepareTextOutput(id, issues) : new ArrayList();
        if (pit >= 0L) {
            lines.add("Restored time: " + Utils.epochMillisToString(pit, PIT_FMT));
        }
        lines.add("Restored: " + F.isEmpty(issues));
        return lines;
    }

    private ObjectNode prepareJsonOutput(long id, long pit, Map<String, Collection<VisorSnapshotIssue>> issues) throws IOException {
        ObjectNode json;
        ObjectNode objectNode = json = id >= 0L ? this.prepareJsonOutput(id, issues) : MAPPER.createObjectNode();
        if (pit >= 0L) {
            json.put("timestamp", pit);
        }
        json.put("restored", F.isEmpty(issues));
        return json;
    }

    private void printToOutput(long id, long pit, Map<String, Collection<VisorSnapshotIssue>> issues) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareTextOutput(id, pit, issues));
                break;
            }
            case "JSON": {
                ObjectNode json = this.prepareJsonOutput(id, pit, issues);
                this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
                break;
            }
        }
    }

    @Override
    protected int executeCmd() throws Throwable {
        long id = this.longArg("-ID", -1L);
        ZonedDateTime pit = this.dateArg("-TO", PIT_FMT);
        int parallelism = this.intArg("-PARALLELISM", 2);
        if (id < 0L && pit == null) {
            throw new IllegalArgumentException("Snapshot ID or point in time was not specified");
        }
        if (id >= 0L && pit != null) {
            throw new IllegalArgumentException("Only '-id' or '-to' can be specified");
        }
        Map<String, Collection<VisorSnapshotIssue>> issues = null;
        if (id >= 0L) {
            String cfgFileName = this.stringArg("-CONFIG", "");
            VisorSnapshotInfo.Builder argBuilder = new VisorSnapshotInfo.Builder().withSnapshotId(id).withForce(this.hasArg("-FORCE")).withPaths(this.listArg("-SRC")).withKeyAlias(this.stringArg("-KEY_ALIAS", null)).withCacheNames(this.listArg("-CACHES")).withExcludedCacheNames(this.listArg("-EXCLUDED_CACHES")).withSnapshotCommonParameters(new SnapshotCommonParameters(parallelism)).withMessage(this.message());
            if (!F.isEmpty((String)cfgFileName)) {
                try {
                    argBuilder.withCacheConfigurations(new String(Files.readAllBytes(Paths.get(cfgFileName, new String[0]))));
                }
                catch (Throwable e) {
                    throw new CacheConfigurationException(this.exceptionMessage(e, "Failed to read cache configurations from file: " + cfgFileName), e);
                }
            }
            VisorSnapshotInfo arg = argBuilder.build();
            if (this.hasArg("-NOCHECK")) {
                log.warn("NOTE! Snapshot check before restore will not be executed!");
            } else {
                log.info("Checking snapshot...");
                issues = this.check(id, arg.getPaths(), arg.getKeyAlias(), arg.getCacheNames(), arg.getExcludedCacheNames(), arg.isForce(), true, parallelism);
            }
            if (F.isEmpty(issues)) {
                log.info("Restoring from snapshot...");
                this.execute(VisorRestoreSnapshotTask.class, arg);
            }
        } else {
            VisorSnapshotInfo arg = new VisorSnapshotInfo.Builder().withSnapshotId(-1L).withPaths(this.listArg("-SRC")).withKeyAlias(this.stringArg("-KEY_ALIAS", null)).withCacheNames(this.listArg("-CACHES")).withExcludedCacheNames(this.listArg("-EXCLUDED_CACHES")).withMessage(this.message()).withTime(pit.toInstant().toEpochMilli()).withSnapshotCommonParameters(new SnapshotCommonParameters(parallelism)).build();
            log.info("Initiate recovery to time...");
            this.execute(VisorRestoreSnapshotTask.class, arg);
        }
        long time = pit != null ? pit.toInstant().toEpochMilli() : -1L;
        this.printToConsole(this.prepareTextOutput(id, time, issues));
        this.printToOutput(id, time, issues);
        if (!F.isEmpty(issues)) {
            return this.errorCode(510);
        }
        return 0;
    }
}

