/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.commandline.indexreader.IgniteIndexReader;
import org.apache.ignite.internal.commandline.indexreader.IgniteIndexReaderFilePageStoreFactory;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.database.indexreader.SnapshotFilePageStoreFactory;
import org.gridgain.database.utility.commands.CommandDirect;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CacheSnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.jetbrains.annotations.Nullable;

public class CommandIndexCheck
extends CommandDirect {
    private static final String ARG_CONSISTENT_ID = "-CONSISTENT_ID";
    private static final String ARG_DATA_CHECK = "-DATA_CHECK";
    private static final String ARG_DESCRIBE = "-DESCRIBE";
    protected static final int ERR_SNAPSHOT_META_NOT_FOUND = 511;
    protected static final int ERR_SNAPSHOT_META_BROKEN = 512;
    protected static final int ERR_CONSISTENT_ID_NOT_FOUND = 514;
    protected static final int ERR_NOT_ENOUGH_MEMORY = 140;
    public static final String ALL = "ALL";
    public static final long UNDEF_SNAPSHOT_ID = Long.MIN_VALUE;
    private final IgniteConfiguration cfg = new IgniteConfiguration();

    public CommandIndexCheck() {
        this.supportedArgs.add("-SRC");
        this.supportedArgs.add("-ID");
        this.supportedArgs.add("-CACHES");
        this.supportedArgs.add(ARG_CONSISTENT_ID);
        this.supportedArgs.add(ARG_DATA_CHECK);
        this.supportedArgs.add(ARG_DESCRIBE);
        this.supportedArgs.add("-OUTPUT");
    }

    @Override
    public String name() {
        return "INDEX_CHECK";
    }

    @Override
    public int errorBase() {
        return 19000;
    }

    @Override
    protected void initHelp() {
        String describe = ARG_DESCRIBE.toLowerCase();
        String dataCheck = ARG_DATA_CHECK.toLowerCase();
        String caches = "-CACHES".toLowerCase() + "=all|cache1,...,cacheN";
        String consistentId = ARG_CONSISTENT_ID.toLowerCase() + "=all|consistent_id1,...,consistent_idN";
        this.addHelp("This command will print lists of snapshot_id, consistent_id (if more than one), and caches.");
        this.addHelpUsage(describe, "-src=SNAPSHOT_FOLDER", this.optionlArg("-id=SNAPSHOT_ID"), this.optionlArg(consistentId));
        this.addHelp("This command will check consistency of indexes and data in snapshot.");
        this.addHelpUsage("-src=SNAPSHOT_FOLDER", "-id=SNAPSHOT_ID", this.optionlArg(consistentId), caches, this.optionlArg(dataCheck));
        String consistentIdAll = "-CACHES".toLowerCase() + "=all";
        String consistentIdSpecific = "-CACHES".toLowerCase() + "=consistent_id1,consistent_id2";
        String cachesAll = "-CACHES".toLowerCase() + "=all";
        this.addHelpExample(describe, "-src=SNAPSHOT_FOLDER1");
        this.addHelpExample(describe, "-src=SNAPSHOT_FOLDER1", "-id=1234567");
        this.addHelpExample(describe, "-src=SNAPSHOT_FOLDER1", "-id=1234567", consistentIdAll);
        this.addHelpExample(describe, "-src=SNAPSHOT_FOLDER1", "-id=1234567", consistentIdSpecific);
        this.addHelpExample("-src=SNAPSHOT_FOLDER1", "-id=1234567", cachesAll);
        this.addHelpExample("-src=SNAPSHOT_FOLDER1", "-id=1234567", cachesAll, dataCheck);
        this.addHelpExample("-src=SNAPSHOT_FOLDER1", "-id=1234567", "-caches=cache1,cache2");
        this.addHelpExample("-src=SNAPSHOT_FOLDER1", "-id=1234567", "-caches=cache1,cache2", dataCheck);
        this.addHelpExample("-src=SNAPSHOT_FOLDER1", "-id=1234567", consistentIdAll, cachesAll);
        this.addHelpExample("-src=SNAPSHOT_FOLDER1", "-id=1234567", consistentIdSpecific, cachesAll);
        this.addHelpArguments();
        this.addHelpIndentLn("-src=SNAPSHOT_FOLDER - path to folder with snapshot.");
        this.addHelpIndentLn("-id=SNAPSHOT_ID - snapshot identifier to use.");
        this.addHelpIndentLn(caches + " - list of cache names to process.");
        this.addHelpIndentLn(consistentId + " - list of consistent unique node IDs.");
        this.addHelpIndentLn("-data_check - check consistency of partitions and indexes.");
        this.addHelpIndentLn("-describe - display a list of snapshot_id, consistent_id and caches for filter.");
        this.addHelpCommonArgs(false);
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorOutput();
    }

    @Override
    protected void addHelpError() {
        super.addHelpError();
        this.addHelpError(500, "snapshot utility failed to find snapshot.");
        this.addHelpError(510, "snapshot is broken.");
        this.addHelpError(511, "snapshot utility failed to find snapshot metadata.");
        this.addHelpError(512, "snapshot metadata is broken.");
        this.addHelpError(514, "consistent_id dir not found.");
        this.addHelpError(600, "cache not found.");
        this.addHelpError(140, "not enough memory to execute command.");
    }

    @Override
    protected int executeCmd() throws Throwable {
        String src = this.stringArg("-SRC", null);
        String output = this.outputFileName;
        long id = this.longArg("-ID", Long.MIN_VALUE);
        boolean describe = this.booleanArg(ARG_DESCRIBE, false);
        boolean dataCheck = this.booleanArg(ARG_DATA_CHECK, false);
        List<String> consistentIds = this.listArg(ARG_CONSISTENT_ID);
        List<String> caches = this.listArg("-CACHES");
        this.validateArgs(src, output, id, describe, dataCheck, consistentIds, caches);
        try {
            return describe ? this.executeCmdDescribe(this.srcDir(src), id, consistentIds, output) : this.executeCmdCheckIndex(this.srcDir(src), id, dataCheck, consistentIds, caches, output);
        }
        catch (IndexCheckException e) {
            log.error(e.getMessage());
            return e.errCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeCmdCheckIndex(File srcDir, long id, boolean dataCheck, @Nullable List<String> cids, List<String> caches, String output) throws IndexCheckException, IgniteCheckedException, IOException {
        assert (id != Long.MIN_VALUE);
        if (!ALL.equalsIgnoreCase(caches.get(0))) {
            HashSet<String> missed = new HashSet<String>(caches);
            for (File cidDir : this.cidDirs(this.snapDirs(srcDir, id)[0], cids)) {
                missed.removeAll(this.readMeta(cidDir).cacheNames());
            }
            if (!missed.isEmpty()) {
                throw new IndexCheckException(600, "Missing caches: " + missed);
            }
        }
        ArrayList<IndexCheckParameters> idxCheckParams = new ArrayList<IndexCheckParameters>();
        for (File cidDir : this.cidDirs(this.snapDirs(srcDir, id)[0], cids)) {
            SnapshotMetadataV2 snapMeta = this.readMeta(cidDir);
            for (Map.Entry e : snapMeta.cacheGroupsMetadata().entrySet()) {
                Set snapCaches;
                if (ALL.equalsIgnoreCase(caches.get(0))) {
                    snapCaches = null;
                } else {
                    if (!((CacheSnapshotMetadata)e.getValue()).cacheNames().stream().anyMatch(caches::contains)) continue;
                    boolean shared = ((CacheSnapshotMetadata)e.getValue()).cacheConfigurations().stream().anyMatch(ccfg -> Objects.nonNull(ccfg.getGroupName()));
                    snapCaches = shared ? (Collection)((CacheSnapshotMetadata)e.getValue()).cacheNames().stream().filter(caches::contains).collect(Collectors.toSet()) : null;
                }
                idxCheckParams.add(new IndexCheckParameters(this.createPageStoreFactory(srcDir, cidDir, snapMeta, (Integer)e.getKey()), this.createIndexNameFilter(snapCaches), Objects.isNull(snapCaches) ? snapMeta.cacheNames() : snapCaches, cidDir.getName()));
            }
        }
        long maxEstimateMem = idxCheckParams.stream().mapToLong(p -> p.fac.estimateMemory()).max().getAsLong();
        if (this.freeMemory() < maxEstimateMem) {
            throw new IndexCheckException(140, "For analysis, more memory is needed, need to specify jvm options -Xms and -Xmx when running command and memory is not less than: " + U.humanReadableByteCount((long)maxEstimateMem));
        }
        try (PrintStream ps = new PrintStream(new FileOutputStream(output));){
            String msg = "Start of index analysis number of iterations: " + idxCheckParams.size();
            log.info(msg);
            ps.println(msg);
            int i = 0;
            Iterator it = idxCheckParams.iterator();
            while (it.hasNext()) {
                IndexCheckParameters p2 = (IndexCheckParameters)it.next();
                msg = "Start analysis of indexes [i=" + i++ + ", consistent_id=" + p2.cid + ", caches=" + p2.caches + ']';
                log.info((i > 0 ? U.nl() : "") + msg);
                ps.println(msg);
                new IgniteIndexReader(p2.idxNameFilter, dataCheck, ps, (IgniteIndexReaderFilePageStoreFactory)p2.fac).readIdx();
                it.remove();
            }
            msg = "Finish of index analysis";
            log.info(U.nl() + msg);
            ps.println(msg);
            ps.flush();
        }
        finally {
            log.info("Command result stored in {} file.", (Object)output);
        }
        return 0;
    }

    private int executeCmdDescribe(File srcDir, long id, @Nullable List<String> cids, String output) throws IndexCheckException, IOException {
        TreeMap<Long, Map> describeMap = new TreeMap<Long, Map>();
        cids = id == Long.MIN_VALUE ? F.asList((Object)ALL) : cids;
        for (File snapDir : this.snapDirs(srcDir, id)) {
            for (File cidDir : this.cidDirs(snapDir, cids)) {
                SnapshotMetadataV2 snapMeta = this.readMeta(cidDir);
                describeMap.computeIfAbsent(snapMeta.id(), l -> new TreeMap()).put(cidDir.getName(), new TreeSet(snapMeta.cacheNames()));
            }
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (Map.Entry e : describeMap.entrySet()) {
            lines.add("SnapshotID: " + e.getKey());
            for (Map.Entry e1 : ((Map)e.getValue()).entrySet()) {
                lines.add("    ConsistenceID: " + (String)e1.getKey());
                lines.add("        Caches: " + ((Collection)e1.getValue()).stream().collect(Collectors.joining(",", "[", "]")));
            }
        }
        this.writeToOutput(lines);
        this.printToConsole(lines);
        log.info("Command result stored in {} file.", (Object)output);
        return 0;
    }

    @Nullable
    private Predicate<String> createIndexNameFilter(@Nullable Collection<String> caches) {
        if (Objects.isNull(caches)) {
            return null;
        }
        String cacheIds = caches.stream().map(c -> String.valueOf(CU.cacheId((String)c))).collect(Collectors.joining("|"));
        Pattern p = Pattern.compile('(' + cacheIds + ").*");
        return idxName -> p.matcher((CharSequence)idxName).find();
    }

    private SnapshotFilePageStoreFactory createPageStoreFactory(File srcDir, File cidDir, SnapshotMetadataV2 snapMeta, int grpId) throws IndexCheckException {
        ArrayList<File> snapChain = new ArrayList<File>(Arrays.asList(this.grpDir(cidDir, grpId)));
        int pageSize = snapMeta.pageSize();
        int partCnt = ((CacheSnapshotMetadata)snapMeta.cacheGroupsMetadata().get(grpId)).storedCacheDataList().stream().mapToInt(cacheData -> cacheData.config().getAffinity().partitions()).findAny().getAsInt();
        while (Objects.nonNull(snapMeta) && !snapMeta.fullSnapshot()) {
            Long prevSnapId = ((CacheSnapshotMetadata)snapMeta.cacheGroupsMetadata().get(grpId)).previousSnapshotId(cidDir.getName());
            if (Objects.isNull(prevSnapId)) {
                snapMeta = null;
                continue;
            }
            File prevCidDir = this.cidDirs(this.snapDirs(srcDir, prevSnapId)[0], Arrays.asList(cidDir.getName()))[0];
            snapChain.add(this.grpDir(prevCidDir, grpId));
            snapMeta = this.readMeta(prevCidDir);
        }
        return new SnapshotFilePageStoreFactory(snapChain, pageSize, partCnt);
    }

    protected long freeMemory() {
        return new SnapshotFilePageStoreFactory(Collections.emptyList(), 0, 0).freeMemory();
    }

    private File grpDir(File cidDir, int grpId) throws IndexCheckException {
        File grpDir = new File(cidDir, String.valueOf(grpId));
        String grp = grpDir.getAbsolutePath();
        if (!grpDir.exists() || !grpDir.isDirectory()) {
            throw new IndexCheckException(510, "Snapshot dosen't has directory: " + grp);
        }
        if (F.isEmpty((Object[])grpDir.listFiles(File::isFile))) {
            throw new IndexCheckException(510, "Snapshot has empty directory: " + grp);
        }
        return grpDir;
    }

    protected File[] cidDirs(File snapDir, @Nullable List<String> cids) throws IndexCheckException {
        boolean all = Objects.isNull(cids) || ALL.equals(cids.get(0));
        Object[] cidDirs = snapDir.listFiles(f -> f.isDirectory() && (all || cids.contains(f.getName())));
        String snap = snapDir.getAbsolutePath();
        if (F.isEmpty((Object[])cidDirs)) {
            throw new IndexCheckException(514, "There are no consistent_id directories in snapshot" + (all ? " :" + snap : " [consistentIds=" + cids + ", snapshotDir=" + snap + ']'));
        }
        if (cidDirs.length > 1 && Objects.isNull(cids)) {
            throw new IndexCheckException(514, ARG_CONSISTENT_ID.toLowerCase() + " is required");
        }
        ArrayList<String> absentCids = new ArrayList<String>(cids);
        absentCids.removeAll(Stream.of(cidDirs).map(File::getName).collect(Collectors.toList()));
        if (!all && !absentCids.isEmpty()) {
            throw new IndexCheckException(514, "Not found consistent_id directories in snapshot [snapshotDir=" + snap + ", consistent_id=" + absentCids + ']');
        }
        for (Object cidDir : cidDirs) {
            Object[] snapMetas = ((File)cidDir).listFiles(f -> f.isFile() && "snapshot-meta.bin".equals(f.getName()));
            String cid = ((File)cidDir).getAbsolutePath();
            if (F.isEmpty((Object[])snapMetas)) {
                throw new IndexCheckException(511, "Snapshot metadata not found in directory: " + cid);
            }
            SnapshotMetadataV2 snapMeta = this.readMeta((File)cidDir);
            if (Objects.isNull(snapMeta)) {
                throw new IndexCheckException(512, "Snapshot metadata broken:" + ((File)snapMetas[0]).getAbsolutePath());
            }
            if (!F.isEmpty((Object[])((File)cidDir).listFiles(File::isDirectory))) continue;
            throw new IndexCheckException(510, "Snapshot consisten_id directory is empty: " + cid);
        }
        return cidDirs;
    }

    protected File[] snapDirs(File srcDir, long id) throws IndexCheckException {
        String snapDir = id == Long.MIN_VALUE ? null : String.valueOf(id);
        Object[] snapDirs = srcDir.listFiles(f -> f.isDirectory() && (Objects.isNull(snapDir) || f.getName().contains(snapDir)));
        String src = srcDir.getAbsolutePath();
        if (F.isEmpty((Object[])snapDirs)) {
            throw new IndexCheckException(500, "Snapshot directory not found" + (Objects.isNull(snapDir) ? " :" + src : " [id=" + id + ", src=" + src + ']'));
        }
        if (Objects.nonNull(snapDir) && snapDirs.length > 1) {
            throw new IndexCheckException(500, "Found similar snapshot directories by id [id=" + id + ", src=" + src + ']');
        }
        for (Object snap : snapDirs) {
            if (!F.isEmpty((Object[])((File)snap).listFiles(File::isDirectory))) continue;
            throw new IndexCheckException(514, "There are no consistent_id directories in snapshot: " + ((File)snap).getAbsolutePath());
        }
        return snapDirs;
    }

    protected File srcDir(String src) throws IndexCheckException {
        File f = new File(src);
        if (!f.exists() || !f.isDirectory()) {
            throw new IndexCheckException(500, "Snapshot directory not found: " + src);
        }
        if (F.isEmpty((Object[])f.listFiles(File::isDirectory))) {
            throw new IndexCheckException(500, "No snapshots found in directory: " + src);
        }
        return f;
    }

    protected void validateArgs(@Nullable String src, @Nullable String output, long id, boolean describe, boolean dataCheck, @Nullable List<String> consistentIds, @Nullable List<String> caches) throws IllegalArgumentException {
        if (F.isEmpty((String)src)) {
            throw new IllegalArgumentException("Source snapshot folder is not specified");
        }
        if (F.isEmpty((String)output)) {
            throw new IllegalArgumentException("Output file is not specified");
        }
        Predicate<List> allOrSpecial = strs -> strs.size() == 1 && ALL.equalsIgnoreCase((String)strs.get(0)) || strs.stream().noneMatch(s -> F.isEmpty((String)s) || ALL.equalsIgnoreCase((String)s));
        String cid = ARG_CONSISTENT_ID.toLowerCase();
        if (describe) {
            String notExp = " is not expected for " + ARG_DESCRIBE.toLowerCase();
            if (dataCheck) {
                throw new IllegalArgumentException(ARG_DATA_CHECK.toLowerCase() + notExp);
            }
            if (Objects.nonNull(caches)) {
                throw new IllegalArgumentException("-CACHES".toLowerCase() + notExp);
            }
            if (id == Long.MIN_VALUE && Objects.nonNull(consistentIds)) {
                throw new IllegalArgumentException(cid + " is not expected without " + "-ID".toLowerCase());
            }
        } else {
            if (id == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Snapshot id is not specified");
            }
            if (Objects.isNull(caches) || !allOrSpecial.test(caches)) {
                throw new IllegalArgumentException("-CACHES".toLowerCase() + " expected: all|cache1,...,cacheN");
            }
        }
        if (Objects.nonNull(consistentIds) && !allOrSpecial.test(consistentIds)) {
            throw new IllegalArgumentException(cid + " expected: all|consistent_id1,...,consistent_idN");
        }
    }

    private SnapshotMetadataV2 readMeta(File dir) {
        return SnapshotUtils.readSnapshotMetadata((SnapshotPath)new FsSnapshotPath(dir), (boolean)true, (IgniteConfiguration)this.cfg, null, null);
    }

    private static class IndexCheckParameters {
        final SnapshotFilePageStoreFactory fac;
        final Predicate<String> idxNameFilter;
        final Collection<String> caches;
        final String cid;

        public IndexCheckParameters(SnapshotFilePageStoreFactory fac, Predicate<String> idxNameFilter, Collection<String> caches, String cid) {
            this.fac = fac;
            this.idxNameFilter = idxNameFilter;
            this.caches = caches;
            this.cid = cid;
        }
    }

    protected static class IndexCheckException
    extends IgniteCheckedException {
        final int errCode;

        public IndexCheckException(int errCode, String msg) {
            super(msg);
            assert (errCode > 0) : errCode;
            this.errCode = errCode;
        }
    }
}

