/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public final class Utils {
    private static final String SNAPSHOT_TYPE_FULL = "FULL";
    private static final String SNAPSHOT_TYPE_INCREMENTAL = "INCREMENTAL";
    private static final DateTimeFormatter FULL_DATE_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);

    private Utils() {
    }

    public static String epochMillisToString(long millis, DateTimeFormatter formatter) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault()).format(formatter);
    }

    public static String snapshotCreationDate(long snapId) {
        return Utils.epochMillisToString(snapId, FULL_DATE_FMT);
    }

    public static String snapshotType(boolean isFull) {
        return isFull ? SNAPSHOT_TYPE_FULL : SNAPSHOT_TYPE_INCREMENTAL;
    }
}

