/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.txdr.utility.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.gridgain.database.utility.commands.CommandRemote;
import org.gridgain.grid.internal.visor.txdr.VisorReplicationInfo;
import org.gridgain.grid.internal.visor.txdr.VisorReplicationResumeTask;

public class CommandResume
extends CommandRemote {
    public static final String CMD_NAME = "RESUME";

    @Override
    public String name() {
        return CMD_NAME;
    }

    @Override
    public int errorBase() {
        return 5000;
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command allows resuming replication session on replica cluster.");
        this.addHelpUsage(new String[0]);
        this.addHelpExample();
        this.addHelpExample(null);
        this.addHelpExample("-output=my_file.txt");
        this.addHelpArguments();
        this.addHelpCommonArgs();
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorCommon();
        this.addHelpErrorOutput();
    }

    private Collection<String> prepareTextOutput(VisorReplicationInfo info) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("sessionId: " + info.sessionId());
        lines.add("resumed: true");
        return lines;
    }

    private void printToOutputJson(VisorReplicationInfo info) throws IOException {
        ObjectNode json = MAPPER.createObjectNode();
        json.put("sessionId", info.sessionId());
        json.put("resumed", true);
        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
    }

    private void printToOutput(VisorReplicationInfo info) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareTextOutput(info));
                break;
            }
            case "JSON": {
                this.printToOutputJson(info);
                break;
            }
        }
    }

    @Override
    protected int executeCmd() throws Throwable {
        VisorReplicationInfo res = (VisorReplicationInfo)this.execute(VisorReplicationResumeTask.class, null);
        this.printToConsole(this.prepareTextOutput(res));
        this.printToOutput(res);
        return 0;
    }
}

