/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.gridgain.database.utility.commands.CommandRemote;
import org.gridgain.grid.internal.visor.database.snapshot.VisorDeleteSnapshotTask;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfo;

public class CommandDelete
extends CommandRemote {
    public CommandDelete() {
        this.supportedArgs.add("-ID");
        this.supportedArgs.add("-COMMENT");
        this.supportedArgs.add("-CHAIN");
        this.supportedArgs.add("-NOPROGRESS");
        this.supportedArgs.add("-VERBOSE");
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command will delete specified snapshot.");
        this.addHelpUsage("-id=SNAPSHOT_ID", "[-verbose]");
        this.addHelpExample();
        this.addHelpExample("-id=1234567");
        this.addHelpExample("-id=1234567", "-verbose");
        this.addHelpExample("-id=1234567", "-ssl_enabled -ssl_protocol=SSLv23 -ssl_algorithm=SunX509 -ssl_truststore_type=jks -ssl_truststore_path=/path/to/truststore.jks -ssl_truststore_password=<PASSWORD> -ssl_key_store_type=pkcs12 -ssl_key_store_path=/path/to/keystore.pkcs12 -ssl_key_store_password=<PASSWORD>");
        this.addHelpExample("-id=1234567", "-output=my_file.txt");
        this.addHelpExample("-id=1234567", "-host=192.168.1.10");
        this.addHelpArguments();
        this.addHelpIndent("-id=SNAPSHOT_ID - snapshot identifier to use.").NL();
        this.addHelpIndent("-chain=SINGLE|FROM, param which define how to work with snapshot chains  (FULL-INC-INC-INC...):\n\tSINGLE - manipulate only with the defined snapshot (default);\tFROM - manipulate with snapshot chain (FULL-INC-INC-INC...) from the defined snasphot to the last one;").NL();
        this.addHelpIndent("-noprogress - do not print progress bar.").NL();
        this.addHelpCommonArgs();
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorCommon();
        this.addHelpError(500, "snapshot utility failed to find snapshot with specified ID.");
        this.addHelpError(520, "concurrent snapshot operations are not allowed cluster-wide.");
        this.addHelpError(750, "snapshot has dependent snapshots and could not be removed in default mode. Use '-chain=SINGLE|FROM' to define how to work with snapshot and his dependent snapshots.");
        this.addHelpError(720, "snapshot utility failed to delete snapshots with specified IDs.");
        this.addHelpErrorOutput();
    }

    @Override
    public String name() {
        return "DELETE";
    }

    @Override
    public int errorBase() {
        return 7000;
    }

    private Collection<String> prepareTextOutput(long id) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Delete status:");
        lines.add("  ID: " + id);
        lines.add("  Deleted: true");
        return lines;
    }

    private void printToOutputJson(long id) throws IOException {
        ObjectNode json = MAPPER.createObjectNode();
        json.put("id", id);
        json.put("deleted", true);
        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
    }

    private void printToOutput(long id) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareTextOutput(id));
                break;
            }
            case "JSON": {
                this.printToOutputJson(id);
                break;
            }
        }
    }

    @Override
    protected int executeCmd() throws Throwable {
        long id = this.longArg("-ID", -1L);
        if (id < 0L) {
            throw new IllegalArgumentException("Snapshot ID was not specified");
        }
        this.execute(VisorDeleteSnapshotTask.class, new VisorSnapshotInfo.Builder().withSnapshotId(id).withMessage(this.message()).withSnapshotChainMode(this.chainMode()).build());
        this.printToConsole("Snapshot deleted");
        this.printToOutput(id);
        return 0;
    }
}

