/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.indexreader;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.RandomAccessFileIO;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.lang.IgniteOutClosure;
import org.gridgain.database.indexreader.FilePosition;

public class SnapshotFilePageStore
extends FilePageStore {
    private final List<FilePosition> pageFilePositions;
    private final Map<File, FileIO> fileIOs;

    public SnapshotFilePageStore(byte type, DataStorageConfiguration dsCfg, List<FilePosition> pageFilePositions, LongAdderMetric allocatedTracker) {
        super(type, (IgniteOutClosure & Serializable)() -> {
            throw new UnsupportedOperationException();
        }, (FileIOFactory & Serializable)(file, modes) -> {
            throw new UnsupportedOperationException();
        }, dsCfg, arg_0 -> ((LongAdderMetric)allocatedTracker).add(arg_0));
        this.pageFilePositions = pageFilePositions;
        this.fileIOs = new HashMap<File, FileIO>();
        for (FilePosition filePosition : pageFilePositions) {
            if (!Objects.nonNull(filePosition)) continue;
            this.fileIOs.put(filePosition.file(), null);
        }
    }

    public synchronized void ensure() throws IgniteCheckedException {
        for (Map.Entry<File, FileIO> entry : this.fileIOs.entrySet()) {
            File file = entry.getKey();
            try {
                entry.setValue((FileIO)new RandomAccessFileIO(file, new OpenOption[]{StandardOpenOption.READ}));
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Error while create I/O file=" + file.getAbsolutePath(), (Throwable)e);
            }
        }
        this.allocated.set(this.size());
        this.inited = true;
    }

    public long pageOffset(long pageId) {
        FilePosition filePosition;
        int pageIdx = PageIdUtils.pageIndex((long)pageId);
        FilePosition filePosition2 = filePosition = pageIdx >= this.pageFilePositions.size() ? null : this.pageFilePositions.get(pageIdx);
        if (Objects.isNull(filePosition)) {
            throw new IllegalArgumentException("Unknown position for page [id=" + pageId + ", idx=" + pageIdx + "]");
        }
        return filePosition.position();
    }

    protected FileIO fileIO(long pageId, boolean hdr) {
        if (hdr) {
            throw new IllegalArgumentException("Header not supported");
        }
        return this.fileIOs.get(this.pageFilePositions.get(PageIdUtils.pageIndex((long)pageId)).file());
    }

    public String getFileAbsolutePath() {
        return this.fileIOs.keySet().stream().map(File::getAbsolutePath).collect(Collectors.joining(", "));
    }

    public long size() {
        return this.pageSize * this.pageFilePositions.size();
    }

    public int headerSize() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stop(boolean del) throws StorageException {
        try {
            for (Map.Entry<File, FileIO> entry : this.fileIOs.entrySet()) {
                File file = entry.getKey();
                FileIO fileIO = entry.getValue();
                try {
                    fileIO.close();
                    if (del) {
                        throw new IOException("Read-only");
                    }
                    entry.setValue(null);
                }
                catch (IOException e) {
                    throw new StorageException("Error while stop [file=" + file.getAbsolutePath() + ", delete=" + del + "]", e);
                    return;
                }
            }
        }
        finally {
            this.inited = false;
            this.allocated.set(0L);
        }
    }
}

