/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility.commands;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gridgain.database.utility.commands.CommandRemote;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotStatus;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotsStatusTask;

class ProgressUpdater
implements AutoCloseable {
    private static final Logger log = LogManager.getLogger(ProgressUpdater.class);
    private final CommandRemote cmd;
    private final ScheduledExecutorService pool;

    public ProgressUpdater(CommandRemote cmd, int delaySec) {
        this.cmd = cmd;
        this.pool = Executors.newScheduledThreadPool(1);
        this.pool.scheduleWithFixedDelay(this::backgroundUpdate, delaySec, delaySec, TimeUnit.SECONDS);
    }

    private void backgroundUpdate() {
        block4: {
            try {
                VisorSnapshotStatus status = (VisorSnapshotStatus)this.cmd.execute(VisorSnapshotsStatusTask.class, null);
                if (status != null) {
                    double progress = this.cmd.overallProgress(status.getProgress().values());
                    this.printProgressBar(progress);
                }
            }
            catch (RuntimeException e) {
                log.error("Failed to execute background status update.", (Throwable)e);
                throw e;
            }
            catch (Throwable t) {
                if (X.hasCause((Throwable)t, (Class[])new Class[]{InterruptedException.class})) break block4;
                log.error("Failed to execute background status update.", t);
                throw new RuntimeException("", t);
            }
        }
    }

    private void printProgressBar(double progress) {
        int intProgress = Math.min(100, (int)(110.0 * progress));
        StringBuilder strBuilder = new StringBuilder("\r");
        for (int i = 0; i < intProgress; ++i) {
            strBuilder.append("=");
        }
        System.out.printf("%-110s %2$3s%%", strBuilder.toString(), intProgress);
    }

    private void clearStatusBar() {
        this.printProgressBar(100.0);
        System.out.flush();
        System.out.println();
    }

    @Override
    public void close() {
        this.pool.shutdownNow();
        this.clearStatusBar();
    }
}

