/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility.commands;

import java.io.Console;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.net.ssl.TrustManager;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientAuthenticationException;
import org.apache.ignite.internal.client.GridClientClosedException;
import org.apache.ignite.internal.client.GridClientCompute;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.client.GridClientHandshakeException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridServerUnreachableException;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionResetException;
import org.apache.ignite.internal.client.marshaller.GridClientMarshaller;
import org.apache.ignite.internal.client.marshaller.optimized.GridClientZipOptimizedMarshaller;
import org.apache.ignite.internal.client.ssl.GridSslBasicContextFactory;
import org.apache.ignite.internal.client.ssl.GridSslContextFactory;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityCredentialsBasicProvider;
import org.apache.ignite.plugin.security.SecurityCredentialsProvider;
import org.apache.ignite.ssl.SslContextFactory;
import org.gridgain.database.utility.commands.CacheConfigurationException;
import org.gridgain.database.utility.commands.Command;
import org.gridgain.database.utility.commands.ProgressUpdater;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotConfigurationRequestTask;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotConfigurationRequestTaskResult;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotProgress;
import org.jetbrains.annotations.Nullable;

public abstract class CommandRemote
extends Command {
    protected static final String ARG_CONFIG = "-CONFIG";
    protected static final String ARG_TYPE = "-TYPE";
    protected static final String ARG_FORCE = "-FORCE";
    protected static final String ARG_DEST = "-DEST";
    protected static final String ARG_KEY_ALIAS = "-KEY_ALIAS";
    protected static final String ARG_NOCHECK = "-NOCHECK";
    protected static final String ARG_CLUSTER = "-CLUSTER";
    protected static final String ARG_HISTORY = "-HISTORY";
    protected static final String ARG_FROM = "-FROM";
    protected static final String ARG_TO = "-TO";
    protected static final String ARG_LAST = "-LAST";
    protected static final String ARG_COMMAND = "-COMMAND";
    protected static final String ARG_HOST = "-HOST";
    protected static final String ARG_PORT = "-PORT";
    protected static final String ARG_PING_INTERVAL = "-PING_INTERVAL";
    protected static final String ARG_PING_TIMEOUT = "-PING_TIMEOUT";
    protected static final String ARG_COMMENT = "-COMMENT";
    protected static final String ARG_ANALYZE = "-ANALYZE";
    protected static final String ARG_GROUP_ID = "-GRPID";
    protected static final String ARG_PART_ID = "-PARTID";
    protected static final String ARG_NOPROGRESS = "-NOPROGRESS";
    protected static final String ARG_PROGRESS_DELAY = "-PROGRESS";
    protected static final String ARG_SKIP_WAL = "-SKIP_WAL";
    protected static final String ARG_NEED_EXCHANGE = "-NEEDEXCHANGE";
    protected static final String ARG_ENCRYPTION_KEY = "-ENCRYPTION_KEY";
    protected static final String ARG_SSL_ENABLED = "-SSL_ENABLED";
    protected static final String ARG_SSL_PROTOCOL = "-SSL_PROTOCOL";
    protected static final String ARG_SSL_ALGORITHM = "-SSL_ALGORITHM";
    protected static final String ARG_SSL_CIPHER_SUITES = "-SSL_CIPHER_SUITES";
    protected static final String ARG_SSL_KEY_STORE_TYPE = "-SSL_KEY_STORE_TYPE";
    protected static final String ARG_SSL_KEY_STORE_PATH = "-SSL_KEY_STORE_PATH";
    protected static final String ARG_SSL_KEY_STORE_PASSWORD = "-SSL_KEY_STORE_PASSWORD";
    protected static final String ARG_SSL_TRUSTSTORE_TYPE = "-SSL_TRUSTSTORE_TYPE";
    protected static final String ARG_SSL_TRUSTSTORE_PATH = "-SSL_TRUSTSTORE_PATH";
    protected static final String ARG_SSL_TRUSTSTORE_PASSWORD = "-SSL_TRUSTSTORE_PASSWORD";
    protected static final String ARG_ARCHIVE = "-ARCHIVE";
    protected static final String ARG_COMPRESSION_LEVEL = "-COMPRESSION_LEVEL";
    protected static final String ARG_PARALLELISM = "-PARALLELISM";
    protected static final String ARG_WRITE_THROTTLING = "-WRITE_THROTTLING";
    protected static final String ARG_CHAIN = "-CHAIN";
    protected static final String ARG_DELETE_SOURCE = "-DELETE_SOURCE";
    protected static final String ARG_SINGLE_COPY = "-SINGLE_COPY";
    protected static final int NO_ID = -1;
    private static final String DFLT_HOST = "127.0.0.1";
    private static final int DFLT_PORT = 11211;
    private static final int DFLT_PING_INTERVAL = 5000;
    private static final int DFLT_PING_TIMEOUT = 30000;
    protected static final String HELP_ARG_CONFIG = "-config=config.xml - read new caches configurations from specified file on restore.";
    protected static final String HELP_ARG_NOCHECK1 = "-nocheck - if this argument is specified, snapshot utility will not check";
    protected static final String HELP_ARG_NOCHECK2 = "  snapshot before restore.";
    protected static final String HELP_ARG_SRC = "-src=path1[,path2,...,pathN] - list of optional folders to search for snapshot files.";
    protected static final String HELP_ARG_DEST = "-dest=EXTERNAL_FOLDER - folder name where snapshot files should be moved.";
    protected static final String HELP_ARG_KEY_ALIAS = "-key_alias=alias - alias for JKS key for working with SFTP server.";
    protected static final String HELP_ARG_FROM1 = "-from=TIMESTAMP - this argument allows to specify period left bound.";
    protected static final String HELP_ARG_FROM2 = "  Where TIMESTAMP should be in \"yyyy-MM-dd-HH:mm:ss.SSS\" format.";
    protected static final String HELP_ARG_TO1 = "-to=TIMESTAMP - this argument allows to specify period right bound.";
    protected static final String HELP_ARG_PITR_TO1 = "-to=TIMESTAMP - this argument allows to specify point in time.";
    protected static final String HELP_ARG_TO2 = "  Where TIMESTAMP should be in \"yyyy-MM-dd-HH:mm:ss.SSS\" format.";
    protected static final String HELP_ARG_CHAIN = "-chain=SINGLE|FROM, param which define how to work with snapshot chains  (FULL-INC-INC-INC...):\n\tSINGLE - manipulate only with the defined snapshot (default);\tFROM - manipulate with snapshot chain (FULL-INC-INC-INC...) from the defined snasphot to the last one;";
    protected static final String HELP_ARG_SINGLE_COPY = "-single_copy - will synchronize node to copy partition files exactly once.";
    protected static final String HELP_ARG_DELETE_SOURCE = "-delete_source - COPY will remove original snapshot if copy phase finished successfully cluster-wide.";
    protected static final String HELP_ARG_LAST = "-last=PERIOD - period to show latest info.";
    protected static final String HELP_ARG_NOPROGRESS = "-noprogress - do not print progress bar.";
    protected static final String HELP_ARG_PROGRESS_DELAY = "-progress=DELAY - delay (sec) for progress bar update, default is 5 sec.";
    protected static final String HELP_ARG_SKIP_WAL = "-skip_wal - move snapshot without dependent WAL.";
    private static final String HELP_ARG_HOST1 = "-host=IP or HOST_NAME - this argument allows to specify host IP or host name";
    private static final String HELP_ARG_HOST2 = "  that will be used as connection point to cluster, by default 127.0.0.1 will be used.";
    private static final String HELP_ARG_PORT1 = "-port=PORT_NUMBER - this argument allows to specify port number,";
    private static final String HELP_ARG_PORT2 = "  by default 11211 will be used.";
    private static final String HELP_ARG_PING_INTERVAL1 = "-ping_interval=TIME - this argument allows to specify ping interval in milliseconds";
    private static final String HELP_ARG_PING_INTERVAL2 = "  to detect network failures and half-opened sockets, by default 5000 will be used.";
    private static final String HELP_ARG_PING_TIMEOUT1 = "-ping_timeout=TIME - this argument allows to specify ping timeout interval in milliseconds.";
    private static final String HELP_ARG_PING_TIMEOUT2 = "  If no response received in period equal to this timeout than connection considered";
    private static final String HELP_ARG_PING_TIMEOUT3 = "  broken and closed, by default 30000 will be used.";
    private static final String HELP_ARG_USER = "-user=NAME - user name to use for connecting to secures cluster.";
    private static final String HELP_ARG_PASSWORD = "-password=PASSWORD - password to use for connecting to secures cluster.";
    private static final String HELP_ARG_SSL_ENABLED = "-ssl_enabled - enables connection via SSL";
    private static final String HELP_ARG_SSL_PROTOCOL = "-ssl_protocol=SSL_PROTOCOL[, SSL_PROTOCOL_2, ...] - SSL protocols, by default TLS will be used.";
    private static final String HELP_ARG_SSL_ALGORITHM = "-ssl_algorithm=SSL_ALGORITHM - SSL algorithm, by default " + SslContextFactory.DFLT_KEY_ALGORITHM + " will be used.";
    private static final String HELP_ARG_SSL_CIPHER_SUITES = "-ssl_cipher_suites=SSL_CIPHER_1[, SSL_CIPHER_2, ...] - list of cipher suites.";
    private static final String HELP_ARG_SSL_KEY_STORE_TYPE = "-ssl_key_store_type=SSL_KEY_STORE_TYPE - type of key store, by default " + SslContextFactory.DFLT_STORE_TYPE + " will be used.";
    private static final String HELP_ARG_SSL_KEY_STORE_PATH = "-ssl_key_store_path=PATH_TO_KEY_STORE - path to key store.";
    private static final String HELP_ARG_SSL_KEY_STORE_PASSWORD = "-ssl_key_store_password=PASSWORD - password for key store.";
    private static final String HELP_ARG_SSL_TRUSTSTORE_TYPE = "-ssl_truststore_type=SSL_TRUST_STORE_TYPE - type of trust store, by default " + SslContextFactory.DFLT_STORE_TYPE + " will be used.";
    private static final String HELP_ARG_SSL_TRUSTSTORE_PATH = "-ssl_truststore_path=PATH_TO_TRUST_STORE - path to trust store.";
    private static final String HELP_ARG_SSL_TRUSTSTORE_PASSWORD = "-ssl_truststore_password=PASSWORD - password for trust store.";
    private static final String HELP_ARG_COMMENT = "-comment=text - this argument allows to specify optional comment for command.";
    protected static final String HELP_USAGE_TYPE = "[-type=full|inc]";
    protected static final String HELP_USAGE_NOCHECK = "[-nocheck]";
    protected static final String HELP_USAGE_CACHES = "[-caches=cache1,cache2,...,cacheN]";
    protected static final String HELP_USAGE_CONFIG = "[-config=config.xml]";
    protected static final String HELP_USAGE_SRC = "[-src=path1[,path2,...,pathN]]";
    protected static final String HELP_USAGE_DEST = "-dest=EXTERNAL_FOLDER";
    protected static final String HELP_USAGE_KEY_ALIAS = "-key_alias=ALIAS";
    protected static final String HELP_USAGE_FORCE = "[-force]";
    protected static final String HELP_USAGE_FROM = "[-from=yyyy-MM-dd-HH:mm:ss.SSS]";
    protected static final String HELP_USAGE_TO = "-to=yyyy-MM-dd-HH:mm:ss.SSS";
    protected static final String HELP_USAGE_LAST = "[-last=PERIOD]";
    protected static final String HELP_USAGE_HISTORY = "-history";
    private static final String HELP_USAGE_COMMENT = "[-comment=text]";
    protected static final String HELP_USAGE_NOPROGRESS = "[-noprogress]";
    protected static final String HELP_USAGE_PROGRESS_DELAY = "[-progress=DELAY]";
    protected static final String HELP_USAGE_SKIP_WAL = "[-skip_wal]";
    protected static final String HELP_USAGE_CHAIN = "[-chain=SINGLE|FROM]";
    protected static final String HELP_USAGE_DELETE_SOURCE = "[-delete_source]";
    protected static final String HELP_USAGE_SINGLE_COPY = "-single_copy";
    protected static final String HELP_EXAMPLE_TYPE_FULL = "-type=full";
    protected static final String HELP_EXAMPLE_TYPE_INC = "-type=inc";
    protected static final String HELP_NOCHECK = "-nocheck";
    protected static final String HELP_EXAMPLE_CONFIG = "-config=config.xml";
    protected static final String HELP_EXAMPLE_SRC = "-src=/snapshots/2016/12,/snapshots/2017/01";
    protected static final String HELP_EXAMPLE_DEST = "-dest=/snapshots/2017/01";
    protected static final String HELP_EXAMPLE_KEY_ALIAS = "-key_alias=my_sftp";
    protected static final String HELP_EXAMPLE_FORCE = "-force";
    protected static final String HELP_EXAMPLE_OUTPUT = "-output=my_file.txt";
    protected static final String HELP_EXAMPLE_FORMAT = "-format=json";
    protected static final String HELP_EXAMPLE_HOST = "-host=192.168.1.10";
    protected static final String HELP_EXAMPLE_NEED_EXCHANGE = "-needexchange";
    protected static final String HELP_EXAMPLE_PITR_TO = "-to=2017-09-08-03:00:00.000";
    protected static final String HELP_USAGE_IDLE_ANALYZE = "-analyze -grpId=GROUP_ID -partId=PARTITION_ID";
    protected static final String HELP_EXAMPLE_SKIP_WAL = "-skip_wal";
    protected static final String HELP_EXAMPLE_CHAIN = "-chain=SINGLE";
    protected static final String HELP_EXAMPLE_SSL_ENABLED = "-ssl_enabled -ssl_protocol=SSLv23 -ssl_algorithm=SunX509 -ssl_truststore_type=jks -ssl_truststore_path=/path/to/truststore.jks -ssl_truststore_password=<PASSWORD> -ssl_key_store_type=pkcs12 -ssl_key_store_path=/path/to/keystore.pkcs12 -ssl_key_store_password=<PASSWORD>";
    protected static final String HELP_EXAMPLE_SINGLE_COPY = "-single_copy";
    protected static final String HELP_EXAMPLE_PARALLELISM = "-parallelism=4";
    protected static final DateTimeFormatter PIT_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH[:mm[:ss[.SSS]]]", Locale.US);
    protected static final int DFLT_PROGRESS_DELAY_SEC = 5;
    protected static final int PROGRESS_BAR_WIDTH = 110;
    @Nullable
    private volatile GridClient client;
    private volatile ProgressUpdater progressUpdater;

    protected CommandRemote() {
        this.supportedArgs.add(ARG_HOST);
        this.supportedArgs.add(ARG_PORT);
        this.supportedArgs.add(ARG_PING_INTERVAL);
        this.supportedArgs.add(ARG_PING_TIMEOUT);
        this.supportedArgs.add("-USER");
        this.supportedArgs.add("-PASSWORD");
        this.supportedArgs.add("-OUTPUT");
        this.supportedArgs.add("-FORMAT");
        this.supportedArgs.add(ARG_SSL_ENABLED);
        this.supportedArgs.add(ARG_SSL_PROTOCOL);
        this.supportedArgs.add(ARG_SSL_ALGORITHM);
        this.supportedArgs.add(ARG_SSL_CIPHER_SUITES);
        this.supportedArgs.add(ARG_SSL_KEY_STORE_TYPE);
        this.supportedArgs.add(ARG_SSL_KEY_STORE_PATH);
        this.supportedArgs.add(ARG_SSL_KEY_STORE_PASSWORD);
        this.supportedArgs.add(ARG_SSL_TRUSTSTORE_TYPE);
        this.supportedArgs.add(ARG_SSL_TRUSTSTORE_PATH);
        this.supportedArgs.add(ARG_SSL_TRUSTSTORE_PASSWORD);
    }

    @Override
    protected boolean isMaskedArgument(String parsedArg) {
        return super.isMaskedArgument(parsedArg) || ARG_SSL_KEY_STORE_PASSWORD.equalsIgnoreCase(parsedArg) || ARG_SSL_TRUSTSTORE_PASSWORD.equalsIgnoreCase(parsedArg);
    }

    protected void addHelpUsage(String ... usages) {
        this.addHelp("");
        StringBuilder line = new StringBuilder(300);
        line.append("Usage: ").append(this.name());
        if (!F.isEmpty((Object[])usages)) {
            for (String usage : usages) {
                line.append(' ').append(usage);
            }
        }
        this.addHelp(line.toString());
        this.addHelpIndent("[-output=" + this.defaultOutputFileName() + "] [-format=text|json]");
        this.addHelpUsageNetwork();
        if (this.supportedArgs.contains(ARG_COMMENT)) {
            this.addHelpIndent(HELP_USAGE_COMMENT);
        }
    }

    protected String optional(String usage) {
        return '[' + usage + ']';
    }

    protected String optional(String k, String v) {
        return '[' + k + '=' + v + ']';
    }

    protected String optional(String k, int v) {
        return '[' + k + '=' + v + ']';
    }

    protected String alternation(String ... alternatives) {
        return String.join((CharSequence)" | ", alternatives);
    }

    protected void addHelpUsageNetwork() {
        this.addHelpIndent(this.optional(ARG_HOST, DFLT_HOST) + " " + this.optional(ARG_PORT, 11211));
        this.addHelpIndent(this.optional(ARG_PING_INTERVAL, 5000) + " " + this.optional(ARG_PING_TIMEOUT, 30000));
        this.addHelpIndent(this.optional("-USER", "USER") + " " + this.optional("-PASSWORD", "PASSWORD"));
        this.addHelpIndent(this.optional(ARG_SSL_ENABLED));
        this.addHelpIndent(this.optional(ARG_SSL_PROTOCOL, "SSL_PROTOCOL[, SSL_PROTOCOL_2, ...]"));
        this.addHelpIndent(this.optional(ARG_SSL_ALGORITHM, "SSL_ALGORITHM"));
        this.addHelpIndent(this.optional(ARG_SSL_CIPHER_SUITES, "SSL_CIPHER_1[, SSL_CIPHER_2, ...]"));
        this.addHelpIndent(this.optional(ARG_SSL_KEY_STORE_TYPE, "SSL_KEY_STORE_TYPE") + " " + this.optional(ARG_SSL_KEY_STORE_PATH, "PATH_TO_KEY_STORE") + " " + this.optional(ARG_SSL_KEY_STORE_PASSWORD, "PASSWORD"));
        this.addHelpIndent(this.optional(ARG_SSL_TRUSTSTORE_TYPE, "SSL_TRUST_STORE_TYPE") + " " + this.optional(ARG_SSL_TRUSTSTORE_PATH, "PATH_TO_TRUST_STORE") + " " + this.optional(ARG_SSL_TRUSTSTORE_PASSWORD, "PASSWORD"));
    }

    protected void addHelpCommonArgs() {
        this.addHelpIndent("-output=" + this.defaultOutputFileName() + " - file to output command result in machine-readable format,");
        this.addHelpIndent("  by default " + this.defaultOutputFileName() + " will be used.");
        this.NL();
        this.addHelpIndent("-format=text|json - write command output in specified format: text or JSON.");
        this.NL();
        this.addHelpRemoteArgs();
        if (this.supportedArgs.contains(ARG_COMMENT)) {
            this.addHelpIndent(HELP_ARG_COMMENT);
            this.NL();
        }
    }

    protected void addHelpRemoteArgs() {
        this.addHelpIndent(HELP_ARG_HOST1);
        this.addHelpIndent(HELP_ARG_HOST2);
        this.NL();
        this.addHelpIndent(HELP_ARG_PORT1);
        this.addHelpIndent(HELP_ARG_PORT2);
        this.NL();
        this.addHelpIndent(HELP_ARG_PING_INTERVAL1);
        this.addHelpIndent(HELP_ARG_PING_INTERVAL2);
        this.NL();
        this.addHelpIndent(HELP_ARG_PING_TIMEOUT1);
        this.addHelpIndent(HELP_ARG_PING_TIMEOUT2);
        this.addHelpIndent(HELP_ARG_PING_TIMEOUT3);
        this.NL();
        this.addHelpIndent(HELP_ARG_USER).NL();
        this.addHelpIndent(HELP_ARG_PASSWORD);
        this.NL();
        this.addHelpIndent(HELP_ARG_SSL_ENABLED).NL();
        this.addHelpIndent(HELP_ARG_SSL_PROTOCOL).NL();
        this.addHelpIndent(HELP_ARG_SSL_ALGORITHM).NL();
        this.addHelpIndent(HELP_ARG_SSL_KEY_STORE_TYPE).NL();
        this.addHelpIndent(HELP_ARG_SSL_KEY_STORE_PATH).NL();
        this.addHelpIndent(HELP_ARG_SSL_KEY_STORE_PASSWORD).NL();
        this.addHelpIndent(HELP_ARG_SSL_TRUSTSTORE_TYPE).NL();
        this.addHelpIndent(HELP_ARG_SSL_TRUSTSTORE_PATH).NL();
        this.addHelpIndent(HELP_ARG_SSL_TRUSTSTORE_PASSWORD).NL();
        this.addHelpIndent(HELP_ARG_SSL_CIPHER_SUITES);
        this.NL();
    }

    protected void addHelpErrorCommon() {
        this.addHelpError(200, this.utilityName() + " utility failed to authenticate in cluster.");
        this.addHelpError(210, this.utilityName() + " utility failed to authorize in cluster.");
        this.addHelpError(220, this.utilityName() + " utility failed to get secure console for password input.");
        this.addHelpError(300, this.utilityName() + " utility failed to connect to cluster.");
        this.addHelpError(400, "snapshot is not configured, command cannot be executed.");
        this.addHelpError(410, "cluster is inactive, command cannot be executed.");
        this.addHelpError(730, "storage device is full.");
        this.addHelpError(760, "invalid parallelism level.");
    }

    protected boolean isAuthError(GridClientException e) {
        return X.hasCause((Throwable)e, (Class[])new Class[]{GridClientAuthenticationException.class});
    }

    protected boolean isConnectionError(GridClientException e) {
        return e instanceof GridClientClosedException || e instanceof GridClientConnectionResetException || e instanceof GridClientDisconnectedException || e instanceof GridClientHandshakeException || e instanceof GridServerUnreachableException;
    }

    protected String message() {
        String login = System.getProperty("user.name");
        String user = this.stringArg("-USER", login);
        String comment = this.stringArg(ARG_COMMENT, "");
        String launchedFromHost = "";
        try {
            launchedFromHost = U.getLocalHost().toString();
        }
        catch (IOException e) {
            String msg = e.getMessage();
            this.error(800, msg, e);
        }
        return "[src=snapshot-utility, user=" + user + ", login=" + login + ", session=" + this.ses + ", launched from host=" + launchedFromHost + (F.isEmpty((String)comment) ? "" : ", comment=" + comment) + "]";
    }

    protected SnapshotChainMode chainMode() {
        String chainMode = this.stringArg(ARG_CHAIN, null);
        if (chainMode == null) {
            return SnapshotChainMode.DEFAULT;
        }
        switch (chainMode.toUpperCase()) {
            case "SINGLE": {
                return SnapshotChainMode.SINGLE;
            }
            case "FROM": {
                return SnapshotChainMode.FROM_CURRENT_TO_LAST;
            }
            case "TO": {
                return SnapshotChainMode.FROM_ROOT_TO_CURRENT;
            }
        }
        throw new IllegalArgumentException("Unsupported chain mode - " + chainMode);
    }

    protected abstract int executeCmd() throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int execute0() {
        try {
            this.createClient();
            int res = this.executeCmd();
            this.printPIRTScheduleWarningIfNeeded();
            int n = res;
            return n;
        }
        catch (IllegalArgumentException e) {
            int errCode = this.error(120, this.exceptionMessage(e, "Invalid or missing arguments for " + this.name() + " command"), e);
            log.info("Please read documentation for {} command:", (Object)this.name());
            this.printHelp();
            int n = errCode;
            return n;
        }
        catch (GridClientException e) {
            if (this.isAuthError(e)) {
                int errCode = this.errorCode(200);
                return errCode;
            }
            if (this.isConnectionError(e)) {
                int errCode = this.error(300, "Connection to cluster failed", e);
                return errCode;
            }
            String msg = e.getMessage();
            if (msg != null) {
                if (this.containsIgnoreCase(msg, "GridGain snapshots are not configured") || this.containsIgnoreCase(msg, "Persistence is not configured")) {
                    int n = this.error(400, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Can not perform the operation because the cluster is inactive")) {
                    int n = this.error(410, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "consider adding ignite-schedule module to classpath")) {
                    int n = this.error(420, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Snapshot schedule not found")) {
                    int n = this.error(430, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Schedule with such name already exists")) {
                    int n = this.error(440, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Concurrent snapshot operations are not allowed cluster-wide.")) {
                    int n = this.error(520, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Can't create incremental snapshot")) {
                    int n = this.error(530, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Last snapshots are different on nodes for cache group = ")) {
                    int n = this.error(531, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Snapshot does not exist [id=") || this.containsIgnoreCase(msg, "Failed to restore snapshot (a snapshot with the given id does not exist):")) {
                    int n = this.error(500, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Caches or groups from command parameters not found: ") || this.containsIgnoreCase(msg, "The following caches do not exist")) {
                    int n = this.error(600, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Use -force")) {
                    int n = this.error(700, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Use -chain")) {
                    int n = this.error(750, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Parallelism should be positive")) {
                    int n = this.error(760, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Invalid compression level")) {
                    int n = this.error(770, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Inapplicable compression level, compression is off.")) {
                    int n = this.error(780, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Throttling threshold should be positive")) {
                    int n = this.error(120, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Failed to move snapshot to the destination folder")) {
                    int n = this.error(710, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Failed to create snapshot directory")) {
                    int n = this.error(710, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Invalid destination path.")) {
                    int n = this.error(710, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Failed to delete snapshots with the following IDs")) {
                    int n = this.error(720, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Authorization failed")) {
                    int n = this.error(210, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Snapshot operation in non-cancelable state!")) {
                    int n = this.error(950, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Storage device is full")) {
                    int n = this.error(730, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "set skip moving WAL files option")) {
                    int n = this.error(740, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Directory does not exist")) {
                    int n = this.error(910, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Stop current replication process before bootstrapping new one")) {
                    int n = this.error(970, msg, e);
                    return n;
                }
                if (this.containsIgnoreCase(msg, "Failed to add schedule task: it's possible to add one only to the end of the task chain")) {
                    int n = this.error(450, msg, e);
                    return n;
                }
            }
            int n = this.error(e);
            return n;
        }
        catch (CacheConfigurationException e) {
            int msg = this.error(610, e.getMessage(), e);
            return msg;
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (this.containsIgnoreCase(msg, "Failed to get information from snapshots catalog")) {
                int n = this.error(900, msg, e);
                return n;
            }
            int n = this.error(800, msg, e);
            return n;
        }
        catch (Throwable e) {
            int n = this.error(e);
            return n;
        }
        finally {
            this.destroyClient();
        }
    }

    protected boolean progressSupported() {
        return this.supportedArgs.contains(ARG_NOPROGRESS);
    }

    protected int port(int dfltPort) {
        int port = this.intArg(ARG_PORT, dfltPort);
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid value for port: " + port);
        }
        return port;
    }

    protected int snapshotParallelism(VisorSnapshotInfo snapshot) {
        return snapshot.getSnapshotCommonParameters() != null ? snapshot.getSnapshotCommonParameters().getSnapshotOperationParallelism() : 2;
    }

    protected String snapshotCompressionOption(VisorSnapshotInfo snapshot) {
        return snapshot.getSnapshotCreateParameters() != null ? snapshot.getSnapshotCreateParameters().getCompressionOption().toString() : CompressionOption.NONE.toString();
    }

    protected String snapshotCompressionLevel(VisorSnapshotInfo snapshot) {
        CompressionOption compressionOption;
        int level = snapshot.getSnapshotCreateParameters() != null ? snapshot.getSnapshotCreateParameters().getCompressionLevel() : -1;
        CompressionOption compressionOption2 = compressionOption = snapshot.getSnapshotCreateParameters() != null ? snapshot.getSnapshotCreateParameters().getCompressionOption() : SnapshotConfiguration.DEFAULT_COMPRESSION;
        if (compressionOption.isCompressed()) {
            return level == -1 ? String.valueOf(compressionOption.defaultCompressionLevel()) : String.valueOf(level);
        }
        return "NONE";
    }

    protected String baselineTopology(VisorSnapshotInfo snapshotInfo) {
        return snapshotInfo.getBaselineTopologySize() != -1 ? String.valueOf(snapshotInfo.getBaselineTopologySize()) : "N/A";
    }

    protected Integer baselineTopologyInt(VisorSnapshotInfo snapshotInfo) {
        return snapshotInfo.getBaselineTopologySize() != -1 ? Integer.valueOf(snapshotInfo.getBaselineTopologySize()) : null;
    }

    private void createClient() throws GridClientException {
        boolean hasUsr;
        if (!this.useGridClient()) {
            return;
        }
        GridClientConfiguration clnCfg = new GridClientConfiguration();
        long pingInterval = this.longArg(ARG_PING_INTERVAL, 5000L);
        if (pingInterval <= 0L) {
            throw new IllegalArgumentException("Invalid value for ping interval: " + pingInterval);
        }
        clnCfg.setPingInterval(pingInterval);
        long pingTimeout = this.longArg(ARG_PING_TIMEOUT, 30000L);
        if (pingTimeout <= 0L) {
            throw new IllegalArgumentException("Invalid value for ping timeout: " + pingTimeout);
        }
        clnCfg.setPingTimeout(pingTimeout);
        clnCfg.setMarshaller((GridClientMarshaller)new GridClientZipOptimizedMarshaller(clnCfg.getMarshaller(), U.allPluginProviders()));
        String host = this.stringArg(ARG_HOST, DFLT_HOST);
        int port = this.port(11211);
        clnCfg.setRouters(Collections.singletonList(host + ":" + port));
        String usr = this.stringArg("-USER", "");
        String pwd = this.stringArg("-PASSWORD", "");
        boolean bl = hasUsr = !F.isEmpty((String)usr);
        if (hasUsr) {
            clnCfg.setSecurityCredentialsProvider((SecurityCredentialsProvider)new SecurityCredentialsBasicProvider(new SecurityCredentials(usr, pwd)));
        }
        if (this.hasArg(ARG_SSL_ENABLED)) {
            GridSslBasicContextFactory factory = new GridSslBasicContextFactory();
            String sslProto = this.stringArg(ARG_SSL_PROTOCOL, "TLS");
            List<String> sslProtocols = this.split(sslProto, ",");
            factory.setProtocol(sslProtocols.get(0));
            if (sslProtocols.size() > 1) {
                factory.setProtocols(sslProtocols);
            }
            factory.setKeyAlgorithm(this.stringArg(ARG_SSL_ALGORITHM, SslContextFactory.DFLT_KEY_ALGORITHM));
            if (this.hasArg(ARG_SSL_CIPHER_SUITES)) {
                String cipherSuites = this.stringArg(ARG_SSL_CIPHER_SUITES, "");
                factory.setCipherSuites(this.split(cipherSuites, ","));
            }
            if (!this.hasArg(ARG_SSL_KEY_STORE_PATH)) {
                throw new IllegalArgumentException("SSL key store location is not specified.");
            }
            factory.setKeyStoreFilePath(this.stringArg(ARG_SSL_KEY_STORE_PATH, null));
            if (this.hasArg(ARG_SSL_KEY_STORE_PASSWORD)) {
                factory.setKeyStorePassword(this.stringArg(ARG_SSL_KEY_STORE_PASSWORD, null).toCharArray());
            } else {
                factory.setKeyStorePassword(this.requestPasswordFromConsole("SSL keystore password: "));
            }
            factory.setKeyStoreType(this.stringArg(ARG_SSL_KEY_STORE_TYPE, SslContextFactory.DFLT_STORE_TYPE));
            if (!this.hasArg(ARG_SSL_TRUSTSTORE_PATH)) {
                factory.setTrustManagers(new TrustManager[]{GridSslBasicContextFactory.getDisabledTrustManager()});
            } else {
                factory.setTrustStoreFilePath(this.stringArg(ARG_SSL_TRUSTSTORE_PATH, null));
                if (this.hasArg(ARG_SSL_TRUSTSTORE_PASSWORD)) {
                    factory.setTrustStorePassword(this.stringArg(ARG_SSL_TRUSTSTORE_PASSWORD, null).toCharArray());
                } else {
                    factory.setTrustStorePassword(this.requestPasswordFromConsole("SSL truststore password: "));
                }
                factory.setTrustStoreType(this.stringArg(ARG_SSL_TRUSTSTORE_TYPE, SslContextFactory.DFLT_STORE_TYPE));
            }
            clnCfg.setSslContextFactory((GridSslContextFactory)factory);
        }
        this.client = GridClientFactory.start((GridClientConfiguration)clnCfg);
    }

    private void destroyClient() {
        if (this.useGridClient() && this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    protected boolean useGridClient() {
        return true;
    }

    protected <R> R execute(Class<?> taskCls, Object taskArgs) throws Exception {
        return (R)this.withProgressUpdate(() -> {
            GridClientCompute compute = this.client.compute();
            GridClientNode initiatorNode = this.getBalancedNode(compute);
            return compute.projection(initiatorNode).execute(taskCls.getName(), (Object)new VisorTaskArgument(initiatorNode.nodeId(), taskArgs, false));
        });
    }

    @Nullable
    protected <R> R executeWithCompatibility(Class<?> taskCls, Object taskArgs, IgniteFeatures feature) throws Exception {
        return (R)this.withProgressUpdate(() -> {
            GridClientCompute compute = this.client.compute();
            List initiatorNodes = this.client.compute().nodes().stream().filter(n -> n.supports(feature)).filter(GridClientNode::connectable).collect(Collectors.toList());
            if (initiatorNodes.isEmpty()) {
                return null;
            }
            GridClientNode initiatorNode = compute.balancer().balancedNode(initiatorNodes);
            return compute.projection(initiatorNode).execute(taskCls.getName(), (Object)new VisorTaskArgument(initiatorNode.nodeId(), taskArgs, false));
        });
    }

    protected void printPIRTScheduleWarningIfNeeded() throws Exception {
        VisorSnapshotConfigurationRequestTaskResult taskRes;
        if (this.client == null) {
            return;
        }
        try {
            taskRes = (VisorSnapshotConfigurationRequestTaskResult)this.executeWithCompatibility(VisorSnapshotConfigurationRequestTask.class, null, IgniteFeatures.IMPROPER_SCHEDULE_FOR_PITR_WARNING);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to check snapshot schedule for PITR due to exception", (Throwable)e);
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Result of checking snapshot schedule for PITR: " + taskRes);
        }
        if (taskRes == null) {
            return;
        }
        if (taskRes.isPitrEnabled() && !taskRes.isScheduleProperForPitr()) {
            this.printToConsole("Point in time recovery is enabled but snapshot schedule isn't set up properly. This may lead to excessive storage space usage. Schedule periodic snapshot create/move/delete using 'snapshot-utility.(sh|bat) schedule' command.");
            this.writeToOutput(Collections.singleton("Point in time recovery is enabled but snapshot schedule isn't set up properly. This may lead to excessive storage space usage. Schedule periodic snapshot create/move/delete using 'snapshot-utility.(sh|bat) schedule' command."), true);
        }
    }

    private GridClientNode getBalancedNode(GridClientCompute compute) throws GridClientException {
        ArrayList<GridClientNode> nodes = new ArrayList<GridClientNode>();
        for (GridClientNode node : compute.nodes()) {
            if (!node.connectable()) continue;
            nodes.add(node);
        }
        if (F.isEmpty(nodes)) {
            throw new GridClientDisconnectedException("Connectable node not found", null);
        }
        return compute.balancer().balancedNode(nodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R withProgressUpdate(Callable<R> c) throws Exception {
        ProgressUpdater progressUpdater0 = null;
        if (this.progressUpdater == null && this.progressSupported() && !this.hasArg(ARG_NOPROGRESS)) {
            progressUpdater0 = this.progressUpdater = new ProgressUpdater(this, this.intArg(ARG_PROGRESS_DELAY, 5));
        }
        try {
            R r = c.call();
            return r;
        }
        finally {
            if (progressUpdater0 != null) {
                progressUpdater0.close();
                this.progressUpdater = null;
            }
        }
    }

    protected char[] requestPasswordFromConsole(String msg) {
        Console console = System.console();
        if (console == null) {
            throw new UnsupportedOperationException("Failed to securely read password (console is unavailable): " + msg);
        }
        return console.readPassword(msg, new Object[0]);
    }

    protected double overallProgress(Collection<SnapshotProgress> nodesProgress) {
        double overallProgress = 1.0;
        for (SnapshotProgress progress : nodesProgress) {
            double nodeProgress = progress.getOperationProgress();
            if (!(overallProgress > nodeProgress)) continue;
            overallProgress = nodeProgress;
        }
        return overallProgress;
    }
}

