/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility.commands;

import java.util.Map;
import org.apache.ignite.internal.util.typedef.F;
import org.gridgain.database.utility.commands.Command;
import org.gridgain.database.utility.commands.Commands;

public class CommandHelp
extends Command {
    public CommandHelp() {
        this.supportedArgs.add("HELP");
        this.supportedArgs.add("LIST");
        this.supportedArgs.add("INFO");
        this.supportedArgs.add("SNAPSHOT");
        this.supportedArgs.add("RESTORE");
        this.supportedArgs.add("CHECK");
        this.supportedArgs.add("DELETE");
        this.supportedArgs.add("MOVE");
        this.supportedArgs.add("COPY");
        this.supportedArgs.add("STATUS");
        this.supportedArgs.add("CANCEL");
        this.supportedArgs.add("SCHEDULE");
        this.supportedArgs.add("METADATA");
        this.supportedArgs.add("ANALYZE");
        this.supportedArgs.add("CLEANUP_RESTARTING_CACHES");
        this.supportedArgs.add("SECURITY_LEVEL");
    }

    @Override
    public String name() {
        return "HELP";
    }

    @Override
    public int errorBase() {
        return 1000;
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command will print information about specified command.").NL();
        this.addHelp("Usage: HELP command").NL();
        this.addHelp("Snapshots utility supports following commands:");
        this.addHelpIndent("HELP");
        this.addHelpIndent("LIST");
        this.addHelpIndent("INFO");
        this.addHelpIndent("SNAPSHOT");
        this.addHelpIndent("RESTORE");
        this.addHelpIndent("CHECK");
        this.addHelpIndent("DELETE");
        this.addHelpIndent("MOVE");
        this.addHelpIndent("COPY");
        this.addHelpIndent("STATUS");
        this.addHelpIndent("CANCEL");
        this.addHelpIndent("SCHEDULE");
        this.addHelpIndent("METADATA");
        this.addHelpIndent("ANALYZE");
        this.addHelpIndent("CLEANUP_RESTARTING_CACHES");
        this.addHelpIndent("SECURITY_LEVEL");
        this.addHelpExample();
        this.addHelpExample("");
        this.addHelpExample("list");
        this.addHelpExample("info");
        this.addHelpExample("snapshot");
        this.addHelpExample("restore");
        this.addHelpExample("check");
        this.addHelpExample("delete");
        this.addHelpExample("move");
        this.addHelpExample("copy");
        this.addHelpExample("status");
        this.addHelpExample("cancel");
        this.addHelpExample("schedule");
        this.addHelpExample("metadata");
        this.addHelpExample("analyze");
        this.addHelpExample("CLEANUP_RESTARTING_CACHES".toLowerCase());
    }

    @Override
    protected int execute0() {
        Command cmd = this;
        if (!F.isEmpty((Map)this.parsedArgs)) {
            String arg = ((String)F.first(this.parsedArgs.keySet())).toUpperCase();
            try {
                cmd = Commands.valueOf(arg).command();
            }
            catch (IllegalArgumentException ignored) {
                log.info("Unknown command: {}", (Object)arg);
            }
            catch (Throwable e) {
                log.error("Unexpected exception", e);
            }
        }
        cmd.printHelp();
        return 0;
    }
}

