/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.indexreader;

import java.io.File;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.commandline.indexreader.IndexReaderUtils;

public class SnapshotCrcCheckedException
extends IgniteCheckedException {
    private static final String MSG = "Crc failed check [crcSaved=%s, crcCalc=%s, partId=%s, file=%s, readPageNum=%s, snapshotChain=%s]";
    private final int crcSaved;
    private final int crcCalc;
    private final int partId;
    private final File snapshotDir;
    private final int readPageNum;
    private final List<File> fileChain;

    SnapshotCrcCheckedException(int crcSaved, int crcCalc, int partId, File snapshotDir, int readPageNum, List<File> fileChain) {
        this.crcSaved = crcSaved;
        this.crcCalc = crcCalc;
        this.partId = partId;
        this.snapshotDir = snapshotDir;
        this.readPageNum = readPageNum;
        this.fileChain = fileChain;
    }

    public String getMessage() {
        return String.format(MSG, this.crcSaved, this.crcCalc, this.partId, IndexReaderUtils.partitionFileAbsolutePath((File)this.snapshotDir, (int)this.partId), this.readPageNum, this.fileChain);
    }
}

