/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.indexreader;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.commandline.indexreader.IgniteIndexReaderFilePageStoreFactory;
import org.apache.ignite.internal.commandline.indexreader.IndexReaderUtils;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.FastCrc;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.util.GridUnsafe;
import org.gridgain.database.indexreader.ArrayWrapper;
import org.gridgain.database.indexreader.BuildPagePositionException;
import org.gridgain.database.indexreader.FilePosition;
import org.gridgain.database.indexreader.SnapshotCrcCheckedException;
import org.gridgain.database.indexreader.SnapshotFilePageStore;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInputStream;
import org.gridgain.grid.persistentstore.snapshot.file.FileSnapshotInputStream;
import org.jetbrains.annotations.Nullable;

public class SnapshotFilePageStoreFactory
implements IgniteIndexReaderFilePageStoreFactory {
    public static final int SKIP_EXCEPTION_THRESHOLD = 100;
    private final List<File> snapshotChain;
    private final DataStorageConfiguration dsCfg;
    private final LongAdderMetric allocationTracker = new LongAdderMetric("n", "d");
    private final int partCnt;

    public SnapshotFilePageStoreFactory(List<File> snapshotChain, int pageSize, int partCnt) {
        this.snapshotChain = snapshotChain;
        this.partCnt = partCnt;
        this.dsCfg = new DataStorageConfiguration().setPageSize(pageSize);
    }

    @Nullable
    public FilePageStore createFilePageStore(int partId, byte type, Collection<Throwable> errors) {
        List<FilePosition> positions = this.pagePositions(partId, errors);
        return positions.isEmpty() ? null : new SnapshotFilePageStore(type, this.dsCfg, positions, this.allocationTracker);
    }

    public int pageSize() {
        return this.dsCfg.getPageSize();
    }

    public int partitionCount() {
        return this.partCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FilePosition> pagePositions(int partId, Collection<Throwable> errors) {
        int pageSize = this.dsCfg.getPageSize();
        ByteBuffer buf = GridUnsafe.allocateBuffer((int)pageSize);
        long bufAddr = GridUnsafe.bufferAddress((ByteBuffer)buf);
        try {
            ArrayWrapper<FilePosition> positions = new ArrayWrapper<FilePosition>();
            for (File snapshotDir : this.snapshotChain) {
                File partFile = this.getFile(snapshotDir, partId, null);
                if (!partFile.exists()) continue;
                int readPageNum = 0;
                String consistentId = partFile.getParentFile().getName();
                try {
                    SnapshotInputStream is = FileSnapshotInputStream.of((File)partFile, (int)partId, (int)pageSize, (String)consistentId, (boolean)false);
                    Throwable throwable = null;
                    try {
                        while (is.readNextPage(buf)) {
                            ++readPageNum;
                            buf.rewind();
                            int crcSaved = PageIO.getCrc((long)bufAddr);
                            PageIO.setCrc((long)bufAddr, (int)0);
                            int calced = FastCrc.calcCrc((ByteBuffer)buf, (int)pageSize);
                            long pageId = PageIO.getPageId((ByteBuffer)buf);
                            int pageIdx = PageIdUtils.pageIndex((long)pageId);
                            buf.rewind();
                            if (calced != crcSaved) {
                                if (errors.size() >= 100) continue;
                                errors.add((Throwable)((Object)new SnapshotCrcCheckedException(crcSaved, calced, partId, partFile, readPageNum, this.snapshotChain)));
                                continue;
                            }
                            if (pageIdx + 1 <= positions.size() && !Objects.isNull(positions.get(pageIdx))) continue;
                            positions.set(pageIdx, new FilePosition((readPageNum - 1) * pageSize, partFile));
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                catch (Exception e) {
                    if (errors.size() >= 100) continue;
                    errors.add((Throwable)((Object)new BuildPagePositionException(partId, snapshotDir, readPageNum, this.snapshotChain, e.getMessage())));
                }
            }
            ArrayWrapper arrayWrapper = positions.trimToSize();
            return arrayWrapper;
        }
        finally {
            GridUnsafe.freeBuffer((ByteBuffer)buf);
        }
    }

    private List<File> partitionFiles(List<File> partDirs, int partCnt) {
        assert (!partDirs.isEmpty());
        ArrayList<File> partFiles = new ArrayList<File>();
        for (File partDir : partDirs) {
            File idxFile = this.getFile(partDir, 65535, null);
            if (idxFile.exists()) {
                partFiles.add(idxFile);
            }
            for (int i = 0; i < partCnt; ++i) {
                File partFile = this.getFile(partDir, i, null);
                if (!partFile.exists()) continue;
                partFiles.add(partFile);
            }
        }
        return partFiles;
    }

    private long sizePagePositions(List<File> partFiles, int pageSize) {
        long sizeEstimated = 0L;
        Map<String, List<File>> byFileName = partFiles.stream().collect(Collectors.groupingBy(File::getName));
        long filePosSize = FilePosition.instanceSize();
        long arrWrapSize = ArrayWrapper.instanceSize();
        for (Map.Entry<String, List<File>> entry : byFileName.entrySet()) {
            int maxPageCnt = 0;
            for (File partFile : entry.getValue()) {
                int pageCnt = (int)(partFile.length() / (long)pageSize);
                maxPageCnt = Math.max(maxPageCnt, pageCnt);
                sizeEstimated += filePosSize * (long)pageCnt;
            }
            sizeEstimated += arrWrapSize;
            sizeEstimated = (long)((double)sizeEstimated + (double)IndexReaderUtils.objectArraySize((int)maxPageCnt) * 1.5);
        }
        return sizeEstimated;
    }

    public long estimateMemory() {
        return this.sizePagePositions(this.partitionFiles(this.snapshotChain, this.partCnt), this.pageSize());
    }

    public long freeMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.maxMemory() - (runtime.totalMemory() - runtime.freeMemory());
    }
}

