/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.table.nearcache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.lang.AsyncCursor;
import org.apache.ignite.lang.Cursor;
import org.apache.ignite.table.ContinuousQueryOptions;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.DataStreamerReceiverDescriptor;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.TableRowEventBatch;
import org.apache.ignite.table.criteria.Criteria;
import org.apache.ignite.table.criteria.CriteriaQueryOptions;
import org.apache.ignite.tx.Transaction;
import org.gridgain.internal.table.nearcache.NearCache;
import org.gridgain.internal.table.nearcache.NearCacheValue;
import org.jetbrains.annotations.Nullable;

public class NearCacheRecordView<R, T>
implements RecordView<R> {
    private final RecordView<R> delegate;
    private final NearCache<R, R, T> nearCache;

    public NearCacheRecordView(RecordView<R> delegate, NearCache<R, R, T> nearCache) {
        assert (delegate != null);
        assert (nearCache != null);
        this.delegate = delegate;
        this.nearCache = nearCache;
    }

    public R get(@Nullable Transaction tx, R keyRec) {
        return (R)ViewUtils.sync(this.getAsync(tx, keyRec));
    }

    public CompletableFuture<R> getAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        NearCacheRecordView.checkNoExplicitTransaction(tx);
        return this.nearCache.getAsync(keyRec).thenApply(NearCacheValue::value);
    }

    public List<R> getAll(@Nullable Transaction tx, Collection<R> keyRecs) {
        return (List)ViewUtils.sync(this.getAllAsync(tx, keyRecs));
    }

    public CompletableFuture<List<R>> getAllAsync(@Nullable Transaction tx, Collection<R> keyRecs) {
        ViewUtils.checkCollectionForNulls(keyRecs, (String)"keyRecs", (String)"key");
        NearCacheRecordView.checkNoExplicitTransaction(tx);
        return this.nearCache.getAllAsync(keyRecs).thenApply(result -> {
            ArrayList<Object> ret = new ArrayList<Object>(result.size());
            for (Map.Entry entry : result.entrySet()) {
                NearCacheValue nearCacheVal = (NearCacheValue)entry.getValue();
                ret.add(nearCacheVal.exists() ? (Object)nearCacheVal.value() : null);
            }
            return ret;
        });
    }

    public boolean contains(@Nullable Transaction tx, R key) {
        return (Boolean)ViewUtils.sync(this.containsAsync(tx, key));
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, R key) {
        Objects.requireNonNull(key);
        NearCacheRecordView.checkNoExplicitTransaction(tx);
        return this.nearCache.getAsync(key).thenApply(NearCacheValue::exists);
    }

    public boolean containsAll(@Nullable Transaction tx, Collection<R> keys) {
        return (Boolean)ViewUtils.sync(this.containsAllAsync(tx, keys));
    }

    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<R> keys) {
        ViewUtils.checkKeysForNulls(keys);
        NearCacheRecordView.checkNoExplicitTransaction(tx);
        if (keys.isEmpty()) {
            return CompletableFutures.trueCompletedFuture();
        }
        return this.nearCache.getAllAsync(keys).thenApply(result -> {
            for (Map.Entry entry : result.entrySet()) {
                NearCacheValue nearCacheVal = (NearCacheValue)entry.getValue();
                if (nearCacheVal.exists()) continue;
                return false;
            }
            return true;
        });
    }

    public void upsert(@Nullable Transaction tx, R rec) {
        ViewUtils.sync(this.upsertAsync(tx, rec));
    }

    public CompletableFuture<Void> upsertAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        NearCacheRecordView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(rec, () -> this.delegate.upsertAsync(null, rec));
    }

    public void upsertAll(@Nullable Transaction tx, Collection<R> recs) {
        ViewUtils.sync(this.upsertAllAsync(tx, recs));
    }

    public CompletableFuture<Void> upsertAllAsync(@Nullable Transaction tx, Collection<R> recs) {
        ViewUtils.checkCollectionForNulls(recs, (String)"recs", (String)"rec");
        NearCacheRecordView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(recs, () -> this.delegate.upsertAllAsync(null, recs));
    }

    public R getAndUpsert(@Nullable Transaction tx, R rec) {
        return (R)ViewUtils.sync(this.getAndUpsertAsync(tx, rec));
    }

    public CompletableFuture<R> getAndUpsertAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        NearCacheRecordView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(rec, () -> this.delegate.getAndUpsertAsync(null, rec));
    }

    public boolean insert(@Nullable Transaction tx, R rec) {
        return (Boolean)ViewUtils.sync(this.insertAsync(tx, rec));
    }

    public CompletableFuture<Boolean> insertAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        NearCacheRecordView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(rec, () -> this.delegate.insertAsync(null, rec));
    }

    public List<R> insertAll(@Nullable Transaction tx, Collection<R> recs) {
        return (List)ViewUtils.sync(this.insertAllAsync(tx, recs));
    }

    public CompletableFuture<List<R>> insertAllAsync(@Nullable Transaction tx, Collection<R> recs) {
        ViewUtils.checkCollectionForNulls(recs, (String)"recs", (String)"rec");
        NearCacheRecordView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(recs, () -> this.delegate.insertAllAsync(null, recs));
    }

    public boolean replace(@Nullable Transaction tx, R rec) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, rec));
    }

    public boolean replace(@Nullable Transaction tx, R oldRec, R newRec) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, oldRec, newRec));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        NearCacheRecordView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(rec, () -> this.delegate.replaceAsync(null, rec));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, R oldRec, R newRec) {
        Objects.requireNonNull(oldRec);
        Objects.requireNonNull(newRec);
        NearCacheRecordView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(oldRec, () -> this.delegate.replaceAsync(null, oldRec, newRec));
    }

    public R getAndReplace(@Nullable Transaction tx, R rec) {
        return (R)ViewUtils.sync(this.getAndReplaceAsync(tx, rec));
    }

    public CompletableFuture<R> getAndReplaceAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        NearCacheRecordView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(rec, () -> this.delegate.getAndReplaceAsync(null, rec));
    }

    public boolean delete(@Nullable Transaction tx, R keyRec) {
        return (Boolean)ViewUtils.sync(this.deleteAsync(tx, keyRec));
    }

    public CompletableFuture<Boolean> deleteAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        NearCacheRecordView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(keyRec, () -> this.delegate.deleteAsync(null, keyRec));
    }

    public boolean deleteExact(@Nullable Transaction tx, R rec) {
        return (Boolean)ViewUtils.sync(this.deleteExactAsync(tx, rec));
    }

    public CompletableFuture<Boolean> deleteExactAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        NearCacheRecordView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(rec, () -> this.delegate.deleteExactAsync(null, rec));
    }

    public R getAndDelete(@Nullable Transaction tx, R keyRec) {
        return (R)ViewUtils.sync(this.getAndDeleteAsync(tx, keyRec));
    }

    public CompletableFuture<R> getAndDeleteAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        NearCacheRecordView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(keyRec, () -> this.delegate.getAndDeleteAsync(null, keyRec));
    }

    public List<R> deleteAll(@Nullable Transaction tx, Collection<R> keyRecs) {
        return (List)ViewUtils.sync(this.deleteAllAsync(tx, keyRecs));
    }

    public void deleteAll(@Nullable Transaction tx) {
        ViewUtils.sync(this.deleteAllAsync(tx));
    }

    public CompletableFuture<List<R>> deleteAllAsync(@Nullable Transaction tx, Collection<R> keyRecs) {
        Objects.requireNonNull(keyRecs);
        NearCacheRecordView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(keyRecs, () -> this.delegate.deleteAllAsync(null, keyRecs));
    }

    public CompletableFuture<Void> deleteAllAsync(@Nullable Transaction tx) {
        NearCacheRecordView.checkNoExplicitTransaction(tx);
        this.nearCache.invalidateAll();
        return this.delegate.deleteAllAsync(null);
    }

    public List<R> deleteAllExact(@Nullable Transaction tx, Collection<R> recs) {
        return (List)ViewUtils.sync(this.deleteAllExactAsync(tx, recs));
    }

    public CompletableFuture<List<R>> deleteAllExactAsync(@Nullable Transaction tx, Collection<R> recs) {
        Objects.requireNonNull(recs);
        NearCacheRecordView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(recs, () -> this.delegate.deleteAllExactAsync(null, recs));
    }

    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<R>> publisher, @Nullable DataStreamerOptions options) {
        throw new UnsupportedOperationException("Data Streamer with Near Cache is not supported.");
    }

    public <E, V, A, R1> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V, A, R1> receiver, Function<E, R> keyFunc, Function<E, V> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R1> resultSubscriber, @Nullable DataStreamerOptions options) {
        throw new UnsupportedOperationException("Data Streamer with Near Cache is not supported.");
    }

    public void queryContinuously(Flow.Subscriber<TableRowEventBatch<R>> subscriber, @Nullable ContinuousQueryOptions options) {
        throw new UnsupportedOperationException("Continuous Query with Near Cache is not supported.");
    }

    public Cursor<R> query(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        throw new UnsupportedOperationException("Criteria Query with Near Cache is not supported.");
    }

    public CompletableFuture<AsyncCursor<R>> queryAsync(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        throw new UnsupportedOperationException("Criteria Query with Near Cache is not supported.");
    }

    private static void checkNoExplicitTransaction(@Nullable Transaction tx) {
        if (tx != null) {
            throw new UnsupportedOperationException("Explicit transactions are not supported on views with Near Cache.");
        }
    }

    private <T> CompletableFuture<T> withInvalidation(R key, Supplier<CompletableFuture<T>> delegate) {
        CompletableFuture valueFuture = delegate.get();
        return CompletableFuture.allOf(this.nearCache.invalidateAsync(key), valueFuture).thenCompose(ignored -> valueFuture);
    }

    private <T> CompletableFuture<T> withInvalidation(Collection<R> keys, Supplier<CompletableFuture<T>> delegate) {
        CompletableFuture valueFuture = delegate.get();
        return CompletableFuture.allOf(this.nearCache.invalidateAllAsync(keys), valueFuture).thenCompose(ignored -> valueFuture);
    }

    public void close() throws Exception {
        IgniteUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.nearCache, this.delegate});
    }
}

