/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.table.nearcache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.table.NearCacheOptions;
import org.apache.ignite.table.TableRowEvent;
import org.apache.ignite.table.TableRowEventBatch;
import org.apache.ignite.table.TableRowEventType;
import org.gridgain.internal.table.nearcache.NearCacheEntriesProvider;
import org.gridgain.internal.table.nearcache.NearCacheKey;
import org.gridgain.internal.table.nearcache.NearCacheValue;
import org.jetbrains.annotations.Nullable;

public class NearCache<K, V, T>
implements Closeable {
    private final IgniteLogger logger = Loggers.forClass(NearCache.class);
    private final NearCacheEntriesProvider<K, V, T> entriesProvider;
    private final Cache<NearCacheKey<K, T>, NearCacheValue<V>> caffeine;
    @Nullable
    private final NearCacheSubscriber subscriber;
    private final int updatePollInterval;
    private final long maximumSize;

    public NearCache(NearCacheEntriesProvider<K, V, T> entriesProvider, NearCacheOptions options) {
        assert (options != null) : "Near cache is attempted to be created with null options";
        this.entriesProvider = entriesProvider;
        this.maximumSize = options.maxEntries() == 0L ? Long.MAX_VALUE : options.maxEntries();
        this.caffeine = Caffeine.newBuilder().maximumSize(this.maximumSize).expireAfterWrite(Duration.ofMillis(options.expireAfterUpdate() == 0 ? Integer.MAX_VALUE : (long)options.expireAfterUpdate())).expireAfterAccess(Duration.ofMillis(options.expireAfterAccess() == 0 ? Integer.MAX_VALUE : (long)options.expireAfterAccess())).build();
        this.updatePollInterval = options.updatePollInterval();
        if (this.updatePollInterval > 0) {
            this.subscriber = new NearCacheSubscriber();
            this.entriesProvider.subscribeToNearCacheUpdates(this.subscriber, this.updatePollInterval);
        } else {
            this.subscriber = null;
        }
    }

    public CompletableFuture<NearCacheValue<V>> getAsync(K key) {
        assert (key != null) : "Key could not be null.";
        return this.entriesProvider.getNearCacheKeyAsync(key, true).thenCompose(nearCacheKey -> {
            NearCacheValue cachedValue = (NearCacheValue)this.caffeine.getIfPresent(nearCacheKey);
            if (cachedValue != null) {
                return CompletableFuture.completedFuture(cachedValue);
            }
            return this.refreshAsync((NearCacheKey<K, T>)nearCacheKey);
        });
    }

    public CompletableFuture<Map<NearCacheKey<K, T>, NearCacheValue<V>>> getAllAsync(Collection<K> keys) {
        if (keys.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        return this.entriesProvider.getNearCacheKeysAsync(keys, false).thenCompose(nearCacheKeys -> {
            ArrayList missingKeys = new ArrayList(nearCacheKeys.size());
            ArrayList<Map.Entry<NearCacheKey, NearCacheValue>> entries = new ArrayList<Map.Entry<NearCacheKey, NearCacheValue>>(nearCacheKeys.size());
            for (NearCacheKey nearCacheKey : nearCacheKeys) {
                @Nullable NearCacheValue val = (NearCacheValue)this.caffeine.getIfPresent((Object)nearCacheKey);
                if (val != null) {
                    entries.add(Map.entry(nearCacheKey, val));
                    continue;
                }
                entries.add(null);
                missingKeys.add(nearCacheKey);
            }
            CompletableFuture cachedEntriesFutures = missingKeys.isEmpty() ? CompletableFuture.completedFuture(Collections.emptyMap()) : this.entriesProvider.getNearCacheValuesAsync(null, missingKeys).thenApply(cacheEntries -> {
                Iterator it = cacheEntries.entrySet().iterator();
                int i = 0;
                while ((long)i < Math.min((long)cacheEntries.size(), this.maximumSize)) {
                    Map.Entry entry = it.next();
                    this.caffeine.put((Object)((NearCacheKey)entry.getKey()), (Object)((NearCacheValue)entry.getValue()));
                    ++i;
                }
                return cacheEntries;
            });
            return cachedEntriesFutures.thenApply(cacheEntries -> {
                Iterator newEntriesIt = cacheEntries.entrySet().iterator();
                LinkedHashMap<NearCacheKey, NearCacheValue> ret = new LinkedHashMap<NearCacheKey, NearCacheValue>(entries.size());
                for (Map.Entry entry : entries) {
                    if (entry != null) {
                        ret.put((NearCacheKey)entry.getKey(), (NearCacheValue)entry.getValue());
                        continue;
                    }
                    @Nullable Map.Entry<K, V> newEntry = newEntriesIt.next();
                    ret.put((NearCacheKey)newEntry.getKey(), (NearCacheValue)newEntry.getValue());
                }
                return ret;
            });
        });
    }

    private CompletableFuture<NearCacheValue<V>> refreshAsync(NearCacheKey<K, T> key) {
        assert (key != null) : "Key could not be null.";
        return this.entriesProvider.getNearCacheValueAsync(null, key).thenApply(keyAndValue -> {
            this.caffeine.put((Object)((NearCacheKey)keyAndValue.getFirst()), (Object)((NearCacheValue)keyAndValue.getSecond()));
            return (NearCacheValue)keyAndValue.getSecond();
        });
    }

    CompletableFuture<Void> invalidateAsync(K key) {
        assert (key != null) : "Key could not be null.";
        return this.entriesProvider.getNearCacheKeyAsync(key, false).thenAccept(arg_0 -> this.caffeine.invalidate(arg_0));
    }

    CompletableFuture<Void> invalidateAllAsync(Iterable<? extends K> keys) {
        assert (keys != null) : "Keys could not be null.";
        return this.entriesProvider.getNearCacheKeysAsync(keys, false).thenAccept(arg_0 -> this.caffeine.invalidateAll(arg_0));
    }

    public void invalidateAll() {
        this.caffeine.invalidateAll();
    }

    @Override
    public void close() throws IOException {
        if (this.subscriber != null) {
            try {
                this.subscriber.unsubscribe().get(2L * (long)this.updatePollInterval, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.warn("Interrupted while waiting for the near cache subscriber to finish.", new Object[0]);
            }
            catch (ExecutionException e) {
                this.logger.error("Error while waiting for the near cache subscriber to finish.", (Throwable)e);
            }
            catch (TimeoutException e) {
                this.logger.warn("Timeout exhausted while waiting for the near cache subscriber to finish.", new Object[0]);
            }
        }
        this.caffeine.invalidateAll();
        this.caffeine.cleanUp();
    }

    public Class<V> valueType() {
        return this.entriesProvider.valueType();
    }

    private class NearCacheSubscriber
    implements Flow.Subscriber<TableRowEventBatch<Map.Entry<K, V>>> {
        private final CompletableFuture<Void> unsubscribeFuture = new CompletableFuture();
        private boolean cancelled = false;
        private int ongoingRequests = 0;
        private Flow.Subscription subscription;

        private NearCacheSubscriber() {
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            subscription.request(1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(TableRowEventBatch<Map.Entry<K, V>> item) {
            List rows = item.rows();
            if (rows.isEmpty()) {
                this.subscription.request(1L);
                return;
            }
            ArrayList updatedKeys = new ArrayList(rows.size());
            ArrayList updatedValues = new ArrayList(rows.size());
            for (TableRowEvent row : item.rows()) {
                TableRowEventType type = row.type();
                if (type == TableRowEventType.UPDATED || type == TableRowEventType.CREATED) {
                    @Nullable Map.Entry updatedRow = (Map.Entry)row.entry();
                    assert (updatedRow != null);
                    updatedKeys.add(updatedRow.getKey());
                    updatedValues.add(new NearCacheValue(updatedRow.getValue()));
                    continue;
                }
                if (type != TableRowEventType.REMOVED) continue;
                @Nullable Map.Entry removedRow = (Map.Entry)row.oldEntry();
                assert (removedRow != null);
                updatedKeys.add(removedRow.getKey());
                updatedValues.add(new NearCacheValue());
            }
            NearCacheSubscriber nearCacheSubscriber = this;
            synchronized (nearCacheSubscriber) {
                if (!this.cancelled) {
                    ++this.ongoingRequests;
                    ((CompletableFuture)NearCache.this.entriesProvider.getNearCacheKeysAsync(updatedKeys, false).thenAccept(nearCacheKeys -> {
                        assert (nearCacheKeys.size() == updatedKeys.size());
                        Iterator nearCacheKeysIt = nearCacheKeys.iterator();
                        Iterator valuesIt = updatedValues.iterator();
                        while (nearCacheKeysIt.hasNext()) {
                            NearCacheKey nearCacheKey = (NearCacheKey)nearCacheKeysIt.next();
                            NearCacheValue updatedValue = (NearCacheValue)valuesIt.next();
                            NearCacheValue cachedVal = (NearCacheValue)NearCache.this.caffeine.getIfPresent((Object)nearCacheKey);
                            if (cachedVal == null) continue;
                            NearCache.this.caffeine.put((Object)nearCacheKey, (Object)updatedValue);
                        }
                    })).whenComplete((none, throwable) -> {
                        NearCacheSubscriber nearCacheSubscriber = this;
                        synchronized (nearCacheSubscriber) {
                            --this.ongoingRequests;
                            if (this.cancelled && this.ongoingRequests == 0) {
                                this.unsubscribeFuture.complete(null);
                            }
                        }
                        if (throwable != null) {
                            NearCache.this.logger.error("Error updating near cache entries.", throwable);
                        }
                    });
                    this.subscription.request(1L);
                }
            }
        }

        @Override
        public void onError(Throwable throwable) {
            NearCache.this.logger.error("Error on near cache update polling.", throwable);
        }

        @Override
        public void onComplete() {
            NearCache.this.logger.warn("Near cache update routine terminated.", new Object[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletableFuture<Void> unsubscribe() {
            this.subscription.cancel();
            NearCacheSubscriber nearCacheSubscriber = this;
            synchronized (nearCacheSubscriber) {
                this.cancelled = true;
                if (this.ongoingRequests == 0) {
                    this.unsubscribeFuture.complete(null);
                }
            }
            return this.unsubscribeFuture;
        }
    }
}

