/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.ml.storage;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.gridgain.internal.ml.storage.ModelSource;
import org.gridgain.internal.ml.storage.ModelStorageProvider;
import org.gridgain.ml.ModelNotFoundException;

public class ModelStorageProviderImpl
implements ModelStorageProvider {
    @Override
    public CompletableFuture<ModelSource> createModelSource(String modelUri, String modelId, String version, Map<String, String> properties) {
        if (modelUri == null || modelUri.isEmpty()) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Model URI cannot be null or empty"));
        }
        return CompletableFuture.supplyAsync(() -> {
            Path modelPath;
            Path path = modelPath = modelUri.startsWith("file:") ? Paths.get(URI.create(modelUri)) : Paths.get(modelUri, new String[0]);
            if (Files.exists(modelPath, new LinkOption[0])) {
                return new FileModelSource(modelUri, modelId, version, modelPath);
            }
            throw new RuntimeException((Throwable)new ModelNotFoundException(modelUri));
        });
    }

    public static class FileModelSource
    implements ModelSource {
        private final String uri;
        private final String modelId;
        private final String version;
        private volatile ModelSource.ModelSourceStatus status;
        private final Path filePath;

        FileModelSource(String uri, String modelId, String version, Path filePath) {
            this.uri = uri;
            this.modelId = modelId;
            this.version = version;
            this.filePath = filePath;
            this.status = Files.exists(filePath, new LinkOption[0]) ? ModelSource.ModelSourceStatus.AVAILABLE : ModelSource.ModelSourceStatus.REGISTERED;
        }

        @Override
        public String getUri() {
            return this.uri;
        }

        @Override
        public String getModelId() {
            return this.modelId;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public CompletableFuture<Path> resolveToLocalPath() {
            return CompletableFuture.supplyAsync(() -> {
                if (!Files.exists(this.filePath, new LinkOption[0])) {
                    throw new RuntimeException((Throwable)new ModelNotFoundException(this.filePath.toString()));
                }
                this.status = ModelSource.ModelSourceStatus.AVAILABLE;
                return this.filePath;
            });
        }

        @Override
        public boolean isLocal() {
            return true;
        }

        @Override
        public ModelSource.ModelSourceStatus getStatus() {
            return this.status;
        }

        @Override
        public void setStatus(ModelSource.ModelSourceStatus status) {
            this.status = status;
        }
    }
}

