/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.ml.compute;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.JobExecutionContext;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.table.IgniteTables;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.Table;
import org.apache.ignite.table.Tuple;
import org.gridgain.internal.ml.IgniteMlImpl;
import org.gridgain.internal.ml.compute.PredictionUtils;
import org.gridgain.ml.InferenceException;
import org.gridgain.ml.compute.MlComputeJob;
import org.gridgain.ml.compute.MlOutputMarshaller;
import org.gridgain.ml.model.MlColocatedJobParameters;
import org.jetbrains.annotations.Nullable;

public class MlColocatedPredictionJob<I extends MlColocatedJobParameters, O>
extends MlComputeJob<I, O> {
    public static <I extends MlColocatedJobParameters, O> Class<? extends ComputeJob<I, O>> jobClass() {
        return MlColocatedPredictionJob.class;
    }

    public CompletableFuture<O> predictAsync(JobExecutionContext context, @Nullable I arg) {
        if (arg == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        IgniteTables tables = context.ignite().tables();
        Table table = tables.table(arg.tableName());
        if (table == null) {
            return CompletableFuture.failedFuture((Throwable)new InferenceException("Table not found: " + arg.tableName()));
        }
        RecordView view = table.recordView();
        Tuple resultTuple = (Tuple)view.get(null, (Object)arg.key());
        if (resultTuple == null) {
            return CompletableFuture.failedFuture((Throwable)new InferenceException("No record found for key " + arg.key() + " in table " + arg.tableName()));
        }
        arg.setInput(resultTuple.value(arg.inputColumn()));
        IgniteMlImpl mlImpl = (IgniteMlImpl)Wrappers.unwrap((Object)context.ignite().ml(), IgniteMlImpl.class);
        Executor executor = mlImpl.executor();
        return PredictionUtils.predictAsyncInternal(arg, executor);
    }

    @Nullable
    public Marshaller<O, byte[]> resultMarshaller() {
        return new MlOutputMarshaller();
    }
}

