/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.ml.compute;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.JobExecutionContext;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.marshalling.Marshaller;
import org.gridgain.internal.ml.IgniteMlImpl;
import org.gridgain.internal.ml.compute.PredictionUtils;
import org.gridgain.ml.compute.MlComputeJob;
import org.gridgain.ml.compute.MlOutputListMarshaller;
import org.gridgain.ml.model.MlBatchJobParameters;
import org.jetbrains.annotations.Nullable;

public class MlBatchPredictionJob<I extends MlBatchJobParameters, O>
extends MlComputeJob<I, List<O>> {
    public static <I extends MlBatchJobParameters, O> Class<? extends ComputeJob<I, List<O>>> jobClass() {
        return MlBatchPredictionJob.class;
    }

    public CompletableFuture<List<O>> predictAsync(JobExecutionContext context, @Nullable I arg) {
        if (arg == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        IgniteMlImpl mlImpl = (IgniteMlImpl)Wrappers.unwrap((Object)context.ignite().ml(), IgniteMlImpl.class);
        Executor executor = mlImpl.executor();
        return PredictionUtils.batchPredictAsyncInternal(arg, executor);
    }

    @Nullable
    public Marshaller<List<O>, byte[]> resultMarshaller() {
        return new MlOutputListMarshaller();
    }
}

