/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.ml;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.ml.IgniteMl;
import org.gridgain.ml.model.MlBatchJobParameters;
import org.gridgain.ml.model.MlColocatedJobParameters;
import org.gridgain.ml.model.MlSimpleJobParameters;
import org.gridgain.ml.model.MlSqlJobParameters;

public class LicensedIgniteMl
implements IgniteMl,
Wrapper {
    private final IgniteMl ml;
    private final LicenseFeatureChecker licenseChecker;

    public LicensedIgniteMl(IgniteMl ml, LicenseFeatureChecker licenseChecker) {
        this.ml = ml;
        this.licenseChecker = licenseChecker;
    }

    public <I, O> O predict(MlSimpleJobParameters<I> jobParams) {
        this.licenseChecker.checkFeature(LicenseFeature.ML_INFERENCE);
        return (O)this.ml.predict(jobParams);
    }

    public <I, O> CompletableFuture<O> predictAsync(MlSimpleJobParameters<I> jobParams) {
        this.licenseChecker.checkFeature(LicenseFeature.ML_INFERENCE);
        return this.ml.predictAsync(jobParams);
    }

    public <I, O> List<O> batchPredict(MlBatchJobParameters<I> jobParams) {
        this.licenseChecker.checkFeature(LicenseFeature.ML_INFERENCE);
        return this.ml.batchPredict(jobParams);
    }

    public <I, O> CompletableFuture<List<O>> batchPredictAsync(MlBatchJobParameters<I> jobParams) {
        this.licenseChecker.checkFeature(LicenseFeature.ML_INFERENCE);
        return this.ml.batchPredictAsync(jobParams);
    }

    public <O> List<O> predictFromSql(MlSqlJobParameters jobParams) {
        this.licenseChecker.checkFeature(LicenseFeature.ML_INFERENCE);
        return this.ml.predictFromSql(jobParams);
    }

    public <O> CompletableFuture<List<O>> predictFromSqlAsync(MlSqlJobParameters jobParams) {
        this.licenseChecker.checkFeature(LicenseFeature.ML_INFERENCE);
        return this.ml.predictFromSqlAsync(jobParams);
    }

    public <I, O> O predictColocated(MlColocatedJobParameters<I> jobParams) {
        this.licenseChecker.checkFeature(LicenseFeature.ML_INFERENCE);
        return (O)this.ml.predictColocated(jobParams);
    }

    public <I, O> CompletableFuture<O> predictColocatedAsync(MlColocatedJobParameters<I> jobParams) {
        this.licenseChecker.checkFeature(LicenseFeature.ML_INFERENCE);
        return this.ml.predictColocatedAsync(jobParams);
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return (T)Wrappers.unwrap((Object)this.ml, classToUnwrap);
    }
}

