/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.table;

import java.util.List;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.TupleImpl;
import org.jetbrains.annotations.Nullable;

public final class TupleHelper {
    private static final Object PIN = new Object();

    @Nullable
    public static <T> T valueOrDefault(Tuple tuple, String normalizedName, @Nullable T defaultValue) {
        if (tuple instanceof TupleImpl) {
            return ((TupleImpl)tuple).valueOrDefaultSkipNormalization(normalizedName, defaultValue);
        }
        return tuple.valueOrDefault(IgniteNameUtils.quoteIfNeeded(normalizedName), defaultValue);
    }

    public static Tuple copyColumns(Tuple tuple, List<String> normalizedColumnNames) {
        TupleImpl ret = new TupleImpl(normalizedColumnNames.size());
        if (tuple instanceof TupleImpl) {
            TupleImpl tupleImpl = (TupleImpl)tuple;
            for (String normalizedColumnName : normalizedColumnNames) {
                Object v = tupleImpl.valueOrDefaultSkipNormalization(normalizedColumnName, PIN);
                if (v == PIN) continue;
                ret.setSkipNormalization(normalizedColumnName, v);
            }
        } else {
            for (String normalizedColumnName : normalizedColumnNames) {
                String parsedColumnName = IgniteNameUtils.quoteIfNeeded(normalizedColumnName);
                int idx = tuple.columnIndex(parsedColumnName);
                if (idx < 0) continue;
                ret.set(parsedColumnName, tuple.value(idx));
            }
        }
        return ret;
    }

    public static void setNormalized(Tuple tuple, String normalizedName, @Nullable Object val) {
        if (tuple instanceof TupleImpl) {
            ((TupleImpl)tuple).setSkipNormalization(normalizedName, val);
        } else {
            String quotedName = IgniteNameUtils.quoteIfNeeded(normalizedName);
            tuple.set(quotedName, val);
        }
    }

    private TupleHelper() {
    }
}

