/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.apache.ignite.internal.thread.ThreadAttributes;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteBusyLock;
import org.apache.ignite.internal.util.OperatingSystem;
import org.apache.ignite.internal.util.worker.IgniteWorker;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

public class IgniteUtils {
    private static final long BEGINNING_OF_TIME = System.nanoTime();
    private static final String jdkVer = System.getProperty("java.specification.version");
    private static final ClassLoader igniteClassLoader = IgniteUtils.class.getClassLoader();
    private static final boolean assertionsEnabled = IgniteUtils.class.desiredAssertionStatus();
    private static final Pattern ALPHANUMERIC_UNDERSCORE_PATTERN = Pattern.compile("^[a-zA-Z_0-9]+$");
    private static final Map<String, Class<?>> primitiveMap = Map.of("byte", Byte.TYPE, "short", Short.TYPE, "int", Integer.TYPE, "long", Long.TYPE, "float", Float.TYPE, "double", Double.TYPE, "char", Character.TYPE, "boolean", Boolean.TYPE, "void", Void.TYPE);
    private static final ConcurrentMap<ClassLoader, ConcurrentMap<String, Class<?>>> classCache = new ConcurrentHashMap();
    private static final String JMX_MBEAN_PACKAGE = "org.apache.ignite";
    public static final String JMX_METRIC_GROUP_TYPE = "metrics";

    public static long monotonicMs() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - BEGINNING_OF_TIME);
    }

    public static String jdkVersion() {
        return jdkVer;
    }

    public static int majorJavaVersion(String verStr) {
        if (verStr == null || verStr.isEmpty()) {
            return 0;
        }
        try {
            String[] parts = verStr.split("\\.");
            int major = Integer.parseInt(parts[0]);
            if (parts.length == 1) {
                return major;
            }
            int minor = Integer.parseInt(parts[1]);
            return major == 1 ? minor : major;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static long getTotalMemoryAvailable() {
        Object attr;
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            attr = mbeanServer.getAttribute(ObjectName.getInstance("java.lang", "type", "OperatingSystem"), "TotalPhysicalMemorySize");
        }
        catch (Exception e) {
            return -1L;
        }
        return attr instanceof Long ? (Long)attr : -1L;
    }

    public static int capacity(int expSize) {
        if (expSize < 3) {
            return expSize + 1;
        }
        if (expSize < 0x40000000) {
            return expSize + expSize / 3;
        }
        return Integer.MAX_VALUE;
    }

    public static <K, V> HashMap<K, V> newHashMap(int expSize) {
        return new HashMap(IgniteUtils.capacity(expSize));
    }

    public static <E> HashSet<E> newHashSet(int expSize) {
        return new HashSet(IgniteUtils.capacity(expSize));
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int expSize) {
        return new LinkedHashMap(IgniteUtils.capacity(expSize));
    }

    public static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    public static int hash(Object obj) {
        return IgniteUtils.hash(obj.hashCode());
    }

    public static int hash(long key) {
        int val = (int)(key ^ key >>> 32);
        return IgniteUtils.hash(val);
    }

    public static String readableSize(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static int safeAbs(int i) {
        return Math.max(Math.abs(i), 0);
    }

    public static long safeAbs(long i) {
        return Math.max(Math.abs(i), 0L);
    }

    @SafeVarargs
    @Nullable
    public static <T> T firstNotNull(T ... vals) {
        if (vals == null) {
            return null;
        }
        for (T val : vals) {
            if (val == null) continue;
            return val;
        }
        return null;
    }

    public static ClassLoader igniteClassLoader() {
        return igniteClassLoader;
    }

    public static Class<?> forName(String clsName, @Nullable ClassLoader ldr) throws ClassNotFoundException {
        return IgniteUtils.forName(clsName, ldr, null);
    }

    public static Class<?> forName(String clsName, @Nullable ClassLoader ldr, @Nullable Predicate<String> clsFilter) throws ClassNotFoundException {
        Class<?> old;
        ConcurrentMap<String, Class<?>> ldrMap;
        assert (clsName != null);
        Class<?> cls = primitiveMap.get(clsName);
        if (cls != null) {
            return cls;
        }
        if (ldr == null) {
            ldr = igniteClassLoader;
        }
        if ((ldrMap = (ConcurrentHashMap)classCache.get(ldr)) == null && (old = (ConcurrentMap)classCache.putIfAbsent(ldr, ldrMap = new ConcurrentHashMap())) != null) {
            ldrMap = old;
        }
        if ((cls = (Class<?>)ldrMap.get(clsName)) == null) {
            if (clsFilter != null && !clsFilter.test(clsName)) {
                throw new ClassNotFoundException("Deserialization of class " + clsName + " is disallowed.");
            }
            cls = Class.forName(clsName, true, ldr);
            old = ldrMap.putIfAbsent(clsName, cls);
            if (old != null) {
                cls = old;
            }
        }
        return cls;
    }

    public static boolean deleteIfExists(Path path) {
        try {
            IgniteUtils.deleteIfExistsThrowable(path);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void deleteIfExistsThrowable(Path path) throws IOException {
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc != null) {
                    throw exc;
                }
                Files.deleteIfExists(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.deleteIfExists(file);
                return FileVisitResult.CONTINUE;
            }
        };
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)visitor);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    public static void fsyncDir(Path dir) throws IOException {
        assert (Files.isDirectory(dir, new LinkOption[0])) : dir;
        if (OperatingSystem.current() == OperatingSystem.WINDOWS) {
            return;
        }
        try (FileChannel fc = FileChannel.open(dir, StandardOpenOption.READ);){
            fc.force(true);
        }
    }

    public static void fsyncFile(Path file) throws IOException {
        assert (Files.isRegularFile(file, new LinkOption[0])) : file;
        try (FileChannel fc = FileChannel.open(file, StandardOpenOption.WRITE);){
            fc.force(true);
        }
    }

    public static boolean assertionsEnabled() {
        return assertionsEnabled;
    }

    public static void shutdownAndAwaitTermination(@Nullable ExecutorService service, long timeout, TimeUnit unit) {
        if (service == null) {
            return;
        }
        long halfTimeoutNanos = unit.toNanos(timeout) / 2L;
        service.shutdown();
        try {
            if (!service.awaitTermination(halfTimeoutNanos, TimeUnit.NANOSECONDS)) {
                service.shutdownNow();
                service.awaitTermination(halfTimeoutNanos, TimeUnit.NANOSECONDS);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            service.shutdownNow();
        }
    }

    public static void closeAll(Stream<? extends AutoCloseable> closeables) throws Exception {
        AtomicReference ex = new AtomicReference();
        closeables.filter(Objects::nonNull).forEach(closeable -> {
            block2: {
                try {
                    closeable.close();
                }
                catch (Throwable e) {
                    if (ex.compareAndSet(null, e)) break block2;
                    ((Throwable)ex.get()).addSuppressed(e);
                }
            }
        });
        if (ex.get() != null) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow((Throwable)ex.get());
        }
    }

    public static void closeAll(Collection<? extends AutoCloseable> closeables) throws Exception {
        IgniteUtils.closeAll(closeables.stream());
    }

    public static void closeAll(AutoCloseable ... closeables) throws Exception {
        IgniteUtils.closeAll(Arrays.stream(closeables));
    }

    public static void closeAllManually(Stream<? extends ManuallyCloseable> closeables) throws Exception {
        AtomicReference ex = new AtomicReference();
        closeables.filter(Objects::nonNull).forEach(closeable -> {
            block2: {
                try {
                    closeable.close();
                }
                catch (Throwable e) {
                    if (ex.compareAndSet(null, e)) break block2;
                    ((Throwable)ex.get()).addSuppressed(e);
                }
            }
        });
        if (ex.get() != null) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow((Throwable)ex.get());
        }
    }

    public static void closeAllManually(Collection<? extends ManuallyCloseable> closeables) throws Exception {
        IgniteUtils.closeAllManually(closeables.stream());
    }

    public static void closeAllManually(ManuallyCloseable ... closeables) throws Exception {
        IgniteUtils.closeAllManually(Arrays.stream(closeables));
    }

    public static Path atomicMoveFile(Path sourcePath, Path targetPath, @Nullable IgniteLogger log) throws IOException {
        Path success;
        Objects.requireNonNull(sourcePath, "sourcePath");
        Objects.requireNonNull(targetPath, "targetPath");
        try {
            success = Files.move(sourcePath, targetPath, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            if (log != null) {
                if (e instanceof AtomicMoveNotSupportedException) {
                    log.info("Atomic move not supported. Falling back to non-atomic move [reason={}]", e.getMessage());
                } else {
                    log.info("Unable to move atomically. Falling back to non-atomic move [reason={}]", e.getMessage());
                }
                if (targetPath.toFile().exists() && log.isInfoEnabled()) {
                    log.info("The target file already exists [path={}]", targetPath);
                }
            }
            try {
                success = Files.move(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e1) {
                e1.addSuppressed(e);
                if (log != null) {
                    log.warn("Unable to move file. Going to delete source [sourcePath={}, targetPath={}]", sourcePath, targetPath);
                }
                try {
                    Files.deleteIfExists(sourcePath);
                }
                catch (IOException e2) {
                    e2.addSuppressed(e1);
                    if (log != null) {
                        log.warn("Unable to delete file [path={}]", sourcePath);
                    }
                    throw e2;
                }
                throw e1;
            }
        }
        return success;
    }

    public static <O> O nonNullOrElse(@Nullable O obj, O defaultObj) {
        return obj != null ? obj : defaultObj;
    }

    public static boolean isPow2(int i) {
        return i > 0 && (i & i - 1) == 0;
    }

    public static boolean isPow2(long i) {
        return i > 0L && (i & i - 1L) == 0L;
    }

    public static <T> T getUninterruptibly(Future<T> future) throws ExecutionException {
        boolean interrupted = false;
        while (true) {
            try {
                T t = future.get();
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T> T getUninterruptibly(Future<T> future, long timeout) throws ExecutionException, TimeoutException {
        boolean interrupted = false;
        try {
            long start = System.currentTimeMillis();
            while (true) {
                T t;
                long current;
                long wait;
                if ((wait = timeout - ((current = System.currentTimeMillis()) - start)) < 0L) {
                    throw new TimeoutException("Timeout waiting for future completion [timeout=" + timeout + "ms]");
                }
                try {
                    t = future.get(wait, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                return t;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T> T getInterruptibly(Future<T> future) {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow(ExceptionUtils.copyExceptionWithCause(e));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw (RuntimeException)ExceptionUtils.sneakyThrow(e);
        }
    }

    public static void awaitForWorkersStop(Collection<IgniteWorker> workers, boolean cancel, @Nullable IgniteLogger log) {
        if (cancel) {
            workers.forEach(IgniteWorker::cancel);
        }
        for (IgniteWorker worker : workers) {
            try {
                worker.join();
            }
            catch (Exception e) {
                if (log == null || !log.isWarnEnabled()) continue;
                log.debug("Unable to cancel ignite worker [worker={}, reason={}]", worker.toString(), e.getMessage());
            }
        }
    }

    public static <T> T inBusyLock(IgniteBusyLock busyLock, Supplier<T> fn) {
        if (!busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            T t = fn.get();
            return t;
        }
        finally {
            busyLock.leaveBusy();
        }
    }

    public static int inBusyLock(IgniteBusyLock busyLock, IntSupplier fn) {
        if (!busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            int n = fn.getAsInt();
            return n;
        }
        finally {
            busyLock.leaveBusy();
        }
    }

    public static void inBusyLock(IgniteBusyLock busyLock, Runnable fn) {
        if (!busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            fn.run();
        }
        finally {
            busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> CompletableFuture<T> inBusyLockAsync(IgniteBusyLock busyLock, Supplier<CompletableFuture<T>> fn) {
        if (!busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletableFuture<T> completableFuture = fn.get();
            return completableFuture;
        }
        catch (Throwable t) {
            CompletableFuture completableFuture = CompletableFuture.failedFuture(t);
            return completableFuture;
        }
        finally {
            busyLock.leaveBusy();
        }
    }

    public static void inBusyLockSafe(IgniteBusyLock busyLock, Runnable fn) {
        if (!busyLock.enterBusy()) {
            return;
        }
        try {
            fn.run();
        }
        finally {
            busyLock.leaveBusy();
        }
    }

    public static <T> List<T> collectStaticFields(Class<?> sourceCls, Class<? extends T> targetCls) {
        ArrayList<T> result = new ArrayList<T>();
        for (Field f : sourceCls.getDeclaredFields()) {
            if (!targetCls.equals(f.getType()) || !Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers())) continue;
            try {
                T value = targetCls.cast(f.get(sourceCls));
                result.add(value);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
        return result;
    }

    public static <T> void cancelOrConsume(CompletableFuture<T> future, Consumer<T> consumer) {
        future.cancel(true);
        IgniteUtils.consumeIfFinishedSuccessfully(future, consumer);
    }

    public static <T> void failOrConsume(CompletableFuture<T> future, Throwable failure, Consumer<T> consumer) {
        future.completeExceptionally(failure);
        IgniteUtils.consumeIfFinishedSuccessfully(future, consumer);
    }

    private static <T> void consumeIfFinishedSuccessfully(CompletableFuture<T> future, Consumer<T> consumer) {
        if (future.isCancelled() || future.isCompletedExceptionally()) {
            return;
        }
        assert (future.isDone());
        T res = future.join();
        assert (res != null);
        consumer.accept(res);
    }

    public static ObjectName makeMbeanName(@Nullable String nodeName, @Nullable String group, String name) throws MalformedObjectNameException {
        StringBuilder sb = new StringBuilder("org.apache.ignite:");
        if (nodeName != null && !nodeName.isEmpty()) {
            sb.append("nodeName=").append(nodeName).append(',');
        }
        sb.append("type=").append(JMX_METRIC_GROUP_TYPE).append(',');
        if (group != null && !group.isEmpty()) {
            sb.append("group=").append(IgniteUtils.escapeObjectNameValue(group)).append(',');
            if (name.startsWith(group)) {
                name = name.substring(group.length() + 1);
            }
        }
        sb.append("name=").append(IgniteUtils.escapeObjectNameValue(name));
        return new ObjectName(sb.toString());
    }

    private static String escapeObjectNameValue(String s) {
        if (IgniteUtils.alphanumericUnderscore(s)) {
            return s;
        }
        return "\"" + s.replaceAll("[\\\\\"?*]", "\\\\$0") + "\"";
    }

    public static boolean alphanumericUnderscore(String s) {
        return ALPHANUMERIC_UNDERSCORE_PATTERN.matcher(s).matches();
    }

    public static <T> List<T> filter(Collection<T> collection, Predicate<T> predicate) {
        ArrayList<T> result = new ArrayList<T>();
        for (T e : collection) {
            if (!predicate.test(e)) continue;
            result.add(e);
        }
        return result;
    }

    public static <T> Optional<T> findFirst(List<T> list) {
        return list.isEmpty() ? Optional.empty() : Optional.of(list.get(0));
    }

    public static <T> Optional<T> findAny(Collection<T> collection) {
        return IgniteUtils.findAny(collection, null);
    }

    public static <T> Optional<T> findAny(Collection<T> collection, @Nullable Predicate<T> predicate) {
        if (!collection.isEmpty()) {
            for (T t : collection) {
                if (predicate != null && !predicate.test(t)) continue;
                return Optional.ofNullable(t);
            }
        }
        return Optional.empty();
    }

    public static <T> void forEachIndexed(Collection<T> collection, BiConsumer<T, Integer> closure) {
        int i = 0;
        for (T t : collection) {
            closure.accept(t, i++);
        }
    }

    public static <T> CompletableFuture<T> retryOperationUntilSuccess(Supplier<CompletableFuture<T>> operation, Function<Throwable, Boolean> stopRetryCondition, Executor executor) {
        CompletableFuture fut = new CompletableFuture();
        IgniteUtils.retryOperationUntilSuccess(operation, stopRetryCondition, fut, executor);
        return fut;
    }

    public static <T> void retryOperationUntilSuccess(Supplier<CompletableFuture<T>> operation, Function<Throwable, Boolean> stopRetryCondition, CompletableFuture<T> fut, Executor executor) {
        operation.get().whenComplete((res, e) -> {
            if (e == null) {
                fut.complete(res);
            } else if (((Boolean)stopRetryCondition.apply((Throwable)e)).booleanValue()) {
                fut.completeExceptionally((Throwable)e);
            } else {
                executor.execute(() -> IgniteUtils.lambda$retryOperationUntilSuccess$2((Supplier)operation, stopRetryCondition, fut, executor));
            }
        });
    }

    public static boolean startsWith(byte[] key, byte[] prefix) {
        return key.length >= prefix.length && Arrays.equals(key, 0, prefix.length, prefix, 0, prefix.length);
    }

    public static <T> byte[] collectionToBytes(Collection<T> collection, Function<T, byte[]> transform) {
        int bytesObjects = 0;
        ArrayList<byte[]> objects = new ArrayList<byte[]>();
        for (T o : collection) {
            byte[] b = transform.apply(o);
            objects.add(b);
            bytesObjects += b.length;
        }
        ByteBuffer buf = ByteBuffer.allocate(bytesObjects += 4).order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(objects.size());
        for (byte[] o : objects) {
            buf.put(o);
        }
        return buf.array();
    }

    public static <T> List<T> bytesToList(ByteBuffer buf, Function<ByteBuffer, T> transform) {
        int length = buf.getInt();
        assert (length >= 0) : "Negative collection size: " + length;
        ArrayList<T> result = new ArrayList<T>(length);
        for (int i = 0; i < length; ++i) {
            assert (buf.position() < buf.limit()) : "Can't read an object from the given buffer [position=" + buf.position() + ", limit=" + buf.limit() + "]";
            result.add(transform.apply(buf));
        }
        return result;
    }

    public static byte[] byteBufferToByteArray(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset();
            return Arrays.copyOfRange(buffer.array(), offset, offset + buffer.capacity());
        }
        byte[] array = new byte[buffer.capacity()];
        int originalPosition = buffer.position();
        buffer.position(0);
        buffer.get(array);
        buffer.position(originalPosition);
        return array;
    }

    private static CompletableFuture<Void> startAsync(ComponentContext componentContext, Stream<? extends IgniteComponent> components) {
        return CompletableFuture.allOf((CompletableFuture[])components.filter(Objects::nonNull).map(component -> component.startAsync(componentContext)).toArray(CompletableFuture[]::new));
    }

    public static CompletableFuture<Void> startAsync(ComponentContext componentContext, IgniteComponent ... components) {
        return IgniteUtils.startAsync(componentContext, Stream.of(components));
    }

    public static CompletableFuture<Void> startAsync(ComponentContext componentContext, Collection<? extends IgniteComponent> components) {
        return IgniteUtils.startAsync(componentContext, components.stream());
    }

    private static CompletableFuture<Void> stopAsync(ComponentContext componentContext, Stream<? extends IgniteComponent> components) {
        return CompletableFuture.allOf((CompletableFuture[])components.filter(Objects::nonNull).map(igniteComponent -> {
            try {
                return igniteComponent.stopAsync(componentContext);
            }
            catch (Throwable e) {
                return CompletableFuture.failedFuture(e);
            }
        }).toArray(CompletableFuture[]::new));
    }

    public static CompletableFuture<Void> stopAsync(Supplier<CompletableFuture<Void>> ... components) {
        return CompletableFuture.allOf((CompletableFuture[])Stream.of(components).filter(Objects::nonNull).map(igniteComponent -> {
            try {
                return (CompletableFuture)igniteComponent.get();
            }
            catch (Throwable e) {
                return CompletableFuture.failedFuture(e);
            }
        }).toArray(CompletableFuture[]::new));
    }

    public static CompletableFuture<Void> stopAsync(ComponentContext componentContext, IgniteComponent ... components) {
        return IgniteUtils.stopAsync(componentContext, Stream.of(components));
    }

    public static CompletableFuture<Void> stopAsync(ComponentContext componentContext, Collection<? extends IgniteComponent> components) {
        return IgniteUtils.stopAsync(componentContext, components.stream());
    }

    public static void closeQuiet(@Nullable AutoCloseable rsrc) {
        if (rsrc != null) {
            try {
                rsrc.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean shouldSwitchToRequestsExecutor(ThreadOperation ... requiredOperationPermissions) {
        if (Thread.currentThread() instanceof ThreadAttributes) {
            ThreadAttributes thread = (ThreadAttributes)((Object)Thread.currentThread());
            for (ThreadOperation op : requiredOperationPermissions) {
                if (thread.allows(op)) continue;
                return true;
            }
            return false;
        }
        if (PublicApiThreading.executingSyncPublicApi()) {
            return false;
        }
        if (PublicApiThreading.executingAsyncPublicApi()) {
            return true;
        }
        return true;
    }

    private static /* synthetic */ void lambda$retryOperationUntilSuccess$2(Supplier operation, Function stopRetryCondition, CompletableFuture fut, Executor executor) {
        IgniteUtils.retryOperationUntilSuccess(operation, stopRetryCondition, fut, executor);
    }
}

