/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteQuadFunction;
import org.apache.ignite.internal.lang.IgniteTriFunction;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteCheckedException;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.TraceableException;
import org.jetbrains.annotations.Nullable;

public final class ExceptionUtils {
    private static final String[] CAUSE_METHOD_NAMES;
    private static final Method THROWABLE_CAUSE_METHOD;
    private static final List<ExceptionFactory> EXCEPTION_FACTORIES;

    @Nullable
    private static Throwable getCauseUsingWellKnownTypes(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return ((SQLException)throwable).getNextException();
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        return null;
    }

    @Nullable
    private static Throwable getCauseUsingMethodName(Throwable throwable, String mtdName) {
        Method mtd = null;
        try {
            mtd = throwable.getClass().getMethod(mtdName, new Class[]{null});
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        if (mtd != null && Throwable.class.isAssignableFrom(mtd.getReturnType())) {
            try {
                return (Throwable)mtd.invoke((Object)throwable, ArrayUtils.OBJECT_EMPTY_ARRAY);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private static Throwable getCauseUsingFieldName(Throwable throwable, String fieldName) {
        Field field = null;
        try {
            field = throwable.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        if (field != null && Throwable.class.isAssignableFrom(field.getType())) {
            try {
                return (Throwable)field.get(throwable);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isThrowableNested() {
        return THROWABLE_CAUSE_METHOD != null;
    }

    public static boolean isNestedThrowable(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof SQLException || throwable instanceof InvocationTargetException) {
            return true;
        }
        if (ExceptionUtils.isThrowableNested()) {
            return true;
        }
        Class<?> cls = throwable.getClass();
        for (String methodName : CAUSE_METHOD_NAMES) {
            try {
                Method mtd = cls.getMethod(methodName, new Class[]{null});
                if (!Throwable.class.isAssignableFrom(mtd.getReturnType())) continue;
                return true;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        try {
            cls.getField("detail");
            return true;
        }
        catch (NoSuchFieldException | SecurityException exception) {
            return false;
        }
    }

    @Nullable
    public static Throwable getCause(Throwable throwable) {
        return ExceptionUtils.getCause(throwable, CAUSE_METHOD_NAMES);
    }

    @Nullable
    public static Throwable getCause(@Nullable Throwable throwable, String[] mtdNames) {
        if (throwable == null) {
            return null;
        }
        Throwable cause = ExceptionUtils.getCauseUsingWellKnownTypes(throwable);
        if (cause == null) {
            if (mtdNames == null) {
                mtdNames = CAUSE_METHOD_NAMES;
            }
            for (String mtdName : mtdNames) {
                if (mtdName != null && (cause = ExceptionUtils.getCauseUsingMethodName(throwable, mtdName)) != null) break;
            }
            if (cause == null) {
                cause = ExceptionUtils.getCauseUsingFieldName(throwable, "detail");
            }
        }
        return cause;
    }

    public static List<Throwable> getThrowableList(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = ExceptionUtils.getCause(throwable);
        }
        return list;
    }

    public static List<Throwable> getSuppressedList(@Nullable Throwable t) {
        ArrayList<Throwable> result = new ArrayList<Throwable>();
        if (t == null) {
            return result;
        }
        do {
            for (Throwable suppressed : t.getSuppressed()) {
                result.add(suppressed);
                result.addAll(ExceptionUtils.getSuppressedList(suppressed));
            }
        } while ((t = t.getCause()) != null);
        return result;
    }

    public static String getFullStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        List<Throwable> ts = ExceptionUtils.getThrowableList(throwable);
        for (Throwable t : ts) {
            t.printStackTrace(pw);
            if (!ExceptionUtils.isNestedThrowable(t)) continue;
            break;
        }
        return sw.getBuffer().toString();
    }

    public static boolean hasCauseOrSuppressed(@Nullable Throwable throwable, Class<?> ... clazz) {
        return ExceptionUtils.hasCauseOrSuppressed(throwable, null, clazz);
    }

    public static boolean hasCauseOrSuppressed(@Nullable Throwable throwable, @Nullable String message, Class<?> ... clazz) {
        return ExceptionUtils.hasCauseOrSuppressedInternal(throwable, message, clazz, Collections.newSetFromMap(new IdentityHashMap()), true);
    }

    public static boolean hasCause(@Nullable Throwable throwable, Class<?> ... clazz) {
        return ExceptionUtils.hasCause(throwable, null, clazz);
    }

    public static boolean hasCause(@Nullable Throwable throwable, @Nullable String message, Class<?> ... clazz) {
        return ExceptionUtils.hasCauseOrSuppressedInternal(throwable, message, clazz, Collections.newSetFromMap(new IdentityHashMap()), false);
    }

    private static boolean hasCauseOrSuppressedInternal(@Nullable Throwable throwable, @Nullable String message, Class<?> @Nullable [] clazz, Set<Throwable> dejaVu, boolean considerSuppressed) {
        if (throwable == null || clazz == null || clazz.length == 0) {
            return false;
        }
        for (Throwable th = throwable; th != null && dejaVu.add(th); th = th.getCause()) {
            for (Class<?> clazz2 : clazz) {
                if (!clazz2.isAssignableFrom(th.getClass())) continue;
                if (message != null) {
                    if (th.getMessage() == null || !th.getMessage().contains(message)) continue;
                    return true;
                }
                return true;
            }
            if (considerSuppressed) {
                for (Serializable serializable : th.getSuppressed()) {
                    if (!ExceptionUtils.hasCauseOrSuppressedInternal((Throwable)serializable, message, clazz, dejaVu, true)) continue;
                    return true;
                }
            }
            if (th.getCause() == th) break;
        }
        return false;
    }

    public static Throwable unwrapCause(Throwable e) {
        while ((e instanceof CompletionException || e instanceof ExecutionException) && e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    public static Throwable unwrapRootCause(Throwable e) {
        Throwable th = e.getCause();
        if (th == null) {
            return e;
        }
        while (th != e) {
            Throwable t = th;
            if ((th = t.getCause()) != t && th != null) continue;
            return t;
        }
        return e;
    }

    @Nullable
    public static Throwable unwrapCompletionThrowable(@Nullable Throwable t) {
        if (t instanceof CompletionException) {
            return t.getCause();
        }
        return t;
    }

    public static <T extends Exception> T withCause(IgniteTriFunction<UUID, Integer, Throwable, T> supplier, int defaultCode, Throwable t) {
        return (T)ExceptionUtils.withCauseInternal((traceId, code, message, cause) -> (Exception)supplier.apply((UUID)traceId, (Integer)code, t), defaultCode, t);
    }

    public static <T extends Exception> T withCause(IgniteQuadFunction<UUID, Integer, String, Throwable, T> supplier, int defaultCode, String message, Throwable t) {
        return (T)ExceptionUtils.withCauseInternal((traceId, code, m, cause) -> (Exception)supplier.apply((UUID)traceId, (Integer)code, message, t), defaultCode, t);
    }

    public static <T extends Exception> T withCauseAndCode(IgniteTriFunction<UUID, Integer, Throwable, T> supplier, int code, Throwable t) {
        return (T)ExceptionUtils.withCauseInternal((traceId, c, message, cause) -> (Exception)supplier.apply((UUID)traceId, code, t), code, t);
    }

    public static <T extends Exception> T withCauseAndCode(IgniteQuadFunction<UUID, Integer, String, Throwable, T> supplier, int code, String message, Throwable t) {
        return (T)ExceptionUtils.withCauseInternal((traceId, c, m, cause) -> (Exception)supplier.apply((UUID)traceId, code, message, t), code, t);
    }

    private static <T extends Exception> T withCauseInternal(IgniteQuadFunction<UUID, Integer, String, Throwable, T> supplier, int defaultCode, Throwable t) {
        Throwable unwrapped = ExceptionUtils.unwrapCause(t);
        if (unwrapped instanceof TraceableException) {
            TraceableException traceable = (TraceableException)((Object)unwrapped);
            return (T)((Exception)supplier.apply(traceable.traceId(), traceable.code(), unwrapped.getMessage(), t));
        }
        return (T)((Exception)supplier.apply(UUID.randomUUID(), defaultCode, t.getMessage(), t));
    }

    public static Throwable copyExceptionWithCause(CompletionException exception) {
        return ExceptionUtils.copyExceptionWithCauseInternal(exception);
    }

    public static Throwable copyExceptionWithCause(ExecutionException exception) {
        return ExceptionUtils.copyExceptionWithCauseInternal(exception);
    }

    @Nullable
    public static <T extends Throwable> T copyExceptionWithCause(Class<? extends Throwable> clazz, @Nullable UUID traceId, int code, @Nullable String message, @Nullable Throwable cause) {
        T copy = null;
        for (int i = 0; i < EXCEPTION_FACTORIES.size() && copy == null; ++i) {
            copy = EXCEPTION_FACTORIES.get(i).createCopy(clazz, traceId, code, message, cause);
        }
        return copy;
    }

    public static <E extends Throwable> E sneakyThrow(Throwable e) throws E {
        throw e;
    }

    @Nullable
    public static UUID extractTraceIdFrom(Throwable t) {
        if (t instanceof TraceableException) {
            return ((TraceableException)((Object)t)).traceId();
        }
        return null;
    }

    public static int extractCodeFrom(Throwable t) {
        if (t instanceof TraceableException) {
            return ((TraceableException)((Object)t)).code();
        }
        return ErrorGroups.Common.INTERNAL_ERR;
    }

    public static boolean matchAny(Throwable t, int code, int ... codes) {
        int errCode = ExceptionUtils.extractCodeFrom(t);
        if (code == errCode) {
            return true;
        }
        for (int c0 : codes) {
            if (c0 != errCode) continue;
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval=true)
    public static IgniteException wrap(Throwable e) {
        Objects.requireNonNull(e);
        e = ExceptionUtils.unwrapCause(e);
        if (e instanceof IgniteException) {
            IgniteException iex = (IgniteException)e;
            try {
                return (IgniteException)ExceptionUtils.copyExceptionWithCause(e.getClass(), iex.traceId(), iex.code(), e.getMessage(), e);
            }
            catch (Exception ex) {
                throw new RuntimeException("IgniteException-derived class does not have required constructor: " + e.getClass().getName(), ex);
            }
        }
        if (e instanceof IgniteCheckedException) {
            IgniteCheckedException iex = (IgniteCheckedException)e;
            return new IgniteException(iex.traceId(), iex.code(), e.getMessage(), e);
        }
        return new IgniteException(ErrorGroups.Common.INTERNAL_ERR, e.getMessage(), e);
    }

    public static boolean isOrCausedBy(Class<? extends Exception> exceptionClass, @Nullable Throwable ex) {
        return ex != null && (exceptionClass.isInstance(ex) || ExceptionUtils.isOrCausedBy(exceptionClass, ex.getCause()));
    }

    private static <T extends Throwable> Throwable copyExceptionWithCauseInternal(T exception) {
        Throwable cause = exception.getCause();
        if (cause == null) {
            return exception;
        }
        UUID traceId = ExceptionUtils.extractTraceIdFrom(cause);
        int code = ExceptionUtils.extractCodeFrom(cause);
        return ExceptionUtils.copyExceptionWithCause(cause.getClass(), traceId, code, cause.getMessage(), exception);
    }

    private static <T extends Throwable> Class<? extends Throwable> baseIgniteExceptionClass(T t) {
        if (t instanceof IgniteException) {
            return IgniteException.class;
        }
        if (t instanceof IgniteCheckedException) {
            return IgniteCheckedException.class;
        }
        if (t instanceof IgniteInternalException) {
            return IgniteInternalException.class;
        }
        if (t instanceof IgniteInternalCheckedException) {
            return IgniteInternalCheckedException.class;
        }
        return Throwable.class;
    }

    public static String convertStackTraceToSting(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printStream = new PrintWriter(stringWriter);){
            t.printStackTrace(printStream);
            String string = stringWriter.toString();
            return string;
        }
    }

    static {
        Method causeMtd;
        CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};
        try {
            causeMtd = Throwable.class.getMethod("getCause", new Class[]{null});
        }
        catch (Exception ignored) {
            causeMtd = null;
        }
        THROWABLE_CAUSE_METHOD = causeMtd;
        EXCEPTION_FACTORIES = List.of(new ExceptionFactory(MethodType.methodType(Void.TYPE, UUID.class, Integer.TYPE, String.class, Throwable.class)){

            @Override
            <T extends Throwable> T copy(MethodHandle constructor, UUID traceId, int code, String message, Throwable cause) throws Throwable {
                return (T)((Throwable)constructor.invokeWithArguments(traceId, code, message, cause));
            }
        }, new ExceptionFactory(MethodType.methodType(Void.TYPE, UUID.class, Integer.TYPE, String.class)){

            @Override
            <T extends Throwable> T copy(MethodHandle constructor, UUID traceId, int code, String message, Throwable cause) throws Throwable {
                Throwable copy = (Throwable)constructor.invokeWithArguments(traceId, code, message);
                if (cause != null) {
                    try {
                        copy.initCause(cause);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                return (T)copy;
            }
        }, new ExceptionFactory(MethodType.methodType(Void.TYPE, UUID.class, Integer.TYPE, Throwable.class)){

            @Override
            <T extends Throwable> T copy(MethodHandle constructor, UUID traceId, int code, String message, Throwable cause) throws Throwable {
                if (cause != null) {
                    cause = new UtilException(message, cause);
                }
                return (T)((Throwable)constructor.invokeWithArguments(traceId, code, cause));
            }
        }, new ExceptionFactory(MethodType.methodType(Void.TYPE, Integer.TYPE, String.class, Throwable.class)){

            @Override
            <T extends Throwable> T copy(MethodHandle constructor, UUID traceId, int code, String message, Throwable cause) throws Throwable {
                return (T)((Throwable)constructor.invokeWithArguments(code, message, cause));
            }
        }, new ExceptionFactory(MethodType.methodType(Void.TYPE, Integer.TYPE, String.class)){

            @Override
            <T extends Throwable> T copy(MethodHandle constructor, UUID traceId, int code, String message, Throwable cause) throws Throwable {
                Throwable copy = (Throwable)constructor.invokeWithArguments(code, message);
                if (cause != null) {
                    try {
                        copy.initCause(cause);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                return (T)copy;
            }
        }, new ExceptionFactory(MethodType.methodType(Void.TYPE, Integer.TYPE, Throwable.class)){

            @Override
            <T extends Throwable> T copy(MethodHandle constructor, UUID traceId, int code, String message, Throwable cause) throws Throwable {
                if (cause != null) {
                    cause = new UtilException(message, cause);
                }
                return (T)((Throwable)constructor.invokeWithArguments(code, cause));
            }
        }, new ExceptionFactory(MethodType.methodType(Void.TYPE, UUID.class, Integer.TYPE)){

            @Override
            <T extends Throwable> T copy(MethodHandle constructor, UUID traceId, int code, String message, Throwable cause) throws Throwable {
                Throwable copy = (Throwable)constructor.invokeWithArguments(traceId, code);
                if (cause != null) {
                    try {
                        copy.initCause(cause);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                return (T)copy;
            }
        }, new ExceptionFactory(MethodType.methodType(Void.TYPE, String.class, Throwable.class)){

            @Override
            <T extends Throwable> T copy(MethodHandle constructor, UUID traceId, int code, String message, Throwable cause) throws Throwable {
                return (T)((Throwable)constructor.invokeWithArguments(message, cause));
            }
        }, new ExceptionFactory(MethodType.methodType(Void.TYPE, Integer.TYPE)){

            @Override
            <T extends Throwable> T copy(MethodHandle constructor, UUID traceId, int code, String message, Throwable cause) throws Throwable {
                Throwable copy = (Throwable)constructor.invokeWithArguments(code);
                if (cause != null) {
                    try {
                        copy.initCause(cause);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                return (T)copy;
            }
        }, new ExceptionFactory(MethodType.methodType(Void.TYPE, Throwable.class)){

            @Override
            <T extends Throwable> T copy(MethodHandle constructor, UUID traceId, int code, String message, Throwable cause) throws Throwable {
                if (cause != null) {
                    cause = new UtilException(message, cause);
                }
                return (T)((Throwable)constructor.invokeWithArguments(cause));
            }
        }, new ExceptionFactory(MethodType.methodType(Void.TYPE, String.class)){

            @Override
            <T extends Throwable> T copy(MethodHandle constructor, UUID traceId, int code, String message, Throwable cause) throws Throwable {
                Throwable copy = (Throwable)constructor.invokeWithArguments(message);
                if (cause != null) {
                    try {
                        copy.initCause(cause);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                return (T)copy;
            }
        }, new ExceptionFactory(MethodType.methodType(Void.TYPE)){

            @Override
            <T extends Throwable> T copy(MethodHandle constructor, UUID traceId, int code, String message, Throwable cause) throws Throwable {
                Throwable copy = (Throwable)constructor.invokeWithArguments(new Object[0]);
                if (cause != null) {
                    try {
                        copy.initCause(cause);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                return (T)copy;
            }
        });
    }

    private static abstract class ExceptionFactory {
        private final MethodType signature;

        ExceptionFactory(MethodType signature) {
            this.signature = signature;
        }

        @Nullable
        final <T extends Throwable> T createCopy(Class<? extends Throwable> clazz, @Nullable UUID traceId, int code, @Nullable String message, @Nullable Throwable cause) {
            try {
                MethodHandle constructor = MethodHandles.publicLookup().findConstructor(clazz, this.signature);
                T exc = this.copy(constructor, traceId, code, message, cause);
                if (exc instanceof TraceableException) {
                    assert (code == ExceptionUtils.extractCodeFrom(exc)) : "Unexpected error code [originCode=" + code + ", code=" + ExceptionUtils.extractCodeFrom(exc) + ", err=" + exc + "]";
                    try {
                        Class<Throwable> baseExceptionClass = ExceptionUtils.baseIgniteExceptionClass(exc);
                        MethodHandles.privateLookupIn(baseExceptionClass, MethodHandles.lookup()).findSetter(baseExceptionClass, "traceId", UUID.class).invoke((Throwable)exc, traceId);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return exc;
            }
            catch (ClassCastException | IllegalAccessException | NoSuchMethodException | SecurityException | WrongMethodTypeException ignore) {
                return null;
            }
            catch (Throwable t) {
                throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Failed to create a copy of the required exception.", t);
            }
        }

        @Nullable
        abstract <T extends Throwable> T copy(MethodHandle var1, @Nullable UUID var2, int var3, @Nullable String var4, @Nullable Throwable var5) throws Throwable;
    }

    private static class UtilException
    extends RuntimeException {
        public UtilException(String message, Throwable t) {
            super(message, t, false, false);
        }
    }
}

