/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.type;

import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.sql.ColumnType;

public class StructNativeType
extends NativeType {
    private final List<Field> fields;

    StructNativeType(List<Field> fields) {
        super(ColumnType.STRUCT, false, 0);
        this.fields = fields;
    }

    public List<Field> fields() {
        return this.fields;
    }

    public int fieldsCount() {
        return this.fields.size();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StructNativeType that = (StructNativeType)o;
        return Objects.equals(this.fields, that.fields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fields);
    }

    @Override
    public String toString() {
        return S.toString(this);
    }

    public static class Field {
        private final String name;
        private final NativeType type;
        private final boolean nullable;

        Field(String name, NativeType type, boolean nullable) {
            this.name = name;
            this.type = type;
            this.nullable = nullable;
        }

        public String name() {
            return this.name;
        }

        public NativeType type() {
            return this.type;
        }

        public boolean nullable() {
            return this.nullable;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Field field = (Field)o;
            return this.nullable == field.nullable && Objects.equals(this.name, field.name) && Objects.equals(this.type, field.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type, this.nullable);
        }

        public String toString() {
            return S.toString(this);
        }
    }
}

