/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.criteria;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.Nullable;

public class SqlRowProjection
implements Tuple {
    private final SqlRow row;
    private final Object2IntMap<String> columnsIndices;
    private final int[] rowIndexMapping;

    public SqlRowProjection(SqlRow row, ResultSetMetadata meta, String[] cols) {
        this.row = row;
        this.rowIndexMapping = new int[cols.length];
        this.columnsIndices = new Object2IntOpenHashMap<String>(cols.length);
        for (int i = 0; i < cols.length; ++i) {
            String quotedColumnName = IgniteNameUtils.quoteIfNeeded(cols[i]);
            this.columnsIndices.put(quotedColumnName, i);
            this.rowIndexMapping[i] = meta.indexOf(quotedColumnName);
        }
    }

    @Override
    public int columnCount() {
        return this.rowIndexMapping.length;
    }

    @Override
    public String columnName(int columnIndex) {
        return this.row.columnName(this.rowIndexMapping[columnIndex]);
    }

    @Override
    public int columnIndex(String columnName) {
        return this.columnsIndices.getOrDefault((Object)columnName, -1);
    }

    @Override
    @Nullable
    public <T> T valueOrDefault(String columnName, @Nullable T defaultValue) {
        return this.row.valueOrDefault(columnName, defaultValue);
    }

    @Override
    public Tuple set(String columnName, @Nullable Object value) {
        return this.row.set(columnName, value);
    }

    @Override
    @Nullable
    public <T> T value(String columnName) throws IllegalArgumentException {
        return this.row.value(columnName);
    }

    @Override
    @Nullable
    public <T> T value(int columnIndex) {
        return this.row.value(this.rowIndexMapping[columnIndex]);
    }

    @Override
    public boolean booleanValue(String columnName) {
        return this.row.booleanValue(columnName);
    }

    @Override
    public boolean booleanValue(int columnIndex) {
        return this.row.booleanValue(this.rowIndexMapping[columnIndex]);
    }

    @Override
    public byte byteValue(String columnName) {
        return this.row.byteValue(columnName);
    }

    @Override
    public byte byteValue(int columnIndex) {
        return this.row.byteValue(this.rowIndexMapping[columnIndex]);
    }

    @Override
    public short shortValue(String columnName) {
        return this.row.shortValue(columnName);
    }

    @Override
    public short shortValue(int columnIndex) {
        return this.row.shortValue(this.rowIndexMapping[columnIndex]);
    }

    @Override
    public int intValue(String columnName) {
        return this.row.intValue(columnName);
    }

    @Override
    public int intValue(int columnIndex) {
        return this.row.intValue(this.rowIndexMapping[columnIndex]);
    }

    @Override
    public long longValue(String columnName) {
        return this.row.longValue(columnName);
    }

    @Override
    public long longValue(int columnIndex) {
        return this.row.longValue(this.rowIndexMapping[columnIndex]);
    }

    @Override
    public float floatValue(String columnName) {
        return this.row.floatValue(columnName);
    }

    @Override
    public float floatValue(int columnIndex) {
        return this.row.floatValue(this.rowIndexMapping[columnIndex]);
    }

    @Override
    public double doubleValue(String columnName) {
        return this.row.doubleValue(columnName);
    }

    @Override
    public double doubleValue(int columnIndex) {
        return this.row.doubleValue(this.rowIndexMapping[columnIndex]);
    }

    @Override
    public BigDecimal decimalValue(String columnName) {
        return this.row.decimalValue(columnName);
    }

    @Override
    public BigDecimal decimalValue(int columnIndex) {
        return this.row.decimalValue(this.rowIndexMapping[columnIndex]);
    }

    @Override
    public String stringValue(String columnName) {
        return this.row.stringValue(columnName);
    }

    @Override
    public String stringValue(int columnIndex) {
        return this.row.stringValue(this.rowIndexMapping[columnIndex]);
    }

    @Override
    public byte[] bytesValue(String columnName) {
        return this.row.bytesValue(columnName);
    }

    @Override
    public byte[] bytesValue(int columnIndex) {
        return this.row.bytesValue(this.rowIndexMapping[columnIndex]);
    }

    @Override
    public UUID uuidValue(String columnName) {
        return this.row.uuidValue(columnName);
    }

    @Override
    public UUID uuidValue(int columnIndex) {
        return this.row.uuidValue(this.rowIndexMapping[columnIndex]);
    }

    @Override
    public LocalDate dateValue(String columnName) {
        return this.row.dateValue(columnName);
    }

    @Override
    public LocalDate dateValue(int columnIndex) {
        return this.row.dateValue(this.rowIndexMapping[columnIndex]);
    }

    @Override
    public LocalTime timeValue(String columnName) {
        return this.row.timeValue(columnName);
    }

    @Override
    public LocalTime timeValue(int columnIndex) {
        return this.row.timeValue(this.rowIndexMapping[columnIndex]);
    }

    @Override
    public LocalDateTime datetimeValue(String columnName) {
        return this.row.datetimeValue(columnName);
    }

    @Override
    public LocalDateTime datetimeValue(int columnIndex) {
        return this.row.datetimeValue(this.rowIndexMapping[columnIndex]);
    }

    @Override
    public Instant timestampValue(String columnName) {
        return this.row.timestampValue(columnName);
    }

    @Override
    public Instant timestampValue(int columnIndex) {
        return this.row.timestampValue(this.rowIndexMapping[columnIndex]);
    }
}

