/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.ml;

import java.util.List;
import org.apache.ignite.compute.JobDescriptor;
import org.apache.ignite.compute.JobExecutionOptions;
import org.apache.ignite.compute.JobExecutorType;
import org.apache.ignite.deployment.DeploymentUnit;
import org.gridgain.ml.compute.MlInputMarshaller;
import org.gridgain.ml.compute.MlOutputListMarshaller;
import org.gridgain.ml.compute.MlOutputMarshaller;
import org.gridgain.ml.model.MlBatchJobParameters;
import org.gridgain.ml.model.MlColocatedJobParameters;
import org.gridgain.ml.model.MlJobParameters;
import org.gridgain.ml.model.MlSimpleJobParameters;
import org.gridgain.ml.model.MlSqlJobParameters;

public class MlJobDescriptorUtils {
    public static <I, O> JobDescriptor<MlSimpleJobParameters<I>, O> createSimplePredictionDescriptor(MlSimpleJobParameters<I> params) {
        params.validate();
        if (params.hasCustomComponents()) {
            return JobDescriptor.builder(params.customJobClass().getName()).units(MlJobDescriptorUtils.createDeploymentUnits(params)).options(JobExecutionOptions.builder().executorType(JobExecutorType.JAVA_EMBEDDED).build()).argumentMarshaller(params.customInputMarshaller()).resultMarshaller(params.customOutputMarshaller()).build();
        }
        return JobDescriptor.builder("org.gridgain.internal.ml.compute.MlSimplePredictionJob").units(MlJobDescriptorUtils.createDeploymentUnits(params)).options(JobExecutionOptions.builder().executorType(JobExecutorType.JAVA_EMBEDDED).build()).argumentMarshaller(new MlInputMarshaller()).resultMarshaller(new MlOutputMarshaller()).build();
    }

    public static <I, O> JobDescriptor<MlBatchJobParameters<I>, List<O>> createBatchPredictionDescriptor(MlBatchJobParameters<I> params) {
        params.validate();
        if (params.hasCustomComponents()) {
            return JobDescriptor.builder(params.customJobClass().getName()).units(MlJobDescriptorUtils.createDeploymentUnits(params)).options(JobExecutionOptions.builder().executorType(JobExecutorType.JAVA_EMBEDDED).build()).argumentMarshaller(params.customInputMarshaller()).resultMarshaller(params.customOutputMarshaller()).build();
        }
        return JobDescriptor.builder("org.gridgain.internal.ml.compute.MlBatchPredictionJob").units(MlJobDescriptorUtils.createDeploymentUnits(params)).options(JobExecutionOptions.builder().executorType(JobExecutorType.JAVA_EMBEDDED).build()).argumentMarshaller(new MlInputMarshaller()).resultMarshaller(new MlOutputListMarshaller()).build();
    }

    public static <O> JobDescriptor<MlSqlJobParameters, List<O>> createSqlPredictionDescriptor(MlSqlJobParameters params) {
        params.validate();
        if (params.hasCustomComponents()) {
            return JobDescriptor.builder(params.customJobClass().getName()).units(MlJobDescriptorUtils.createDeploymentUnits(params)).options(JobExecutionOptions.builder().executorType(JobExecutorType.JAVA_EMBEDDED).build()).argumentMarshaller(params.customInputMarshaller()).resultMarshaller(params.customOutputMarshaller()).build();
        }
        return JobDescriptor.builder("org.gridgain.internal.ml.compute.MlSqlPredictionJob").units(MlJobDescriptorUtils.createDeploymentUnits(params)).options(JobExecutionOptions.builder().executorType(JobExecutorType.JAVA_EMBEDDED).build()).argumentMarshaller(new MlInputMarshaller()).resultMarshaller(new MlOutputListMarshaller()).build();
    }

    public static <I, O> JobDescriptor<MlColocatedJobParameters<I>, O> createColocatedPredictionDescriptor(MlColocatedJobParameters<I> params) {
        params.validate();
        if (params.hasCustomComponents()) {
            return JobDescriptor.builder(params.customJobClass().getName()).units(MlJobDescriptorUtils.createDeploymentUnits(params)).options(JobExecutionOptions.builder().executorType(JobExecutorType.JAVA_EMBEDDED).build()).argumentMarshaller(params.customInputMarshaller()).resultMarshaller(params.customOutputMarshaller()).build();
        }
        return JobDescriptor.builder("org.gridgain.internal.ml.compute.MlColocatedPredictionJob").units(MlJobDescriptorUtils.createDeploymentUnits(params)).options(JobExecutionOptions.builder().executorType(JobExecutorType.JAVA_EMBEDDED).build()).argumentMarshaller(new MlInputMarshaller()).resultMarshaller(new MlOutputMarshaller()).build();
    }

    private static List<DeploymentUnit> createDeploymentUnits(MlJobParameters params) {
        String modelId = params.id();
        String modelVersion = params.version();
        if (modelId == null || modelId.isEmpty()) {
            throw new IllegalArgumentException("Model ID is required for ML execution");
        }
        if (modelVersion == null || modelVersion.isEmpty()) {
            throw new IllegalArgumentException("Model version is required for ML execution");
        }
        return List.of(new DeploymentUnit(modelId, modelVersion));
    }
}

