/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.lang;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.apache.ignite.internal.tostring.S;

public class JavaLoggerFormatter
extends Formatter {
    private static final int SEVERITY_OFF = Integer.MAX_VALUE;
    private static final int SEVERITY_SEVERE = 1000;
    private static final int SEVERITY_WARNING = 900;
    private static final int SEVERITY_INFO = 800;
    private static final int SEVERITY_CONFIG = 700;
    private static final int SEVERITY_FINE = 500;
    private static final int SEVERITY_FINER = 400;
    private static final int SEVERITY_ALL = Integer.MIN_VALUE;
    private static final int[] LEVEL_VALUES = new int[]{Integer.MIN_VALUE, 400, 500, 700, 800, 900, 1000, Integer.MAX_VALUE};
    public static final String ANONYMOUS_LOGGER_NAME = "UNKNOWN";
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss:SSS Z");

    @Override
    public String format(LogRecord record) {
        String threadName = Thread.currentThread().getName();
        String logName = record.getLoggerName();
        if (logName == null) {
            logName = ANONYMOUS_LOGGER_NAME;
        } else if (logName.contains(".")) {
            logName = logName.substring(logName.lastIndexOf(46) + 1);
        }
        String ex = null;
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            record.getThrown().printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            ex = "\n" + stackTrace;
        }
        return DATE_FORMATTER.format(Instant.ofEpochMilli(record.getMillis()).atZone(ZoneId.systemDefault())) + " [" + this.toLevel(record.getLevel().intValue()) + "][" + threadName + "][" + logName + "] " + this.formatMessage(record) + (String)(ex == null ? "\n" : ex);
    }

    public String toString() {
        return S.toString(JavaLoggerFormatter.class, this);
    }

    private System.Logger.Level toLevel(int severity) {
        switch (severity) {
            case -2147483648: {
                return System.Logger.Level.ALL;
            }
            case 400: {
                return System.Logger.Level.TRACE;
            }
            case 500: 
            case 700: {
                return System.Logger.Level.DEBUG;
            }
            case 800: {
                return System.Logger.Level.INFO;
            }
            case 900: {
                return System.Logger.Level.WARNING;
            }
            case 1000: {
                return System.Logger.Level.ERROR;
            }
            case 0x7FFFFFFF: {
                return System.Logger.Level.OFF;
            }
        }
        int i = Arrays.binarySearch(LEVEL_VALUES, 0, LEVEL_VALUES.length - 2, severity);
        return this.toLevel(LEVEL_VALUES[i >= 0 ? i : -i - 1]);
    }
}

