/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.compute.TaskState;
import org.apache.ignite.compute.TaskStatus;
import org.apache.ignite.internal.compute.JobTaskStatusMapper;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class TaskStateImpl
implements TaskState {
    private static final long serialVersionUID = 8575969461073736006L;
    private final UUID id;
    private final TaskStatus status;
    private final Instant createTime;
    @Nullable
    private final Instant startTime;
    @Nullable
    private final Instant finishTime;

    private TaskStateImpl(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.status = Objects.requireNonNull(builder.status, "status");
        this.createTime = Objects.requireNonNull(builder.createTime, "createTime");
        this.startTime = builder.startTime;
        this.finishTime = builder.finishTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public TaskStatus status() {
        return this.status;
    }

    @Override
    public Instant createTime() {
        return this.createTime;
    }

    @Override
    @Nullable
    public Instant startTime() {
        return this.startTime;
    }

    @Override
    @Nullable
    public Instant finishTime() {
        return this.finishTime;
    }

    public static Builder toBuilder(TaskState state) {
        return new Builder(state);
    }

    public static Builder toBuilder(JobState state) {
        return new Builder().id(state.id()).createTime(state.createTime()).finishTime(state.finishTime()).startTime(state.startTime()).status(JobTaskStatusMapper.toTaskStatus(state.status()));
    }

    public String toString() {
        return S.toString(this);
    }

    public static class Builder {
        private UUID id;
        private TaskStatus status;
        private Instant createTime;
        @Nullable
        private Instant startTime;
        @Nullable
        private Instant finishTime;

        private Builder() {
        }

        private Builder(TaskState state) {
            this.id = state.id();
            this.status = state.status();
            this.createTime = state.createTime();
            this.startTime = state.startTime();
            this.finishTime = state.finishTime();
        }

        public Builder id(UUID id) {
            this.id = id;
            return this;
        }

        public Builder status(TaskStatus status) {
            this.status = status;
            return this;
        }

        public Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public Builder startTime(@Nullable Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder finishTime(@Nullable Instant finishTime) {
            this.finishTime = finishTime;
            return this;
        }

        public TaskStateImpl build() {
            return new TaskStateImpl(this);
        }
    }
}

