/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.tx;

import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ignite.cache.CacheStore;
import org.apache.ignite.cache.CacheWriteMode;
import org.apache.ignite.internal.client.ClientChannel;
import org.apache.ignite.internal.client.ReliableChannel;
import org.apache.ignite.internal.client.proto.tx.ClientInternalTxOptions;
import org.apache.ignite.internal.client.table.InternalCacheStore;
import org.apache.ignite.internal.client.table.WriteBehindService;
import org.apache.ignite.internal.client.tx.ClientTransaction;
import org.apache.ignite.internal.client.tx.ClientTransactions;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.table.InternalTransactionBase;
import org.apache.ignite.tx.Transaction;
import org.apache.ignite.tx.TransactionException;
import org.apache.ignite.tx.TransactionOptions;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;

public class ClientLazyTransaction
implements Transaction,
InternalTransactionBase {
    private final long observableTimestamp;
    @Nullable
    private final TransactionOptions options;
    private final EnumSet<ClientInternalTxOptions> txOptions;
    private volatile CompletableFuture<ClientTransaction> tx;
    private final Map<CacheStore, Map> enlistedStores = new ConcurrentHashMap<CacheStore, Map>();
    private final AtomicReference<CacheWriteMode> enlistedWriteMode = new AtomicReference();
    private final WriteBehindService writeBehindService;

    ClientLazyTransaction(HybridTimestampTracker observableTimestamp, @Nullable TransactionOptions options, WriteBehindService writeBehindService) {
        this(observableTimestamp, options, writeBehindService, EnumSet.noneOf(ClientInternalTxOptions.class));
    }

    public ClientLazyTransaction(HybridTimestampTracker observableTimestamp, @Nullable TransactionOptions options, @Nullable WriteBehindService writeBehindService, @Nullable EnumSet<ClientInternalTxOptions> txOptions) {
        this.observableTimestamp = observableTimestamp.getLong();
        this.options = options;
        this.writeBehindService = writeBehindService;
        this.txOptions = txOptions;
    }

    @Override
    public void commit() throws TransactionException {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        if (tx0 == null) {
            return;
        }
        ClientTransaction tx = tx0.join();
        tx.enlistedStores = this.enlistedStores;
        tx.enlistedCacheWriteMode = this.enlistedWriteMode.get();
        tx.writeBehindService = this.writeBehindService;
        tx.commit();
    }

    @Override
    public CompletableFuture<Void> commitAsync() {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        if (tx0 == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        return ((CompletableFuture)tx0.thenApply(res -> {
            res.enlistedStores = this.enlistedStores;
            res.enlistedCacheWriteMode = this.enlistedWriteMode.get();
            res.writeBehindService = this.writeBehindService;
            return res;
        })).thenCompose(ClientTransaction::commitAsync);
    }

    @Override
    public void rollback() throws TransactionException {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        if (tx0 == null) {
            return;
        }
        tx0.join().rollback();
    }

    @Override
    public CompletableFuture<Void> rollbackAsync() {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        if (tx0 == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        return tx0.thenCompose(ClientTransaction::rollbackAsync);
    }

    @Override
    public final boolean isReadOnly() {
        return this.options != null && this.options.readOnly();
    }

    public boolean isExternal() {
        return this.options != null && this.options.cacheOnly();
    }

    public long timeout() {
        return this.options == null ? 0L : this.options.timeoutMillis();
    }

    public String nodeName() {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        assert (tx0 != null);
        return tx0.join().nodeName();
    }

    @Nullable
    public static ClientLazyTransaction get(@Nullable Transaction tx) {
        if (tx == null) {
            return null;
        }
        if (!(tx instanceof ClientLazyTransaction)) {
            throw ClientTransaction.unsupportedTxTypeException(tx);
        }
        return (ClientLazyTransaction)tx;
    }

    public static IgniteBiTuple<CompletableFuture<ClientTransaction>, Boolean> ensureStarted(Transaction tx, ReliableChannel ch) {
        return ClientLazyTransaction.ensureStarted(tx, ch, () -> ch.getChannelAsync(null));
    }

    public static IgniteBiTuple<CompletableFuture<ClientTransaction>, Boolean> ensureStarted(Transaction tx, ReliableChannel ch, @Nullable Supplier<CompletableFuture<ClientChannel>> channelResolver) {
        if (!(tx instanceof ClientLazyTransaction)) {
            throw ClientTransaction.unsupportedTxTypeException(tx);
        }
        return ((ClientLazyTransaction)tx).ensureStarted(ch, channelResolver);
    }

    private synchronized IgniteBiTuple<CompletableFuture<ClientTransaction>, Boolean> ensureStarted(ReliableChannel ch, @Nullable Supplier<CompletableFuture<ClientChannel>> channelResolver) {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        if (tx0 != null) {
            return new IgniteBiTuple<CompletableFuture<ClientTransaction>, Boolean>(tx0, false);
        }
        this.tx = tx0 = channelResolver != null ? ClientTransactions.beginAsync(ch, this.options, this.observableTimestamp, channelResolver) : new CompletableFuture();
        return new IgniteBiTuple<CompletableFuture<ClientTransaction>, Boolean>(tx0, channelResolver == null);
    }

    public ClientTransaction startedTx() {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        assert (tx0 != null) : "Transaction is not started";
        assert (tx0.isDone()) : "Transaction is starting";
        return tx0.join();
    }

    public long observableTimestamp() {
        return this.observableTimestamp;
    }

    public synchronized <K, V> Map<K, Optional<V>> enlistStore(CacheStore<?, ?> store) {
        CacheWriteMode cacheWriteMode;
        ConcurrentHashMap map = this.enlistedStores.get(store);
        if (map == null) {
            map = new ConcurrentHashMap();
            this.enlistedStores.put(store, map);
        }
        CacheWriteMode cacheWriteMode2 = cacheWriteMode = store instanceof InternalCacheStore ? ((InternalCacheStore)store).cacheWriteMode() : CacheWriteMode.SYNC;
        if (!this.enlistedWriteMode.compareAndSet(null, cacheWriteMode) && this.enlistedWriteMode.get() != cacheWriteMode) {
            throw new TransactionException(GridgainErrorGroups.Cache.TX_INCOMPATIBLE_OPERATION_ERR, IgniteStringFormatter.format("Both SYNC and ASYNC caches can't be enlisted in tx.", new Object[0]));
        }
        return map;
    }

    @Override
    @Nullable
    public HybridTimestamp readTimestamp() {
        return HybridTimestamp.nullableHybridTimestamp(this.observableTimestamp);
    }

    @Nullable
    EnumSet<ClientInternalTxOptions> options() {
        return this.txOptions;
    }
}

