/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.client.ReliableChannel;
import org.apache.ignite.internal.client.TcpIgniteClient;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.IgniteCluster;
import org.jetbrains.annotations.Nullable;

public class ClientCluster
implements IgniteCluster {
    private final ReliableChannel ch;

    public ClientCluster(ReliableChannel ch) {
        this.ch = ch;
    }

    @Override
    public UUID id() {
        return this.ch.clusterId();
    }

    @Override
    public Collection<ClusterNode> nodes() {
        return ViewUtils.sync(this.nodesAsync());
    }

    @Override
    public CompletableFuture<Collection<ClusterNode>> nodesAsync() {
        return this.ch.serviceAsync(48, r -> {
            int cnt = r.in().unpackInt();
            ArrayList<ClusterNode> res = new ArrayList<ClusterNode>(cnt);
            for (int i = 0; i < cnt; ++i) {
                ClusterNode clusterNode = TcpIgniteClient.unpackClusterNode(r);
                res.add(clusterNode);
            }
            return res;
        });
    }

    @Override
    @Nullable
    public ClusterNode localNode() {
        return null;
    }
}

