/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.cache.manager.IgniteCaches;
import org.apache.ignite.catalog.IgniteCatalog;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.client.IgniteClientConfiguration;
import org.apache.ignite.compute.IgniteCompute;
import org.apache.ignite.internal.catalog.sql.IgniteCatalogSqlImpl;
import org.apache.ignite.internal.client.ChannelValidator;
import org.apache.ignite.internal.client.ClientChannel;
import org.apache.ignite.internal.client.ClientChannelFactory;
import org.apache.ignite.internal.client.ClientClusterNode;
import org.apache.ignite.internal.client.ClientMetricSource;
import org.apache.ignite.internal.client.ClientUtils;
import org.apache.ignite.internal.client.IgniteClientConfigurationImpl;
import org.apache.ignite.internal.client.PayloadInputChannel;
import org.apache.ignite.internal.client.PayloadReader;
import org.apache.ignite.internal.client.PayloadWriter;
import org.apache.ignite.internal.client.ReliableChannel;
import org.apache.ignite.internal.client.TcpClientChannel;
import org.apache.ignite.internal.client.compute.ClientCompute;
import org.apache.ignite.internal.client.ml.ClientMl;
import org.apache.ignite.internal.client.network.ClientCluster;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.sql.ClientSql;
import org.apache.ignite.internal.client.structure.ClientStructures;
import org.apache.ignite.internal.client.table.ClientTables;
import org.apache.ignite.internal.client.table.WriteBehindService;
import org.apache.ignite.internal.client.tx.ClientTransactions;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.jdbc.proto.ClientMessage;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.marshaller.ReflectionMarshallersProvider;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.metrics.MetricManagerImpl;
import org.apache.ignite.internal.metrics.exporters.jmx.JmxExporter;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.IgniteCluster;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.table.IgniteTables;
import org.apache.ignite.tx.IgniteTransactions;
import org.gridgain.lang.GridgainErrorGroups;
import org.gridgain.ml.IgniteMl;
import org.gridgain.structure.IgniteStructures;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class TcpIgniteClient
implements IgniteClient {
    private static final AtomicLong GLOBAL_CONN_ID_GEN = new AtomicLong();
    private final IgniteClientConfiguration cfg;
    private final ReliableChannel ch;
    private final ClientTables tables;
    private final ClientTransactions transactions;
    private final ClientCompute compute;
    private final ClientSql sql;
    private final ClientMl ml;
    @Nullable
    private final MetricManager metricManager;
    private final ClientMetricSource metrics;
    private final ReflectionMarshallersProvider marshallers = new ReflectionMarshallersProvider();
    private final ClientCluster cluster;
    private final WriteBehindService writeBehindService;
    private final IgniteStructures structures;
    private String clusterName;
    private final String clientName;

    private TcpIgniteClient(IgniteClientConfigurationImpl cfg, HybridTimestampTracker observableTimeTracker, @Nullable ChannelValidator channelValidator) {
        this(TcpClientChannel::createAsync, cfg, observableTimeTracker, channelValidator);
    }

    private TcpIgniteClient(ClientChannelFactory chFactory, IgniteClientConfigurationImpl cfg, HybridTimestampTracker observableTimeTracker, @Nullable ChannelValidator channelValidator) {
        assert (chFactory != null);
        assert (cfg != null);
        this.cfg = cfg;
        String cfgName = cfg.name();
        this.clientName = cfgName != null ? cfgName : "client_" + GLOBAL_CONN_ID_GEN.incrementAndGet();
        this.metrics = new ClientMetricSource();
        this.ch = new ReliableChannel(chFactory, cfg, this.metrics, observableTimeTracker, channelValidator);
        this.writeBehindService = new WriteBehindService(cfg);
        this.transactions = new ClientTransactions(this.ch, this.writeBehindService);
        this.tables = new ClientTables(this.ch, this.marshallers, this.transactions, cfg.sqlPartitionAwarenessMetadataCacheSize());
        this.compute = new ClientCompute(this.ch, this.tables);
        this.sql = new ClientSql(this.ch, this.marshallers, this.transactions, cfg.sqlPartitionAwarenessMetadataCacheSize());
        this.metricManager = this.initMetricManager(cfg);
        this.cluster = new ClientCluster(this.ch);
        this.structures = new ClientStructures(this.ch, this.sql, this.marshallers, this.transactions, cfg.sqlPartitionAwarenessMetadataCacheSize());
        this.ml = new ClientMl(this.compute, this.cluster::nodesAsync);
    }

    @Nullable
    private MetricManager initMetricManager(IgniteClientConfiguration cfg) {
        if (!cfg.metricsEnabled()) {
            return null;
        }
        MetricManagerImpl metricManager = new MetricManagerImpl(ClientUtils.logger(cfg, MetricManagerImpl.class), this.clientName);
        metricManager.registerSource(this.metrics);
        metricManager.enable(this.metrics);
        metricManager.start(List.of(new JmxExporter(ClientUtils.logger(cfg, JmxExporter.class))));
        return metricManager;
    }

    private CompletableFuture<ClientChannel> initAsync() {
        return this.ch.channelsInitAsync().whenComplete((channel, throwable) -> {
            if (throwable == null) {
                this.clusterName = channel.protocolContext().clusterName();
            }
        });
    }

    public static CompletableFuture<IgniteClient> startAsync(IgniteClientConfigurationImpl cfg) {
        return TcpIgniteClient.startAsync(cfg, HybridTimestampTracker.atomicTracker(null), null);
    }

    public static CompletableFuture<IgniteClient> startAsync(IgniteClientConfigurationImpl cfg, HybridTimestampTracker observableTimeTracker, @Nullable ChannelValidator channelValidator) {
        ErrorGroups.initialize();
        GridgainErrorGroups.initialize();
        try {
            TcpIgniteClient client = new TcpIgniteClient(cfg, observableTimeTracker, channelValidator);
            return client.initAsync().thenApply(x -> client);
        }
        catch (IgniteException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Override
    public IgniteTables tables() {
        return this.tables;
    }

    @Override
    public IgniteCaches caches() {
        return this.tables;
    }

    @Override
    public IgniteTransactions transactions() {
        return this.transactions;
    }

    @Override
    public IgniteSql sql() {
        return this.sql;
    }

    @Override
    public IgniteCompute compute() {
        return this.compute;
    }

    @Override
    public IgniteCatalog catalog() {
        return new IgniteCatalogSqlImpl(this.sql, this.tables, this.tables);
    }

    @Override
    public IgniteCluster cluster() {
        return this.cluster;
    }

    @Override
    public IgniteStructures structures() {
        return this.structures;
    }

    @Override
    public IgniteMl ml() {
        return this.ml;
    }

    @Override
    public void close() {
        AutoCloseable chCloseable = () -> {
            try {
                this.ch.close();
            }
            catch (Exception e) {
                throw new IgniteInternalException(ErrorGroups.Client.CONNECTION_ERR, "Error occurred while closing the channel", (Throwable)e);
            }
        };
        AutoCloseable metricCloseable = () -> {
            if (this.metricManager != null) {
                this.metricManager.beforeNodeStop();
                this.metricManager.stopAsync(new ComponentContext()).join();
            }
        };
        AutoCloseable writeBehindCloseable = () -> {
            if (this.writeBehindService != null) {
                this.writeBehindService.stopAsync().join();
            }
        };
        try {
            IgniteUtils.closeAll(chCloseable, metricCloseable, writeBehindCloseable);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String name() {
        return this.clientName;
    }

    @Override
    public IgniteClientConfiguration configuration() {
        return this.cfg;
    }

    @Override
    public List<ClusterNode> connections() {
        return this.ch.connections();
    }

    public String toString() {
        return S.toString(TcpIgniteClient.class.getSimpleName(), "name", (Object)this.clientName, "clusterName", (Object)this.clusterName);
    }

    public String clusterName() {
        return this.clusterName;
    }

    @TestOnly
    public ClientMetricSource metrics() {
        return this.metrics;
    }

    public ReliableChannel channel() {
        return this.ch;
    }

    public <T extends ClientMessage> CompletableFuture<T> sendRequestAsync(int opCode, PayloadWriter writer, PayloadReader<T> reader) {
        return this.ch.serviceAsync(opCode, writer, reader);
    }

    public static ClusterNode unpackClusterNode(PayloadInputChannel r) {
        ClientMessageUnpacker in = r.in();
        int fieldCnt = r.in().unpackInt();
        assert (fieldCnt == 4);
        return new ClientClusterNode(in.unpackUuid(), in.unpackString(), new NetworkAddress(in.unpackString(), in.unpackInt()));
    }

    public long observableTimestamp() {
        return this.ch.observableTimestamp().get().longValue();
    }
}

