/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client;

public interface ClientCacheConfiguration {
    public static final int DFLT_WRITE_BEHIND_PARALLEL_OPERATIONS = 1024;

    public int cacheWriteBehindParallelOperations();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int cacheWriteBehindParallelOperations = 1024;

        public Builder cacheWriteBehindParallelOperations(int parallelism) {
            if (parallelism < 0) {
                throw new IllegalArgumentException("Write behind parallel operations [" + parallelism + "] must be a non-negative integer value.");
            }
            this.cacheWriteBehindParallelOperations = parallelism;
            return this;
        }

        public ClientCacheConfiguration build() {
            return new ClientCacheConfigurationImpl(this.cacheWriteBehindParallelOperations);
        }
    }

    public static class ClientCacheConfigurationImpl
    implements ClientCacheConfiguration {
        private final int cacheWriteBehindParallelOperations;

        ClientCacheConfigurationImpl(int cacheWriteBehindParallelOperations) {
            this.cacheWriteBehindParallelOperations = cacheWriteBehindParallelOperations;
        }

        @Override
        public int cacheWriteBehindParallelOperations() {
            return this.cacheWriteBehindParallelOperations;
        }
    }
}

